/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import com.google.common.collect.Lists;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.simpleyaml.configuration.file.YamlFile;

public class TextFile {
    private final CleanSS instance = CleanSS.getInstance();
    private final YamlFile yamlFile;
    private static final List<TextFile> list = Lists.newArrayList();

    public TextFile(Path path, String fileName) {
        Path configPath;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (!Files.exists(configPath = path.resolve(fileName), new LinkOption[0])) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);){
                Files.copy(Objects.requireNonNull(in), configPath, new CopyOption[0]);
            }
        }
        this.yamlFile = new YamlFile(configPath.toFile());
        this.yamlFile.load();
        list.add(this);
    }

    public YamlFile getConfig() {
        return this.yamlFile;
    }

    public void reload() {
        boolean first = VelocityConfig.MYSQL.get(Boolean.class);
        this.yamlFile.load();
        if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue() && !first) {
            this.instance.setData();
            this.instance.ControlTask();
        }
    }

    public static void reloadAll() {
        list.forEach(TextFile::reload);
    }
}

