/*
 * Decompiled with CFR 0.152.
 */
package dev.almostsomeone.timmyrespawn;

import dev.almostsomeone.timmyrespawn.EggHandler;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Egg {
    private final UUID owner;
    private UUID carrier;
    private Location location;
    private boolean spawned;
    private boolean hasSpawned;
    private final long expiryDate;

    public Egg(@Nonnull UUID owner) {
        this.owner = owner;
        this.carrier = null;
        this.location = null;
        this.spawned = false;
        this.hasSpawned = false;
        this.expiryDate = new Time(System.currentTimeMillis() + 86400000L).getTime();
    }

    public Egg(@Nonnull UUID owner, @Nonnull UUID carrier, @Nonnull Location location, boolean spawned, boolean hasSpawned, long expiryDate) {
        this.owner = owner;
        this.carrier = carrier;
        this.location = location;
        this.spawned = spawned;
        this.hasSpawned = hasSpawned;
        this.expiryDate = expiryDate;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setDropLocation(@Nonnull Location location) {
        this.carrier = null;
        this.location = location;
        this.spawned = false;
    }

    public Location getLocation() {
        Player player;
        OfflinePlayer offlinePlayer;
        if (this.location == null && this.carrier != null && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.carrier)).isOnline() && (player = offlinePlayer.getPlayer()) != null) {
            return player.getLocation();
        }
        return this.location;
    }

    public void setCarrier(@Nonnull UUID carrier) {
        this.carrier = carrier;
        this.location = null;
        this.spawned = false;
    }

    public void spawn(Location location) {
        if (this.hasSpawned) {
            return;
        }
        this.setDropLocation(location);
        this.spawned = true;
        this.spawnPlayer();
    }

    public void spawnPlayer() {
        if (!this.spawned || this.hasSpawned) {
            return;
        }
        if (!Bukkit.getOfflinePlayer((UUID)this.owner).isOnline()) {
            return;
        }
        EggHandler.remove(this);
        Objects.requireNonNull(Bukkit.getPlayer((UUID)this.owner)).setGameMode(GameMode.SURVIVAL);
        Objects.requireNonNull(Bukkit.getPlayer((UUID)this.owner)).teleport(this.location);
        this.hasSpawned = true;
    }

    public UUID getCarrier() {
        return this.carrier;
    }

    public boolean isExpired() {
        return new Date().getTime() > this.expiryDate;
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public boolean hasSpawned() {
        return this.hasSpawned;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public ItemStack getItemStack() {
        String playerName = "ERROR";
        try {
            playerName = Bukkit.getOfflinePlayer((UUID)this.owner).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack eggItem = new ItemStack(Material.VILLAGER_SPAWN_EGG);
        ItemMeta itemMeta = eggItem.getItemMeta();
        if (itemMeta != null) {
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77Use this egg to spawn");
            lore.add("\u00a77the player in at the");
            lore.add("\u00a77location you place it.");
            lore.add(" ");
            lore.add("\u00a77Expiration Date:");
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            lore.add("\u00a77 " + format.format(this.expiryDate));
            itemMeta.setLore(lore);
            itemMeta.setDisplayName("\u00a7a" + playerName + "'s Spawn Egg");
            eggItem.setItemMeta(itemMeta);
        }
        return eggItem;
    }
}

