/*
 * Decompiled with CFR 0.152.
 */
package dev.almostsomeone.timmyrespawn;

import dev.almostsomeone.timmyrespawn.Egg;
import dev.almostsomeone.timmyrespawn.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class EggHandler {
    private static final File dataFile = new File("plugins/RespawnEggs", "data.yml");
    private static final List<Egg> eggs = new ArrayList<Egg>();

    public static Egg create(UUID owner) {
        Egg egg = new Egg(owner);
        eggs.add(egg);
        return egg;
    }

    public static Egg get(UUID uuid) {
        return eggs.stream().filter(egg -> egg.getOwner().equals(uuid)).findFirst().orElse(null);
    }

    public static Egg get(ItemStack itemStack) {
        return eggs.stream().filter(egg -> egg.getItemStack().isSimilar(itemStack)).findFirst().orElse(null);
    }

    public static Egg isValid(UUID uuid) {
        return eggs.stream().filter(egg -> egg.getOwner().equals(uuid)).filter(egg -> !egg.isExpired()).filter(egg -> !egg.isSpawned()).findFirst().orElse(null);
    }

    public static Egg isValid(ItemStack itemStack) {
        return eggs.stream().filter(egg -> egg.getItemStack().isSimilar(itemStack)).filter(egg -> !egg.isExpired()).filter(egg -> !egg.isSpawned()).findFirst().orElse(null);
    }

    public static void remove(Egg egg) {
        eggs.remove(egg);
    }

    public static void prepareDrop(Item item) {
        Egg egg = EggHandler.get(item.getItemStack());
        if (egg == null) {
            return;
        }
        egg.setDropLocation(item.getLocation());
        item.setGlowing(true);
        item.setUnlimitedLifetime(true);
        item.setCustomName(Objects.requireNonNull(egg.getItemStack().getItemMeta()).getDisplayName());
        item.setCustomNameVisible(true);
        item.setInvulnerable(true);
        item.setTicksLived(Integer.MAX_VALUE);
        item.setPersistent(true);
        item.setMetadata("eggId", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(Main.class), (Object)egg.getOwner()));
    }

    public static void load(Plugin plugin) {
        if (!dataFile.exists()) {
            plugin.getLogger().log(Level.INFO, () -> "Creating data.yml file...");
            plugin.saveResource("data.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
        for (String key : config.getKeys(false)) {
            UUID owner = UUID.fromString(key);
            UUID carrier = UUID.fromString(config.getString(key + ".carrier", ""));
            Location location = null;
            boolean spawned = config.getBoolean(key + ".spawned", false);
            boolean hasSpawned = config.getBoolean(key + ".hasSpawned", false);
            long expiryDate = config.getLong(key + ".expiryDate", 0L);
            eggs.add(new Egg(owner, carrier, location, spawned, hasSpawned, expiryDate));
        }
    }

    public static void save() {
        YamlConfiguration config = new YamlConfiguration();
        for (Egg egg : eggs) {
            config.set(egg.getOwner().toString() + ".carrier", egg.getCarrier() == null ? null : egg.getCarrier().toString());
            config.set(egg.getOwner().toString() + ".location", (Object)egg.getLocation());
            config.set(egg.getOwner().toString() + ".spawned", (Object)egg.isSpawned());
            config.set(egg.getOwner().toString() + ".hasSpawned", (Object)egg.hasSpawned());
            config.set(egg.getOwner().toString() + ".expiryDate", (Object)egg.getExpiryDate());
        }
        try {
            config.save(dataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

