/*
 * Decompiled with CFR 0.152.
 */
package dev.almostsomeone.timmyrespawn.commands;

import dev.almostsomeone.timmyrespawn.ChatUtil;
import dev.almostsomeone.timmyrespawn.Egg;
import dev.almostsomeone.timmyrespawn.EggHandler;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EggCMD
implements CommandExecutor {
    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command cmd, @Nonnull String label, @Nonnull String[] args) {
        if (args.length > 1) {
            sender.sendMessage(ChatUtil.color("&cUsage: /egg [player]"));
            return true;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("respawneggs.command.other")) {
                sender.sendMessage(ChatUtil.color("&cYou do not have permission to use this command!"));
                return true;
            }
            try {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[0]);
                this.sendInformation(sender, EggHandler.isValid(offlinePlayer.getUniqueId()));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                sender.sendMessage(ChatUtil.color("&cThis player is not dead."));
            }
            return true;
        }
        try {
            this.sendInformation(sender, EggHandler.isValid(((Player)sender).getUniqueId()));
        }
        catch (NullPointerException e) {
            sender.sendMessage(ChatUtil.color("&cYou are not dead."));
        }
        return true;
    }

    private void sendInformation(CommandSender sender, Egg egg) {
        String ownerName = Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)egg.getOwner())).getName();
        sender.sendMessage(ChatUtil.color("&6Egg Information:"));
        sender.sendMessage(ChatUtil.color("&6Owner: &e" + ownerName));
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        sender.sendMessage(ChatUtil.color("&6Expires: &e" + format.format(egg.getExpiryDate())));
        if (egg.getCarrier() != null) {
            sender.sendMessage(ChatUtil.color("&6Carrier: &e" + Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)egg.getCarrier())).getName()));
        } else {
            sender.sendMessage(ChatUtil.color("&6Location:"));
            sender.sendMessage(ChatUtil.color("&6 *&e World: " + Objects.requireNonNull(egg.getLocation().getWorld()).getName()));
            sender.sendMessage(ChatUtil.color("&6 *&e X: " + egg.getLocation().getBlockX()));
            sender.sendMessage(ChatUtil.color("&6 *&e Y: " + egg.getLocation().getBlockY()));
            sender.sendMessage(ChatUtil.color("&6 *&e Z: " + egg.getLocation().getBlockZ()));
        }
    }
}

