/*
 * Decompiled with CFR 0.152.
 */
package dev.almostsomeone.timmyrespawn.listeners;

import dev.almostsomeone.timmyrespawn.ChatUtil;
import dev.almostsomeone.timmyrespawn.EggHandler;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryCloseListener
implements Listener {
    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTopInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        if (event.getView().getBottomInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        for (int ti = 0; ti < topInventory.getSize(); ++ti) {
            ItemStack itemStack = topInventory.getItem(ti);
            if (itemStack == null || EggHandler.isValid(itemStack) == null) continue;
            event.getPlayer().sendMessage(ChatUtil.color("&cYou cannot store an egg while it is still unexpired."));
            topInventory.setItem(ti, null);
            Inventory bottomInventory = event.getView().getBottomInventory();
            int firstEmpty = bottomInventory.firstEmpty();
            if (firstEmpty == -1) {
                event.getPlayer().sendMessage(ChatUtil.color("&4You had no inventory space so the egg has been dropped."));
                Item item = event.getPlayer().getWorld().dropItem(event.getPlayer().getLocation(), itemStack);
                EggHandler.prepareDrop(item);
                continue;
            }
            bottomInventory.setItem(firstEmpty, itemStack);
        }
    }
}

