/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettermodsbutton.client.handler;

import fuzs.bettermodsbutton.config.MainMenuMode;
import fuzs.bettermodsbutton.config.ModCountMode;
import fuzs.bettermodsbutton.config.PauseScreenMode;
import fuzs.bettermodsbutton.services.ClientAbstractions;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class ModsButtonHandler {
    /*
     * Enabled aggressive block sorting
     */
    public static void onAfterInitScreen(Minecraft minecraft, Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            if (screen.getClass() == TitleScreen.class) {
                ModsButtonHandler.handleMainMenu(titleScreen, list, add::accept, remove);
                return;
            }
        }
        if (!(screen instanceof PauseScreen)) return;
        PauseScreen pauseScreen = (PauseScreen)screen;
        if (screen.getClass() != PauseScreen.class) return;
        if (!pauseScreen.showsPauseMenu()) return;
        ModsButtonHandler.handlePauseScreen(pauseScreen, list, add::accept, remove);
    }

    private static void handleMainMenu(TitleScreen screen, List<GuiEventListener> children, Consumer<Button> addListener, Consumer<GuiEventListener> removeListener) {
        Button newModsButton;
        if (ClientAbstractions.INSTANCE.getClientConfig().getMainMenuMode().get() == MainMenuMode.NO_CHANGE) {
            return;
        }
        Button modsButton = ModsButtonHandler.findButton(children, "fml.menu.mods");
        if (modsButton != (newModsButton = ClientAbstractions.INSTANCE.getNewModsButton((Screen)screen, modsButton))) {
            removeListener.accept((GuiEventListener)modsButton);
            addListener.accept(newModsButton);
            modsButton = newModsButton;
        }
        Button realmsButton = ModsButtonHandler.findButton(children, "menu.online");
        int fallbackRealmsButtonY = screen.height / 4 + 48 + 48;
        if (realmsButton != null && modsButton.getY() != realmsButton.getY()) {
            ModsButtonHandler.moveButtonsUpAndDown((Screen)screen, children, -11, modsButton.getY());
            ModsButtonHandler.moveButtonsUpAndDown((Screen)screen, children, 5, 0);
        }
        Optional.ofNullable(ModsButtonHandler.findButton(children, "Create Test World")).ifPresent(removeListener);
        switch (ClientAbstractions.INSTANCE.getClientConfig().getMainMenuMode().get()) {
            case INSERT_BELOW_REALMS: {
                ModsButtonHandler.moveButtonsUpAndDown((Screen)screen, children, modsButton.getY() + modsButton.getHeight());
                modsButton.setWidth(200);
                modsButton.setX(screen.width / 2 - 100);
                if (realmsButton != null) {
                    modsButton.setY(realmsButton.getY() + 24);
                    realmsButton.setWidth(200);
                    realmsButton.setX(screen.width / 2 - 100);
                    if (screen.realmsNotificationsScreen == null) break;
                    screen.realmsNotificationsScreen.height += 16;
                    break;
                }
                modsButton.setY(fallbackRealmsButtonY + 24);
                break;
            }
            case LEFT_TO_REALMS: {
                modsButton.setWidth(98);
                modsButton.setX(screen.width / 2 - 100);
                if (realmsButton != null) {
                    modsButton.setY(realmsButton.getY());
                    realmsButton.setWidth(98);
                    realmsButton.setX(screen.width / 2 + 2);
                    screen.realmsNotificationsScreen = null;
                    break;
                }
                modsButton.setY(fallbackRealmsButtonY);
                break;
            }
            case RIGHT_TO_REALMS: {
                modsButton.setWidth(98);
                modsButton.setX(screen.width / 2 + 2);
                if (realmsButton != null) {
                    modsButton.setY(realmsButton.getY());
                    realmsButton.setWidth(98);
                    realmsButton.setX(screen.width / 2 - 100);
                    screen.realmsNotificationsScreen = null;
                    break;
                }
                modsButton.setY(fallbackRealmsButtonY);
                break;
            }
            case REPLACE_REALMS: {
                if (realmsButton != null) {
                    ModsButtonHandler.copyButtonProperties(realmsButton, modsButton);
                    modsButton.setWidth(200);
                    modsButton.setX(screen.width / 2 - 100);
                    removeListener.accept((GuiEventListener)realmsButton);
                    screen.realmsNotificationsScreen = null;
                    break;
                }
                ModsButtonHandler.initButtonProperties(modsButton, screen.width / 2 - 100, fallbackRealmsButtonY, 200, 20);
                break;
            }
            case NONE: {
                removeListener.accept((GuiEventListener)modsButton);
                if (realmsButton == null) break;
                realmsButton.setWidth(200);
                realmsButton.setX(screen.width / 2 - 100);
            }
        }
        ModsButtonHandler.setModsButtonComponent(modsButton);
    }

    private static void handlePauseScreen(PauseScreen screen, List<GuiEventListener> children, Consumer<Button> addListener, Consumer<GuiEventListener> removeListener) {
        Button newModsButton;
        if (ClientAbstractions.INSTANCE.getClientConfig().getPauseScreenMode().get() == PauseScreenMode.NO_CHANGE) {
            return;
        }
        Button modsButton = ModsButtonHandler.findButton(children, "fml.menu.mods");
        if (modsButton != null) {
            ModsButtonHandler.moveButtonsUpAndDown((Screen)screen, children, -12, modsButton.getY());
        }
        if (modsButton != (newModsButton = ClientAbstractions.INSTANCE.getNewModsButton((Screen)screen, modsButton))) {
            removeListener.accept((GuiEventListener)modsButton);
            addListener.accept(newModsButton);
            modsButton = newModsButton;
        }
        switch (ClientAbstractions.INSTANCE.getClientConfig().getPauseScreenMode().get()) {
            case INSERT_BELOW_FEEDBACK_AND_BUGS: {
                Button feedbackButton = ModsButtonHandler.findButton(children, "menu.sendFeedback");
                if (feedbackButton != null) {
                    ModsButtonHandler.copyButtonProperties(feedbackButton, modsButton);
                    ModsButtonHandler.moveButtonsUpAndDown((Screen)screen, children, feedbackButton.getY() + feedbackButton.getHeight());
                    modsButton.setWidth(204);
                    modsButton.setY(modsButton.getY() + 24);
                    break;
                }
                removeListener.accept((GuiEventListener)modsButton);
                break;
            }
            case REPLACE_FEEDBACK: {
                Button feedbackButton = ModsButtonHandler.findButton(children, "menu.sendFeedback");
                if (feedbackButton != null) {
                    ModsButtonHandler.copyButtonProperties(feedbackButton, modsButton);
                    removeListener.accept((GuiEventListener)feedbackButton);
                    break;
                }
                removeListener.accept((GuiEventListener)modsButton);
                break;
            }
            case REPLACE_BUGS: {
                Button bugsButton = ModsButtonHandler.findButton(children, "menu.reportBugs");
                if (bugsButton != null) {
                    ModsButtonHandler.copyButtonProperties(bugsButton, modsButton);
                    removeListener.accept((GuiEventListener)bugsButton);
                    break;
                }
                removeListener.accept((GuiEventListener)modsButton);
                break;
            }
            case REPLACE_FEEDBACK_AND_BUGS: {
                Button feedbackButton = ModsButtonHandler.findButton(children, "menu.sendFeedback");
                Button bugsButton = ModsButtonHandler.findButton(children, "menu.reportBugs");
                if (feedbackButton != null && bugsButton != null) {
                    ModsButtonHandler.copyButtonProperties(feedbackButton, modsButton);
                    modsButton.setWidth(204);
                    removeListener.accept((GuiEventListener)feedbackButton);
                    removeListener.accept((GuiEventListener)bugsButton);
                    break;
                }
                removeListener.accept((GuiEventListener)modsButton);
                break;
            }
            case REPLACE_AND_MOVE_LAN: {
                Button shareToLanButton = ModsButtonHandler.findButton(children, "menu.shareToLan");
                if (shareToLanButton == null) {
                    shareToLanButton = ModsButtonHandler.findButton(children, "menu.playerReporting");
                }
                if (shareToLanButton != null) {
                    ModsButtonHandler.copyButtonProperties(shareToLanButton, modsButton);
                    Button feedbackButton = ModsButtonHandler.findButton(children, "menu.sendFeedback");
                    Button bugsButton = ModsButtonHandler.findButton(children, "menu.reportBugs");
                    if (feedbackButton != null && bugsButton != null) {
                        ModsButtonHandler.copyButtonProperties(feedbackButton, shareToLanButton);
                        shareToLanButton.setWidth(204);
                        removeListener.accept((GuiEventListener)feedbackButton);
                        removeListener.accept((GuiEventListener)bugsButton);
                        break;
                    }
                    removeListener.accept((GuiEventListener)shareToLanButton);
                    break;
                }
                removeListener.accept((GuiEventListener)modsButton);
                break;
            }
            case INSERT_AND_MOVE_LAN: {
                Button shareToLanButton = ModsButtonHandler.findButton(children, "menu.shareToLan");
                if (shareToLanButton == null) {
                    shareToLanButton = ModsButtonHandler.findButton(children, "menu.playerReporting");
                }
                if (shareToLanButton != null) {
                    ModsButtonHandler.copyButtonProperties(shareToLanButton, modsButton);
                    Button feedbackButton = ModsButtonHandler.findButton(children, "menu.sendFeedback");
                    if (feedbackButton != null) {
                        ModsButtonHandler.moveButtonsUpAndDown((Screen)screen, children, shareToLanButton.getY());
                        ModsButtonHandler.copyButtonProperties(feedbackButton, shareToLanButton);
                        shareToLanButton.setWidth(204);
                        shareToLanButton.setY(shareToLanButton.getY() + 24);
                        break;
                    }
                    removeListener.accept((GuiEventListener)shareToLanButton);
                    break;
                }
                removeListener.accept((GuiEventListener)modsButton);
                break;
            }
            case NONE: {
                removeListener.accept((GuiEventListener)modsButton);
            }
        }
        ModsButtonHandler.setModsButtonComponent(modsButton);
    }

    private static void moveButtonsUpAndDown(Screen screen, List<GuiEventListener> listeners, int splitAt) {
        ModsButtonHandler.moveButtonsUpAndDown(screen, listeners, 12, splitAt);
    }

    private static void moveButtonsUpAndDown(Screen screen, List<GuiEventListener> listeners, int moveAmount, int splitAt) {
        for (GuiEventListener widget : listeners) {
            LayoutElement element;
            if (!(widget instanceof LayoutElement) || ModsButtonHandler.isElementTooCloseToScreenBorder(element = (LayoutElement)widget, screen.width, screen.height)) continue;
            if (splitAt <= element.getY()) {
                element.setY(element.getY() + moveAmount);
                continue;
            }
            element.setY(element.getY() - moveAmount);
        }
    }

    private static boolean isElementTooCloseToScreenBorder(LayoutElement element, int screenWidth, int screenHeight) {
        int safeArea;
        ScreenRectangle rectangle = element.getRectangle();
        ScreenRectangle intersection = rectangle.intersection(new ScreenRectangle(safeArea = ClientAbstractions.INSTANCE.getClientConfig().getSafeArea().get().intValue(), safeArea, Math.max(0, screenWidth -= 2 * safeArea), Math.max(0, screenHeight -= 2 * safeArea)));
        return intersection == null || !intersection.equals((Object)rectangle);
    }

    private static void copyButtonProperties(Button from, Button to) {
        ModsButtonHandler.initButtonProperties(to, from.getX(), from.getY(), from.getWidth(), from.getHeight());
    }

    private static void initButtonProperties(Button button, int x, int y, int width, int height) {
        button.setPosition(x, y);
        button.setWidth(width);
        button.setHeight(height);
    }

    @Nullable
    private static Button findButton(List<GuiEventListener> widgets, String buttonKey) {
        for (GuiEventListener widget : widgets) {
            PlainTextContents.LiteralContents contents;
            TranslatableContents contents2;
            if (!(widget instanceof Button)) continue;
            Button button = (Button)widget;
            ComponentContents componentContents = button.getMessage().getContents();
            if (componentContents instanceof TranslatableContents && (contents2 = (TranslatableContents)componentContents).getKey().equals(buttonKey)) {
                return button;
            }
            componentContents = button.getMessage().getContents();
            if (!(componentContents instanceof PlainTextContents.LiteralContents) || !(contents = (PlainTextContents.LiteralContents)componentContents).text().equals(buttonKey)) continue;
            return button;
        }
        return null;
    }

    private static void setModsButtonComponent(Button modsButton) {
        ModCountMode modCountMode = ClientAbstractions.INSTANCE.getClientConfig().getModCountMode().get();
        Component title = ModsButtonHandler.getModsComponent(modCountMode, modsButton.getWidth() < 200);
        modsButton.setMessage(title);
    }

    private static Component getModsComponent(ModCountMode modCountMode, boolean isCompact) {
        MutableComponent component = Component.translatable((String)"fml.menu.mods");
        String string = modCountMode.getString(isCompact);
        if (string != null) {
            return component.append((Component)Component.literal((String)string));
        }
        return component;
    }
}

