/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supermodpack.init;

import net.mcreator.supermodpack.potion.CatAllergyMobEffect;
import net.mcreator.supermodpack.potion.FeatherFallingMobEffect;
import net.mcreator.supermodpack.potion.FloatingMobEffect;
import net.mcreator.supermodpack.potion.GravityMobEffect;
import net.mcreator.supermodpack.potion.ObeisityMobEffect;
import net.mcreator.supermodpack.potion.PeanutAllergyMobEffect;
import net.mcreator.supermodpack.potion.SliperyMobEffect;
import net.mcreator.supermodpack.procedures.FloatingEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class SuperModpackModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"super_modpack");
    public static final DeferredHolder<MobEffect, MobEffect> CAT_ALLERGY = REGISTRY.register("cat_allergy", () -> new CatAllergyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PEANUT_ALLERGY = REGISTRY.register("peanut_allergy", () -> new PeanutAllergyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GRAVITY = REGISTRY.register("gravity", () -> new GravityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SLIPERY = REGISTRY.register("slipery", () -> new SliperyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> OBEISITY = REGISTRY.register("obeisity", () -> new ObeisityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FLOATING = REGISTRY.register("floating", () -> new FloatingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FEATHER_FALLING = REGISTRY.register("feather_falling", () -> new FeatherFallingMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            SuperModpackModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            SuperModpackModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(FLOATING)) {
            FloatingEffectExpiresProcedure.execute(entity);
        }
    }
}

