/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supermodpack.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import net.mcreator.supermodpack.init.SuperModpackModItems;
import net.mcreator.supermodpack.procedures.BullChestplateTickEventProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class BullItem
extends ArmorItem {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(16, Map.of(ArmorType.BOOTS, 2, ArmorType.LEGGINGS, 30, ArmorType.CHESTPLATE, 36, ArmorType.HELMET, 12, ArmorType.BODY, 36), 9, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY), 0.0f, 0.2f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"super_modpack:bull_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"super_modpack:bull")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"super_modpack:textures/models/armor/bull_layer_1.png");
            }
        }, new Item[]{(Item)SuperModpackModItems.BULL_CHESTPLATE.get()});
    }

    private BullItem(ArmorType type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Chestplate
    extends BullItem {
        public Chestplate(Item.Properties properties) {
            super(ArmorType.CHESTPLATE, properties);
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                BullChestplateTickEventProcedure.execute(entity);
            }
        }
    }
}

