/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.submersible.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.submersible.init.SubmersibleModBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.util.TriState;

public class AncientStoneBlock
extends FallingBlock {
    public static final MapCodec<AncientStoneBlock> CODEC = AncientStoneBlock.simpleCodec(AncientStoneBlock::new);

    public MapCodec<AncientStoneBlock> codec() {
        return CODEC;
    }

    public AncientStoneBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.TUFF).strength(1.0f, 10.0f).lightLevel(s -> 15).speedFactor(1.5f).jumpFactor(1.5f).pushReaction(PushReaction.DESTROY).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.UNPASSABLE_RAIL;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, BlockState plant) {
        return TriState.TRUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : -12012264, new Block[]{(Block)SubmersibleModBlocks.ANCIENT_STONE.get()});
    }
}

