/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.submersible.entity;

import com.mojang.serialization.DynamicOps;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.mcreator.submersible.SubmersibleMod;
import net.mcreator.submersible.init.SubmersibleModEntities;
import net.mcreator.submersible.init.SubmersibleModItems;
import net.mcreator.submersible.procedures.AnglerfishVibrationReceivedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class AnglerfishEntity
extends Monster
implements VibrationSystem {
    public final AnimationState animationState0 = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();

    public AnglerfishEntity(EntityType<AnglerfishEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (AnglerfishEntity.this.isInWater()) {
                    AnglerfishEntity.this.setDeltaMovement(AnglerfishEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !AnglerfishEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - AnglerfishEntity.this.getX();
                    double dy = this.wantedY - AnglerfishEntity.this.getY();
                    double dz = this.wantedZ - AnglerfishEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * AnglerfishEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    AnglerfishEntity.this.setYRot(this.rotlerp(AnglerfishEntity.this.getYRot(), f, 10.0f));
                    AnglerfishEntity.this.yBodyRot = AnglerfishEntity.this.getYRot();
                    AnglerfishEntity.this.yHeadRot = AnglerfishEntity.this.getYRot();
                    if (AnglerfishEntity.this.isInWater()) {
                        AnglerfishEntity.this.setSpeed((float)AnglerfishEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        AnglerfishEntity.this.setXRot(this.rotlerp(AnglerfishEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(AnglerfishEntity.this.getXRot() * ((float)Math.PI / 180)));
                        AnglerfishEntity.this.setZza(f3 * f1);
                        AnglerfishEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        AnglerfishEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    AnglerfishEntity.this.setSpeed(0.0f);
                    AnglerfishEntity.this.setYya(0.0f);
                    AnglerfishEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, true));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)SubmersibleModItems.WATER_SICKEL.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"ambient.cave"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"ambient.underwater.loop")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"ambient.underwater.enter"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"ambient.underwater.exit"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.vibrationData).resultOrPartial(e -> SubmersibleMod.LOGGER.error("Failed to encode vibration listener for Anglerfish: '{}'", e)).ifPresent(listener -> compound.put("listener", listener));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.getCompound("listener")).resultOrPartial(e -> SubmersibleMod.LOGGER.error("Failed to parse vibration listener for Anglerfish: '{}'", e)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> listenerConsumer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            listenerConsumer.accept(this.dynamicGameEventListener, serverLevel);
        }
    }

    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VibrationSystem.Ticker.tick((Level)serverLevel, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AnglerfishEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AnglerfishEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SubmersibleModEntities.ANGLERFISH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (EntitySpawnReason)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.0);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.0);
        return builder;
    }

    private class VibrationUser
    implements VibrationSystem.User {
        private final AnglerfishEntity entity;
        private final PositionSource positionSource;

        private VibrationUser() {
            this.entity = AnglerfishEntity.this;
            this.positionSource = new EntityPositionSource((Entity)this.entity, this.entity.getEyeHeight());
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public int getListenerRadius() {
            return 7;
        }

        public boolean canReceiveVibration(ServerLevel world, BlockPos vibrationPos, Holder<GameEvent> holder, GameEvent.Context context) {
            return true;
        }

        public void onReceiveVibration(ServerLevel world, BlockPos vibrationPos, Holder<GameEvent> holder, @Nullable Entity vibrationSource, @Nullable Entity projectileShooter, float distance) {
            AnglerfishVibrationReceivedProcedure.execute((LevelAccessor)world, this.entity.getX(), this.entity.getY(), this.entity.getZ());
        }
    }
}

