/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.submersible.fluid;

import net.mcreator.submersible.init.SubmersibleModBlocks;
import net.mcreator.submersible.init.SubmersibleModFluidTypes;
import net.mcreator.submersible.init.SubmersibleModFluids;
import net.mcreator.submersible.init.SubmersibleModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class DarkWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)SubmersibleModFluidTypes.DARK_WATER_TYPE.get(), () -> (Fluid)SubmersibleModFluids.DARK_WATER.get(), () -> (Fluid)SubmersibleModFluids.FLOWING_DARK_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)SubmersibleModItems.DARK_WATER_BUCKET.get()).block(() -> (LiquidBlock)SubmersibleModBlocks.DARK_WATER.get());

    private DarkWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    public static class Flowing
    extends DarkWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends DarkWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

