/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.submersible.init;

import net.mcreator.submersible.entity.AnglerfishEntity;
import net.mcreator.submersible.entity.GiantSquidEntity;
import net.mcreator.submersible.entity.SubmarineEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SubmersibleModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"submersible");
    public static final DeferredHolder<EntityType<?>, EntityType<SubmarineEntity>> SUBMARINE = SubmersibleModEntities.register("submarine", EntityType.Builder.of(SubmarineEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(5.0f, 5.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<AnglerfishEntity>> ANGLERFISH = SubmersibleModEntities.register("anglerfish", EntityType.Builder.of(AnglerfishEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<GiantSquidEntity>> GIANT_SQUID = SubmersibleModEntities.register("giant_squid", EntityType.Builder.of(GiantSquidEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(200).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"submersible", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SubmarineEntity.init(event);
        AnglerfishEntity.init(event);
        GiantSquidEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SUBMARINE.get(), SubmarineEntity.createAttributes().build());
        event.put((EntityType)ANGLERFISH.get(), AnglerfishEntity.createAttributes().build());
        event.put((EntityType)GIANT_SQUID.get(), GiantSquidEntity.createAttributes().build());
    }
}

