/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.StatProvider;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleTypes;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.interpreter.ContextManager;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.PokeMathMax;
import com.gitlab.srcmc.rctapi.api.ai.utils.RBMoveList;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import kotlin.Unit;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunBunAI
implements BattleAI {
    private static boolean registered = false;
    private static final Random RANDOM = new Random();
    private static boolean hasResetDefault = false;
    private static int battleTurn = 1;
    private static PokemonBattle pb = null;
    private static int turnsForActivePokemon = 1;
    private static boolean hasUsedMega = false;
    private static boolean hasUsedTera = false;
    private static UUID currentPokemonUUID = null;
    private static boolean switchedLastTurn = false;
    private static Map<Integer, String> moveHistory = new HashMap<Integer, String>();
    private static Map<Integer, String> moveHistoryEnemy = new HashMap<Integer, String>();
    private static Map<Stat, Integer> npcStages = new HashMap<Stat, Integer>();
    private static Map<Stat, Integer> opponentStages = new HashMap<Stat, Integer>();
    private static Map<BattlePokemon, Boolean> isAlive = new HashMap<BattlePokemon, Boolean>();
    private static final Map<String, String> statIdMap = Map.of("atk", "attack", "def", "defence", "spa", "special_attack", "spd", "special_defence", "spe", "speed", "eva", "evasion", "acc", "accuracy");
    private static final Map<ElementalType, Map<ElementalType, Double>> typeChart = new HashMap<ElementalType, Map<ElementalType, Double>>();
    private static final List<String> priorityDamageMoves = RBMoveList.getPriorityDamageMoves();
    private static final List<String> abilityStatBooster = RBMoveList.getAbilityStatBooster();
    private static final List<String> highCriticalMoves = RBMoveList.getHighCriticalMoves();
    private static final List<String> trapMoves = RBMoveList.getTrapMoves();
    private static final List<String> speedReductionMoves = RBMoveList.getSpeedReductionMoves();
    private static final List<String> physicalAttackReductionMoves = RBMoveList.getPhysicalAttackReductionMoves();
    private static final List<String> specialAttackReductionMoves = RBMoveList.getSpecialAttackReductionMoves();
    private static final List<String> generalSetupMoves = RBMoveList.getGeneralSetupMoves();
    private static final List<String> ignoreStatDropAbilities = RBMoveList.getIgnoreStatDropAbilities();
    private static final List<String> specialFunctionMoves = RBMoveList.getSpecialFunctionMoves();
    private static final List<String> soundMoves = RBMoveList.getSoundMoves();
    private static final List<String> flinchMoves = RBMoveList.getFlinchMoves();
    private static final List<String> thawingMoves = RBMoveList.getThawingMoves();
    private static final List<String> rechargeMoves = RBMoveList.getRechargeMoves();
    private static final List<String> recoveryMoves = RBMoveList.getRecoveryMoves();
    private static final List<String> megaStones = RBMoveList.getMegaStones();
    private static final List<String> ignoreDamageMoves = RBMoveList.getIgnoreDamageMoves();
    private static final List<String> ignoreSleepAbilities = RBMoveList.getIgnoreSleepAbilities();
    private static final List<String> statusMoves = RBMoveList.getStatusMoves();

    public RunBunAI() {
        if (!registered) {
            CobblemonEvents.BATTLE_STARTED_PRE.subscribe(Priority.NORMAL, event -> {
                System.out.println("Battle is about to start! Players: " + String.valueOf(event.getBattle().getPlayers()));
                RunBunAI.setHasResetDefault(false);
                return Unit.INSTANCE;
            });
            registered = true;
        }
    }

    public static void setHasResetDefault(boolean hasResetDefault) {
        RunBunAI.hasResetDefault = hasResetDefault;
    }

    @NotNull
    public ShowdownActionResponse choose(@NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable PokemonBattle battle, @Nullable BattleSide aiSide, @Nullable ShowdownMoveset moveset, boolean forceSwitch) {
        if (!hasResetDefault) {
            hasResetDefault = true;
            currentPokemonUUID = null;
            battleTurn = 1;
            turnsForActivePokemon = 1;
            hasUsedMega = false;
            hasUsedTera = false;
            moveHistory = new HashMap<Integer, String>();
            moveHistoryEnemy = new HashMap<Integer, String>();
            pb = null;
            switchedLastTurn = false;
            isAlive = new HashMap<BattlePokemon, Boolean>();
        }
        ModCommon.LOG.info("started showdown response.");
        String currentHeldItem = "";
        String currentAbility = "";
        ElementalType activePrimaryType = null;
        ElementalType activeSecondaryType = null;
        double activePokemonPercentHP = 0.0;
        double activePokemonCurrentHP = 0.0;
        ActiveBattlePokemon NPCPartner = null;
        String gimmick = null;
        BattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
        BattleFormat bf = new BattleFormat();
        boolean isDoubles = bf.getBattleType() == BattleTypes.INSTANCE.getDOUBLES();
        String getOpponentHeldItem = "";
        ActiveBattlePokemon opponentPartner = null;
        List<Move> oppMoves = new ArrayList();
        double oppMaxDamage = 0.0;
        String opponentAbility = "";
        double oppPercentHP = 0.0;
        ElementalTypes elementaltypes = ElementalTypes.INSTANCE;
        List NPCParty = activeBattlePokemon.getActor().getPokemonList().stream().toList();
        List<BattlePokemon> aliveParty = activeBattlePokemon.getActor().getPokemonList().stream().filter(BattlePokemon::canBeSentOut).toList();
        Optional<ActiveBattlePokemon> opponentActiveBattlePokemon = StreamSupport.stream(activeBattlePokemon.getAllActivePokemon().spliterator(), false).filter(abp -> !abp.isAllied((Targetable)activeBattlePokemon)).findFirst();
        List<ActiveBattlePokemon> allNPCActiveBattlePokemon = StreamSupport.stream(activeBattlePokemon.getAllActivePokemon().spliterator(), false).filter(abp -> abp.isAllied((Targetable)activeBattlePokemon)).toList();
        List<ActiveBattlePokemon> allOpponentActiveBattlePokemon = StreamSupport.stream(activeBattlePokemon.getAllActivePokemon().spliterator(), false).filter(abp -> !abp.isAllied((Targetable)activeBattlePokemon)).toList();
        int currentBattleSlot = allNPCActiveBattlePokemon.indexOf(activeBattlePokemon) != -1 ? allNPCActiveBattlePokemon.indexOf(activeBattlePokemon) : 0;
        BattlePokemon opponent = allOpponentActiveBattlePokemon.isEmpty() ? null : allOpponentActiveBattlePokemon.get(currentBattleSlot).getBattlePokemon();
        for (BattlePokemon battlePokemon2 : NPCParty) {
            if (battlePokemon2.getHealth() <= 0) {
                isAlive.put(battlePokemon2, false);
                continue;
            }
            isAlive.put(battlePokemon2, true);
        }
        if (battlePokemon != null) {
            if (pb == null) {
                pb = opponent.getActor().getBattle();
            }
            if (currentPokemonUUID == null) {
                currentPokemonUUID = battlePokemon.getUuid();
            } else if (currentPokemonUUID != battlePokemon.getUuid()) {
                turnsForActivePokemon = 1;
                currentPokemonUUID = battlePokemon.getUuid();
            }
            activePrimaryType = battlePokemon.getEffectedPokemon().getPrimaryType();
            activeSecondaryType = battlePokemon.getEffectedPokemon().getSecondaryType();
            activePokemonPercentHP = RunBunAI.getCurrentPercentHP(battlePokemon);
            activePokemonCurrentHP = battlePokemon.getHealth();
            currentAbility = battlePokemon.getEffectedPokemon().getAbility().getDisplayName();
            npcStages = RunBunAI.getStageMap(battlePokemon);
            if (battlePokemon.getHeldItemManager().showdownId(battlePokemon) != null) {
                currentHeldItem = battlePokemon.getHeldItemManager().showdownId(battlePokemon);
                if (megaStones.contains(currentHeldItem) && turnsForActivePokemon == 1 && !hasUsedMega) {
                    gimmick = ShowdownMoveset.Gimmick.MEGA_EVOLUTION.getId();
                    hasUsedMega = true;
                } else if (!megaStones.contains(currentHeldItem) && RunBunAI.getCurrentPercentHP(battlePokemon) >= 50.0 && !hasUsedTera && battlePokemon.getEffectedPokemon().getLevel() > 35) {
                    gimmick = ShowdownMoveset.Gimmick.TERASTALLIZATION.getId();
                    hasUsedTera = true;
                } else {
                    gimmick = null;
                }
                ModCommon.LOG.info("Held item: " + currentHeldItem);
                ModCommon.LOG.info("Pokemon Level: " + battlePokemon.getEffectedPokemon().getLevel());
            }
        }
        ModCommon.LOG.info("Current Battle Turn: " + Integer.toString(battleTurn) + "    Turns Since This mon has been on field: " + Integer.toString(turnsForActivePokemon));
        if (opponent != null) {
            BattlePokemon mon;
            String type;
            BattleMessage msg;
            opponentStages = RunBunAI.getStageMap(opponent);
            getOpponentHeldItem = opponent.getHeldItemManager().showdownId(opponent) != null ? opponent.getHeldItemManager().showdownId(opponent) : "";
            for (Map.Entry entry2 : pb.getMinorBattleActions().entrySet()) {
                msg = (BattleMessage)entry2.getValue();
                type = msg.getId();
                mon = msg.battlePokemon(0, pb);
                if (!"-miss".equals(type) && !"-immune".equals(type) && !"-fail".equals(type) || !mon.getUuid().equals(opponent.getUuid())) continue;
                moveHistoryEnemy.put(Math.max(battleTurn - 1, 1), type);
            }
            for (Map.Entry entry3 : pb.getMajorBattleActions().entrySet()) {
                msg = (BattleMessage)entry3.getValue();
                type = msg.getId();
                mon = msg.battlePokemon(0, pb);
                if ("move".equals(type) && mon.getUuid() == opponent.getUuid()) {
                    String string = msg.moveAt(1).getName() != null ? msg.moveAt(1).getName() : null;
                    moveHistoryEnemy.put(Math.max(battleTurn - 1, 1), string);
                    continue;
                }
                if (!"move".equals(type) || mon.getUuid() != currentPokemonUUID) continue;
                String string = msg.moveAt(1).getName() != null ? msg.moveAt(1).getName() : null;
                moveHistory.put(Math.max(turnsForActivePokemon - 1, 1), string);
            }
            for (Map.Entry entry4 : moveHistoryEnemy.entrySet()) {
                String moveName = (String)entry4.getValue();
                int turn = (Integer)entry4.getKey();
                ModCommon.LOG.info("Turn: " + turn + "   ::   ENEMY used move " + moveName);
            }
        }
        if (isDoubles) {
            int partnerSlot = currentBattleSlot == 0 ? 1 : 0;
            boolean bl = false;
            opponentPartner = allOpponentActiveBattlePokemon.get(partnerSlot);
            NPCPartner = allNPCActiveBattlePokemon.get(partnerSlot);
        }
        String NPCPartnerAbility = NPCPartner != null ? NPCPartner.getBattlePokemon().getEffectedPokemon().getAbility().getDisplayName() : "";
        String string = NPCPartner != null && NPCPartner.getBattlePokemon().getHeldItemManager().showdownId(NPCPartner.getBattlePokemon()) != null ? NPCPartner.getBattlePokemon().getHeldItemManager().showdownId(NPCPartner.getBattlePokemon()) : "";
        boolean oppHasSpecialMove = false;
        boolean oppHasPhysicalMove = false;
        if (opponent != null) {
            oppMoves = opponent.getMoveSet().getMoves();
            if (battlePokemon != null) {
                for (Move move2 : oppMoves) {
                    if (!((double)PokeMathMax.damage(opponent, battlePokemon, move2, opponentStages, npcStages) > oppMaxDamage)) continue;
                    oppMaxDamage = PokeMathMax.damage(opponent, battlePokemon, move2, opponentStages, npcStages);
                }
            }
            opponentAbility = opponent.getEffectedPokemon().getAbility().getDisplayName();
            oppPercentHP = RunBunAI.getCurrentPercentHP(opponent);
            String damageCategory = "";
            for (Move opponentMove : oppMoves) {
                damageCategory = opponentMove.getDamageCategory().getName();
                if (damageCategory.equals(DamageCategories.INSTANCE.getPHYSICAL().getName())) {
                    oppHasPhysicalMove = true;
                }
                if (!damageCategory.equals(DamageCategories.INSTANCE.getSPECIAL().getName())) continue;
                oppHasSpecialMove = true;
            }
        }
        ArrayList<BattlePokemon> canSwitchTo = new ArrayList<BattlePokemon>();
        for (Map.Entry<BattlePokemon, Boolean> entry3 : isAlive.entrySet()) {
            if (!entry3.getValue().booleanValue() || entry3.getKey() == battlePokemon) continue;
            canSwitchTo.addLast(entry3.getKey());
        }
        HashMap<BattlePokemon, Integer> hashMap = new HashMap<BattlePokemon, Integer>();
        int switchScore = 0;
        boolean isSwitchMonFaster = false;
        boolean doesSwitchOHKO = false;
        boolean doesOppOHKO = false;
        BattlePokemon nextPokemon = null;
        for (BattlePokemon possibleSwitch : canSwitchTo) {
            switchScore = 0;
            if (battlePokemon != null) {
                isSwitchMonFaster = BattleEffects.Field.Room.trickroom(battlePokemon) ? RunBunAI.getInBattleSpeed(possibleSwitch) <= RunBunAI.getInBattleSpeed(opponent) : RunBunAI.getInBattleSpeed(possibleSwitch) >= RunBunAI.getInBattleSpeed(opponent);
            }
            doesSwitchOHKO = RunBunAI.isOHKO(possibleSwitch.getMoveSet().getMoves(), possibleSwitch, opponent, npcStages, opponentStages);
            doesOppOHKO = RunBunAI.isOHKO(oppMoves, opponent, possibleSwitch, opponentStages, npcStages);
            if (isSwitchMonFaster && doesSwitchOHKO) {
                switchScore += 5;
            } else if (!isSwitchMonFaster && !doesOppOHKO && doesSwitchOHKO) {
                switchScore += 4;
            } else if (isSwitchMonFaster && RunBunAI.highestPercentDamageMove(possibleSwitch, opponent) > RunBunAI.highestPercentDamageMove(opponent, possibleSwitch)) {
                switchScore += 3;
            } else if (!isSwitchMonFaster && RunBunAI.highestPercentDamageMove(possibleSwitch, opponent) > RunBunAI.highestPercentDamageMove(opponent, possibleSwitch)) {
                switchScore += 2;
            } else if (isSwitchMonFaster) {
                ++switchScore;
            } else if (!isSwitchMonFaster && doesOppOHKO) {
                --switchScore;
            }
            if (possibleSwitch.getName().equals((Object)"ditto")) {
                switchScore += 2;
            }
            if (isSwitchMonFaster && !doesOppOHKO && (possibleSwitch.getName().equals((Object)"wynaut") || possibleSwitch.getName().equals((Object)"wobbuffet"))) {
                switchScore += 2;
            }
            hashMap.put(possibleSwitch, switchScore);
        }
        int maxSwitchingScore = hashMap.values().stream().max(Integer::compareTo).orElse(Integer.MIN_VALUE);
        List<BattlePokemon> bestSwitches = hashMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == maxSwitchingScore).map(Map.Entry::getKey).toList();
        if (!bestSwitches.isEmpty()) {
            nextPokemon = bestSwitches.getFirst();
        }
        if (forceSwitch || activeBattlePokemon.isGone()) {
            if (canSwitchTo.isEmpty()) {
                return PassActionResponse.INSTANCE;
            }
            if (opponent == null) {
                if (!canSwitchTo.isEmpty()) {
                    nextPokemon = bestSwitches.getFirst();
                }
                nextPokemon.setWillBeSwitchedIn(true);
                moveHistory = new HashMap<Integer, String>();
                switchedLastTurn = true;
                return new SwitchActionResponse(nextPokemon.getUuid());
            }
            if (nextPokemon == null) {
                if (!canSwitchTo.isEmpty()) {
                    nextPokemon = bestSwitches.getFirst();
                } else {
                    return PassActionResponse.INSTANCE;
                }
            }
            nextPokemon.setWillBeSwitchedIn(true);
            moveHistory = new HashMap<Integer, String>();
            switchedLastTurn = true;
            return new SwitchActionResponse(nextPokemon.getUuid());
        }
        if (moveset == null) {
            return PassActionResponse.INSTANCE;
        }
        if (moveset.moves.size() == 1 && ((InBattleMove)moveset.moves.get(0)).getId().equals("recharge")) {
            RunBunAI.changeTurn(battlePokemon);
            return new MoveActionResponse("recharge", null, gimmick);
        }
        List<InBattleMove> inBattleMoves = moveset.moves.stream().filter(InBattleMove::canBeUsed).filter(inBattleMove -> {
            List targetList = (List)inBattleMove.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
            return inBattleMove.mustBeUsed() || targetList == null || !targetList.isEmpty();
        }).toList();
        if (inBattleMoves.isEmpty()) {
            return new MoveActionResponse("struggle", null, gimmick);
        }
        if (opponentActiveBattlePokemon.isEmpty()) {
            RunBunAI.changeTurn(battlePokemon);
            return new MoveActionResponse(inBattleMoves.get((int)RunBunAI.RANDOM.nextInt((int)moveset.moves.size())).id, null, gimmick);
        }
        if (opponent == null) {
            return new MoveActionResponse(inBattleMoves.get((int)RunBunAI.RANDOM.nextInt((int)moveset.moves.size())).id, null, gimmick);
        }
        HashMap moveMap = new HashMap();
        IntStream.range(0, inBattleMoves.size()).forEach(i -> moveMap.put((InBattleMove)inBattleMoves.get(i), Moves.INSTANCE.all().stream().filter(move -> move.getName().equals(((InBattleMove)inBattleMoves.get(i)).getId())).findFirst().get().create()));
        HashMap<InBattleMove, Integer> moveDamages = new HashMap<InBattleMove, Integer>();
        inBattleMoves.forEach(inBattleMove -> {
            int dmg = PokeMathMax.damage(battlePokemon, opponent, (Move)moveMap.get(inBattleMove), npcStages, opponentStages);
            if (ignoreDamageMoves.contains(inBattleMove.getId()) || trapMoves.contains(inBattleMove.getId())) {
                moveDamages.put((InBattleMove)inBattleMove, 0);
            } else {
                moveDamages.put((InBattleMove)inBattleMove, dmg);
            }
            ModCommon.LOG.info(inBattleMove.getId() + "     DAMAGE = " + Integer.toString(dmg));
        });
        ArrayList killingMoves = new ArrayList();
        moveDamages.forEach((move, damage) -> {
            if (damage >= opponent.getHealth()) {
                killingMoves.add(move);
            }
        });
        HashMap<InBattleMove, Integer> moveScores = new HashMap<InBattleMove, Integer>();
        boolean isFaster = false;
        if (battlePokemon != null) {
            isFaster = BattleEffects.Field.Room.trickroom(battlePokemon) ? RunBunAI.getInBattleSpeed(battlePokemon) <= RunBunAI.getInBattleSpeed(opponent) : RunBunAI.getInBattleSpeed(battlePokemon) >= RunBunAI.getInBattleSpeed(opponent);
        }
        boolean npcIsOHKO = RunBunAI.isOHKO(oppMoves, opponent, battlePokemon, opponentStages, npcStages);
        boolean npcIs2OHKO = RunBunAI.is2HKO(oppMoves, opponent, battlePokemon, opponentStages, npcStages);
        boolean npcIs3OHKO = RunBunAI.is3HKO(oppMoves, opponent, battlePokemon, opponentStages, npcStages);
        boolean npcIsOHKOWithSS = RunBunAI.wouldBeOHKOAfterShellSmash(oppMoves, opponent, battlePokemon, opponentStages, npcStages);
        boolean npcIsOHKOWithBD = RunBunAI.isOHKOAfterBellyDrum(oppMoves, opponent, battlePokemon, opponentStages, npcStages);
        ArrayList<InBattleMove> nonKillingPossibleMoves = new ArrayList<InBattleMove>();
        int maxDamage = 0;
        InBattleMove maxMove = null;
        if (killingMoves.isEmpty()) {
            Iterator<Object> iterator = moveDamages.values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                maxDamage = maxDamage >= n ? maxDamage : n;
            }
            for (Map.Entry entry5 : moveDamages.entrySet()) {
                String name = ((InBattleMove)entry5.getKey()).getId().toLowerCase(Locale.ROOT).trim();
                if (trapMoves.contains(name) || physicalAttackReductionMoves.contains(name) || specialAttackReductionMoves.contains(name) || speedReductionMoves.contains(name) || specialFunctionMoves.contains(name) || generalSetupMoves.contains(name)) {
                    nonKillingPossibleMoves.add((InBattleMove)entry5.getKey());
                    continue;
                }
                if ((Integer)entry5.getValue() != maxDamage) continue;
                nonKillingPossibleMoves.add((InBattleMove)entry5.getKey());
                maxMove = (InBattleMove)entry5.getKey();
            }
        }
        for (Map.Entry entry6 : moveDamages.entrySet()) {
            InBattleMove currentMove = (InBattleMove)entry6.getKey();
            int moveDamage = (Integer)entry6.getValue();
            int score = 0;
            if (TypeChart.getEffectiveness(TypeChart.getMove(currentMove).getType(), opponent) == 0.0) {
                moveScores.put(currentMove, -20);
                continue;
            }
            if (killingMoves.contains(currentMove)) {
                double roll = RANDOM.nextDouble();
                int n = score = roll > 0.2 ? 6 : 8;
                score = isFaster ? (score += 6) : (priorityDamageMoves.contains(currentMove.getId()) ? (score += 6) : (score += 3));
                if (currentMove.getId().equals("pursuit")) {
                    score = 10;
                }
            }
            if (!nonKillingPossibleMoves.isEmpty() && nonKillingPossibleMoves.contains(currentMove)) {
                String moveID = currentMove.getId();
                double roll = RANDOM.nextDouble();
                if (maxMove != null && maxMove == currentMove) {
                    roll = RANDOM.nextDouble();
                    score += roll > 0.2 ? 6 : 8;
                }
                if (trapMoves.contains(moveID)) {
                    score += roll > 0.2 ? 6 : 8;
                }
                if (speedReductionMoves.contains(moveID)) {
                    score = moveDamages.getOrDefault(currentMove, 0) == maxDamage ? (score += (roll = RANDOM.nextDouble()) > 0.2 ? 6 : 8) : (score += !ignoreStatDropAbilities.contains(opponentAbility) && !isFaster ? 6 : 5);
                }
                if (physicalAttackReductionMoves.contains(moveID) || specialAttackReductionMoves.contains(moveID)) {
                    if (moveDamages.getOrDefault(currentMove, 0) == maxDamage) {
                        roll = RANDOM.nextDouble();
                        score += roll > 0.2 ? 6 : 8;
                    } else if (!ignoreStatDropAbilities.contains(opponentAbility)) {
                        if (specialAttackReductionMoves.contains(moveID) && oppHasSpecialMove) {
                            score += 6;
                        } else if (physicalAttackReductionMoves.contains(moveID) && oppHasPhysicalMove) {
                            score += 6;
                        }
                    } else if (ignoreStatDropAbilities.contains(opponentAbility)) {
                        score += 5;
                    }
                }
                boolean isOPFrozen = BattleEffects.Pokemon.Status.frz(opponent);
                boolean isOPSleeping = BattleEffects.Pokemon.Status.slp(opponent);
                boolean isFirstTurnOut = turnsForActivePokemon == 1;
                String moveUsedLastTurn = moveHistory.getOrDefault(turnsForActivePokemon - 1, "");
                String moveUsed2TurnsAgo = moveHistory.getOrDefault(turnsForActivePokemon - 2, "");
                String moveUsed3TurnsAgo = moveHistory.getOrDefault(turnsForActivePokemon - 3, "");
                if (specialFunctionMoves.contains(moveID)) {
                    switch (moveID) {
                        case "futuresight": {
                            score += isFaster && npcIsOHKO ? 8 : 6;
                            break;
                        }
                        case "relicsong": {
                            score += battlePokemon.getName().equals((Object)"meloetta") ? 10 : 0;
                            break;
                        }
                        case "suckerpunch": 
                        case "thunderclap": {
                            if (!moveUsedLastTurn.equals("suckerpunch") && !moveUsedLastTurn.equals("thunderclap")) break;
                            score += roll < 0.5 ? -20 : 0;
                            break;
                        }
                        case "pursuit": {
                            if (oppPercentHP <= 20.0) {
                                score += 10;
                                break;
                            }
                            if (!(oppPercentHP <= 40.0)) break;
                            roll = RANDOM.nextDouble();
                            score += roll < 0.5 ? 8 : 0;
                            break;
                        }
                        case "fellstinger": {
                            int result2;
                            roll = RANDOM.nextDouble();
                            int result1 = roll > 0.8 ? 23 : 21;
                            int n = result2 = roll > 0.8 ? 17 : 15;
                            if ((Integer)battlePokemon.getStatChanges().get(Stats.ATTACK) == 6) break;
                            score += isFaster ? result1 : result2;
                            break;
                        }
                        case "rollout": {
                            score += 7;
                            break;
                        }
                        case "stealthrock": {
                            roll = RANDOM.nextDouble();
                            score = isFirstTurnOut && RunBunAI.getHazardCount(moveHistory, "stealthrock") == 0 ? (score += roll > 0.75 ? 8 : 9) : (score += roll > 0.75 ? 6 : 7);
                            if (RunBunAI.getHazardCount(moveHistory, "stealthrock") == 0) break;
                            score -= 20;
                            break;
                        }
                        case "spikes": {
                            roll = RANDOM.nextDouble();
                            int spikesCount = RunBunAI.getHazardCount(moveHistory, "spikes");
                            ModCommon.LOG.info("Spikes Count = " + spikesCount);
                            score = isFirstTurnOut ? (score += roll > 0.75 ? 8 : 9) : (score += roll > 0.75 ? 6 : 7);
                            if (spikesCount == 3) {
                                score -= 20;
                                break;
                            }
                            if (spikesCount <= 0) break;
                            --score;
                            break;
                        }
                        case "toxicspikes": {
                            roll = RANDOM.nextDouble();
                            int toxicspikesCount = RunBunAI.getHazardCount(moveHistory, "toxicspikes");
                            score = isFirstTurnOut ? (score += roll > 0.75 ? 8 : 9) : (score += roll > 0.75 ? 6 : 7);
                            if (toxicspikesCount == 3) {
                                score -= 20;
                                break;
                            }
                            if (toxicspikesCount <= 0) break;
                            --score;
                            break;
                        }
                        case "stickyweb": {
                            roll = RANDOM.nextDouble();
                            score = isFirstTurnOut ? (score += roll > 0.75 ? 9 : 12) : (score += roll > 0.75 ? 6 : 9);
                            if (RunBunAI.getHazardCount(moveHistory, "stickyweb") == 0) break;
                            score -= 20;
                            break;
                        }
                        case "kingsshield": 
                        case "protect": 
                        case "spikyshield": 
                        case "silktrap": 
                        case "detect": 
                        case "banefulbunker": 
                        case "burningbulwark": 
                        case "obstruct": {
                            score += 6;
                            if (BattleEffects.Pokemon.Volatile.cursed(battlePokemon) || BattleEffects.Pokemon.Volatile.yawn(battlePokemon) || BattleEffects.Pokemon.Volatile.leech(battlePokemon) || BattleEffects.Pokemon.Volatile.attract(battlePokemon) || BattleEffects.Pokemon.Status.brn(battlePokemon) || BattleEffects.Pokemon.Status.psn(battlePokemon) || BattleEffects.Pokemon.Status.tox(battlePokemon)) {
                                if (activePokemonPercentHP <= 25.0) {
                                    score -= 20;
                                }
                                score -= 2;
                            }
                            if (BattleEffects.Pokemon.Volatile.cursed(opponent) || BattleEffects.Pokemon.Volatile.yawn(opponent) || BattleEffects.Pokemon.Volatile.leech(opponent) || BattleEffects.Pokemon.Volatile.attract(opponent) || BattleEffects.Pokemon.Status.brn(opponent) || BattleEffects.Pokemon.Status.psn(opponent) || BattleEffects.Pokemon.Status.tox(opponent)) {
                                ++score;
                            }
                            if (RunBunAI.isSandstormFatal(battlePokemon, activePrimaryType, activeSecondaryType, activePokemonPercentHP)) {
                                score -= 20;
                            }
                            if (!isDoubles && isFirstTurnOut) {
                                --score;
                            }
                            if (moveHistory.isEmpty()) break;
                            if (moveUsed2TurnsAgo == moveID && moveUsedLastTurn == moveID) {
                                score -= 20;
                                break;
                            }
                            if (moveUsed2TurnsAgo == moveID || moveUsedLastTurn != moveID) break;
                            score += roll > 0.5 ? -20 : 0;
                            break;
                        }
                        case "fling": {
                            if (currentHeldItem != null) break;
                            double flingEffectiveness = TypeChart.getEffectiveness(TypeChart.getMove(currentMove).getType(), opponent);
                            if (!battlePokemon.getEffectedPokemon().heldItem().method_31574((class_1792)CobblemonItems.SALAC_BERRY) || !(flingEffectiveness <= 1.0)) break;
                            score += 9;
                            break;
                        }
                        case "roleplay": {
                            Set<String> RPAbilities = Set.of("hugepower", "purepower", "protean", "toughclaws");
                            if (!RPAbilities.contains(currentAbility) && RPAbilities.contains(NPCPartnerAbility)) {
                                score += 9;
                                break;
                            }
                            score -= 20;
                            break;
                        }
                        case "shadowsneak": 
                        case "aquajet": 
                        case "iceshard": {
                            if (!string.equals("weaknesspolicy") || !(TypeChart.getEffectiveness(currentMove, NPCPartner.getBattlePokemon()) > 1.0)) break;
                            score = 12;
                            break;
                        }
                        case "magnitude": 
                        case "earthquake": {
                            break;
                        }
                        case "imprison": {
                            int commonMoves = 0;
                            for (InBattleMove imprisonSet : moveDamages.keySet()) {
                                if (!oppMoves.contains(TypeChart.getMove(imprisonSet))) continue;
                                ++commonMoves;
                            }
                            score += commonMoves > 0 ? 9 : -20;
                            break;
                        }
                        case "batonpass": {
                            if (aliveParty.isEmpty()) {
                                score -= 20;
                                break;
                            }
                            Map statChanges = battlePokemon.getStatChanges();
                            boolean anyPositive = false;
                            for (Integer value : statChanges.values()) {
                                if (value <= 0) continue;
                                anyPositive = true;
                            }
                            if (aliveParty.isEmpty() || !anyPositive) break;
                            score += 14;
                            break;
                        }
                        case "tailwind": {
                            if (RunBunAI.isPartySlowerThanOpponent(allNPCActiveBattlePokemon, allOpponentActiveBattlePokemon)) {
                                score += 9;
                                break;
                            }
                            score += 5;
                            break;
                        }
                        case "trickroom": {
                            score = RunBunAI.isPartySlowerThanOpponent(allNPCActiveBattlePokemon, allOpponentActiveBattlePokemon) ? (score += 10) : (score += 5);
                            if (!BattleEffects.Field.Room.trickroom(battlePokemon)) break;
                            score -= 20;
                            break;
                        }
                        case "fakeout": {
                            if (!opponentAbility.equals("shielddust") && !opponentAbility.equals("innerfocus") && !getOpponentHeldItem.equals("covertcloak") || !isFirstTurnOut) break;
                            score += 9;
                            break;
                        }
                        case "helpinghand": {
                            if (currentBattleSlot != 1) break;
                            break;
                        }
                        case "finalgambit": {
                            if (isFaster && battlePokemon.getHealth() >= opponent.getHealth()) {
                                score += 8;
                                break;
                            }
                            if (isFaster && npcIsOHKO) {
                                score += 7;
                                break;
                            }
                            score += 6;
                            break;
                        }
                        case "electricterrain": {
                            if (BattleEffects.Field.Terrain.electricterrain(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("terrainextender")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "psychicterrain": {
                            if (BattleEffects.Field.Terrain.psychicterrain(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("terrainextender")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "grassyterrain": {
                            if (BattleEffects.Field.Terrain.grassyterrain(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("terrainextender")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "mistyterrain": {
                            if (BattleEffects.Field.Terrain.mistyterrain(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("terrainextender")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "raindance": {
                            if (BattleEffects.Field.Weather.rain(battlePokemon) || BattleEffects.Field.Weather.heavyrain(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("damprock")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "sunnyday": {
                            if (BattleEffects.Field.Weather.harshsunlight(battlePokemon) || BattleEffects.Field.Weather.extremelyharshsunlight(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("heatrock")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "hail": {
                            if (BattleEffects.Field.Weather.hail(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("icyrock")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "chillyreception": {
                            if (BattleEffects.Field.Weather.snow(battlePokemon) && (!npcIsOHKO || !isFaster)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("icyrock")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "sandstorm": {
                            if (BattleEffects.Field.Weather.sandstorm(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("smoothrock")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "snowscape": {
                            if (BattleEffects.Field.Weather.snow(battlePokemon)) break;
                            if (currentHeldItem != null && currentHeldItem.equals("terrainextender")) {
                                score += 9;
                                break;
                            }
                            score += 8;
                            break;
                        }
                        case "lightscreen": {
                            roll = RANDOM.nextDouble();
                            score += 6;
                            boolean lightclayLS = currentHeldItem.equals("lightclay");
                            if (lightclayLS) {
                                if (RunBunAI.getIsMoveUp(moveID, moveHistory, 8, battleTurn)) {
                                    score = -20;
                                }
                            } else if (RunBunAI.getIsMoveUp(moveID, moveHistory, 5, battleTurn)) {
                                score = -20;
                            }
                            if (!oppHasSpecialMove) break;
                            if (lightclayLS) {
                                ++score;
                            }
                            score += roll > 0.5 ? 1 : 0;
                            break;
                        }
                        case "reflect": {
                            roll = RANDOM.nextDouble();
                            score += 6;
                            boolean lightclayR = currentHeldItem.equals("lightclay");
                            if (lightclayR) {
                                if (RunBunAI.getIsMoveUp(moveID, moveHistory, 8, battleTurn)) {
                                    score = -20;
                                }
                            } else if (RunBunAI.getIsMoveUp(moveID, moveHistory, 5, battleTurn)) {
                                score = -20;
                            }
                            if (!oppHasPhysicalMove) break;
                            if (lightclayR) {
                                ++score;
                            }
                            score += roll > 0.5 ? 1 : 0;
                            break;
                        }
                        case "substitute": {
                            roll = RANDOM.nextDouble();
                            score += 6;
                            if (BattleEffects.Pokemon.Status.slp(opponent)) {
                                score += 2;
                            }
                            if (BattleEffects.Pokemon.Volatile.leech(opponent)) {
                                score += 2;
                            }
                            if (oppMoves.contains(soundMoves)) {
                                score -= 8;
                            }
                            if (activePokemonPercentHP <= 50.0 || opponentAbility.equals("infiltrator")) {
                                score = -20;
                            }
                            score -= roll > 0.5 ? 1 : 0;
                            break;
                        }
                        case "explosion": 
                        case "selfdestruct": 
                        case "mistyexplosion": {
                            roll = RANDOM.nextDouble();
                            if (aliveParty.isEmpty() && (!allOpponentActiveBattlePokemon.isEmpty() || !aliveParty.isEmpty())) break;
                            score = activePokemonPercentHP < 10.0 ? (score += 10) : (activePokemonPercentHP < 33.0 ? (score += roll > 0.3 ? 8 : 0) : (activePokemonPercentHP < 66.0 ? (score += roll > 0.5 ? 7 : 0) : (score += roll > 0.95 ? 7 : 0)));
                            if (!aliveParty.isEmpty()) break;
                            --score;
                            break;
                        }
                        case "memento": {
                            if (aliveParty.isEmpty()) break;
                            roll = RANDOM.nextDouble();
                            if (activePokemonPercentHP < 10.0) {
                                score += 16;
                                break;
                            }
                            if (activePokemonPercentHP < 33.0) {
                                score += roll > 0.3 ? 14 : 6;
                                break;
                            }
                            if (activePokemonPercentHP < 66.0) {
                                score += roll > 0.5 ? 13 : 6;
                                break;
                            }
                            score += roll > 0.05 ? 13 : 6;
                            break;
                        }
                        case "thunderwave": 
                        case "stunspore": 
                        case "glare": 
                        case "nuzzle": 
                        case "zapcannon": {
                            if (BattleEffects.Pokemon.Status.any(opponent)) break;
                            roll = RANDOM.nextDouble();
                            int paraRoll = roll > 0.5 ? -1 : 0;
                            boolean fasterIfPara = false;
                            boolean hasFlinchMove = moveDamages.entrySet().stream().anyMatch(entry -> flinchMoves.contains(((InBattleMove)entry.getKey()).getId()) && (Integer)entry.getValue() > 0);
                            if (RunBunAI.getInBattleSpeed(opponent) / 4.0 < RunBunAI.getInBattleSpeed(battlePokemon)) {
                                fasterIfPara = true;
                            }
                            score = !isFaster && fasterIfPara || RunBunAI.hasMove(battlePokemon, "hex") || hasFlinchMove || BattleEffects.Pokemon.Volatile.attract(opponent) || BattleEffects.Pokemon.Volatile.confusion(opponent) ? (score += 8) : (score += 7);
                            score += paraRoll;
                            break;
                        }
                        case "willowisp": {
                            if (BattleEffects.Pokemon.Status.any(opponent)) break;
                            score += 6;
                            roll = RANDOM.nextDouble();
                            if (!(roll < 0.37)) break;
                            if (RunBunAI.hasMove(battlePokemon, "hex") || isDoubles && RunBunAI.hasMove(NPCPartner.getBattlePokemon(), "hex")) {
                                ++score;
                            }
                            if (!oppHasPhysicalMove) break;
                            ++score;
                            break;
                        }
                        case "trick": 
                        case "switcheroo": {
                            if (currentHeldItem == null) break;
                            if (currentHeldItem.equals("toxicorb") || currentHeldItem.equals("flameorb") || currentHeldItem.equals("blacksludge")) {
                                roll = RANDOM.nextDouble();
                                score += roll > 0.5 ? 6 : 7;
                                break;
                            }
                            if (currentHeldItem.equals("ironball") || currentHeldItem.equals("laggingtail") || currentHeldItem.equals("stickybarb")) {
                                score += 7;
                                break;
                            }
                            score += 5;
                            break;
                        }
                        case "yawn": 
                        case "darkvoid": 
                        case "sleeppowder": 
                        case "hypnosis": 
                        case "lovelykiss": 
                        case "spore": 
                        case "grasswhistle": {
                            boolean oppGrass;
                            score += 6;
                            roll = RANDOM.nextDouble();
                            boolean oppPartnerHasFlowerVeil = opponentPartner.getBattlePokemon().getEffectedPokemon().getAbility().equals("flowerveil");
                            boolean bl = oppGrass = opponent.getEffectedPokemon().getPrimaryType() == elementaltypes.getGRASS() || opponent.getEffectedPokemon().getSecondaryType() == elementaltypes.getGRASS();
                            if (BattleEffects.Pokemon.Status.any(opponent) || !(roll < 0.25) || BattleEffects.Field.Terrain.mistyterrain(opponent) && (!BattleEffects.Field.Terrain.mistyterrain(opponent) || opponent.getEffectedPokemon().getPrimaryType() != elementaltypes.getFLYING() && opponent.getEffectedPokemon().getSecondaryType() != elementaltypes.getFLYING()) || BattleEffects.Field.Terrain.electricterrain(opponent) && (!BattleEffects.Field.Terrain.electricterrain(opponent) || opponent.getEffectedPokemon().getPrimaryType() != elementaltypes.getFLYING() && opponent.getEffectedPokemon().getSecondaryType() != elementaltypes.getFLYING()) || ignoreSleepAbilities.contains(opponentAbility) || !((InBattleMove)entry6.getKey()).getId().equals("hypnosis") && !((InBattleMove)entry6.getKey()).getId().equals("spore") || opponentAbility.equals("magicbounce") || !((InBattleMove)entry6.getKey()).getId().equals("grasswhistle") && !((InBattleMove)entry6.getKey()).getId().equals("sing") || opponentAbility.equals("soundproof") || opponentAbility.equals("leafguard") && (!opponentAbility.equals("leafguard") || BattleEffects.Field.Weather.harshsunlight(opponent) || BattleEffects.Field.Weather.extremelyharshsunlight(opponent)) || isDoubles && (!isDoubles || oppGrass && (oppPartnerHasFlowerVeil || !oppGrass))) break;
                            ++score;
                            if (RunBunAI.hasMove(battlePokemon, "dreameater") || RunBunAI.hasMove(battlePokemon, "nightmare") && (!RunBunAI.hasMove(opponent, "snore") || !RunBunAI.hasMove(opponent, "sleeptalk"))) {
                                ++score;
                            }
                            if (!isDoubles || !RunBunAI.hasMove(NPCPartner.getBattlePokemon(), "hex")) break;
                            ++score;
                            break;
                        }
                        case "poisongas": 
                        case "poisonpowder": 
                        case "toxic": {
                            score += 6;
                            roll = RANDOM.nextDouble();
                            boolean hasDamagingMoves = false;
                            boolean hasCertainMove = false;
                            if (!(roll < 0.38) || !killingMoves.isEmpty() || BattleEffects.Pokemon.Status.any(opponent) || !(RunBunAI.getCurrentPercentHP(opponent) > 20.0)) break;
                            for (Move oppMove : oppMoves) {
                                if (!(oppMove.getPower() > 0.0)) continue;
                                hasDamagingMoves = true;
                            }
                            for (InBattleMove ourMoves : nonKillingPossibleMoves) {
                                if (!ourMoves.getId().equals("venomdrench") && !ourMoves.getId().equals("hex") && !ourMoves.getId().equals("venoshock")) continue;
                                hasCertainMove = true;
                            }
                            if (!hasDamagingMoves || !hasCertainMove || !currentAbility.equals("merciless")) break;
                            score += 2;
                            break;
                        }
                        case "counter": {
                            boolean hasOnlyPhys = oppHasPhysicalMove && !oppHasSpecialMove;
                            score += 6;
                            if (npcIsOHKO) {
                                score -= 20;
                            }
                            if (hasOnlyPhys && (currentHeldItem.equals("focussash") || currentAbility.equals("sturdy") && activePokemonPercentHP == 100.0)) {
                                score += 2;
                            }
                            if (!npcIsOHKO && hasOnlyPhys) {
                                score += roll > 0.2 ? 2 : 0;
                            }
                            if (isFaster) {
                                score += roll > 0.75 ? -1 : 0;
                            }
                            if (!RunBunAI.hasAnyMoveType(opponent, statusMoves)) break;
                            score += roll > 0.75 ? -1 : 0;
                            break;
                        }
                        case "mirrorcoat": {
                            boolean hasOnlySpecial = !oppHasPhysicalMove && oppHasSpecialMove;
                            score += 6;
                            if (npcIsOHKO) {
                                score -= 20;
                            }
                            if (hasOnlySpecial && (currentHeldItem.equals("focussash") || currentAbility.equals("sturdy") && activePokemonPercentHP == 100.0)) {
                                score += 2;
                            }
                            if (!npcIsOHKO && hasOnlySpecial) {
                                score += roll > 0.2 ? 2 : 0;
                            }
                            if (isFaster) {
                                score += roll > 0.75 ? -1 : 0;
                            }
                            if (!RunBunAI.hasAnyMoveType(opponent, statusMoves)) break;
                            score += roll > 0.75 ? -1 : 0;
                            break;
                        }
                        case "ruination": {
                            roll = RANDOM.nextDouble();
                            if (opponent.getHealth() / 2 <= maxDamage) break;
                            score += roll > 0.4 ? 9 : 7;
                            break;
                        }
                        case "revivalblessing": {
                            break;
                        }
                        case "shedtail": {
                            if (isFaster) {
                                score = activePokemonPercentHP > 0.5 && (double)maxDamage < oppMaxDamage ? (score += 8) : (score -= 20);
                            }
                            if (isFaster) break;
                            if (activePokemonCurrentHP - oppMaxDamage > 0.5 && (double)maxDamage < oppMaxDamage) {
                                score += 8;
                                break;
                            }
                            score -= 20;
                        }
                    }
                }
                String lastTurnMove = moveHistoryEnemy.getOrDefault(battleTurn - 1, "");
                boolean isRecharging = false;
                boolean isLoafing = false;
                if (turnsForActivePokemon % 2 == 0 && opponentAbility.equals("truant")) {
                    isLoafing = true;
                }
                if (rechargeMoves.contains(lastTurnMove) && (lastTurnMove != "-miss" || lastTurnMove != "-immune" || lastTurnMove != "-fail")) {
                    isRecharging = true;
                }
                if (generalSetupMoves.contains(moveID)) {
                    boolean hasThawingMove = false;
                    for (String m : thawingMoves) {
                        if (!oppMoves.contains(m)) continue;
                        hasThawingMove = true;
                        break;
                    }
                    if (currentAbility.equals("contrary") && score != 0) {
                        switch (moveID) {
                            case "overheat": 
                            case "leafstorm": {
                                score += 6;
                                if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                    score += 3;
                                } else if (!npcIs3OHKO) {
                                    ++score;
                                    if (isFaster) {
                                        ++score;
                                    }
                                }
                                if (!isFaster && npcIs2OHKO) {
                                    score -= 5;
                                }
                                if (npcStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) < 2) break;
                                --score;
                                break;
                            }
                            case "superpower": {
                                score += 6;
                                if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                    score += 3;
                                } else if (!npcIs3OHKO) {
                                    ++score;
                                    if (isFaster) {
                                        ++score;
                                    }
                                }
                                if (!isFaster && npcIs2OHKO) {
                                    score -= 5;
                                }
                                if (npcStages.getOrDefault(Stats.ATTACK, 0) < 2) break;
                                --score;
                            }
                        }
                    }
                    if (npcIsOHKO) {
                        score -= 20;
                    }
                    if (opponentAbility.equals("unaware")) {
                        score -= 20;
                    }
                    switch (moveID) {
                        case "swordsdance": 
                        case "howl": 
                        case "sharpen": 
                        case "meditate": 
                        case "honeclaws": {
                            score += 6;
                            if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                score += 3;
                            }
                            if (isFaster || !npcIs2OHKO) break;
                            score -= 5;
                            break;
                        }
                        case "dragondance": 
                        case "shiftgear": 
                        case "tidyup": {
                            score += 6;
                            if (moveID.equals("shiftgear")) {
                                if (RunBunAI.fasterAndOHKOAfterBoost(battlePokemon, opponent, 2, 1, 0)) {
                                    score += 5;
                                }
                            } else if (RunBunAI.fasterAndOHKOAfterBoost(battlePokemon, opponent, 1, 1, 0)) {
                                score += 5;
                            }
                            if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                score += 3;
                            }
                            if (!isFaster && npcIs2OHKO) {
                                score -= 5;
                            }
                            if (npcStages.getOrDefault(Stats.ATTACK, 0) < 2 && npcStages.getOrDefault(Stats.SPEED, 0) < 2) break;
                            score -= 3;
                            break;
                        }
                        case "acidarmor": 
                        case "barrier": 
                        case "cottonguard": 
                        case "harden": 
                        case "irondefense": 
                        case "stockpile": 
                        case "cosmicpower": {
                            roll = RANDOM.nextDouble();
                            score += 6;
                            if (!isFaster && npcIs2OHKO) {
                                score -= 5;
                            }
                            if (!(roll > 0.05)) break;
                            if (isOPFrozen || isOPSleeping) {
                                score += 2;
                            }
                            if (!moveID.equals("stockpile") && !moveID.equals("cosmicpower") || npcStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0) >= 2 && npcStages.getOrDefault(Stats.DEFENCE, 0) >= 2) break;
                            score += 2;
                            break;
                        }
                        case "coil": 
                        case "bulkup": 
                        case "calmmind": 
                        case "curse": {
                            score += 6;
                            if ((oppHasPhysicalMove && !oppHasSpecialMove || !oppHasPhysicalMove && !oppHasSpecialMove) && moveID.equals("calmmind")) {
                                if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                    score += 3;
                                }
                                if (!isFaster && npcIs2OHKO) {
                                    score -= 5;
                                }
                            } else if (!oppHasPhysicalMove && oppHasSpecialMove && moveID.equals("calmmind")) {
                                roll = RANDOM.nextDouble();
                                if (!isFaster && npcIs2OHKO) {
                                    score -= 5;
                                }
                                if (roll > 0.05 && (isOPFrozen || isOPSleeping)) {
                                    score += 2;
                                }
                            }
                            if ((oppHasSpecialMove && !oppHasPhysicalMove || !oppHasPhysicalMove && !oppHasSpecialMove) && (moveID.equals("coil") || moveID.equals("bulkup") || moveID.equals("curse"))) {
                                if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                    score += 3;
                                }
                                if (isFaster || !npcIs2OHKO) break;
                                score -= 5;
                                break;
                            }
                            if (oppHasSpecialMove || !oppHasPhysicalMove || !moveID.equals("coil") && !moveID.equals("bulkup") && !moveID.equals("noretreat") && !moveID.equals("curse")) break;
                            roll = RANDOM.nextDouble();
                            if (!isFaster && npcIs2OHKO) {
                                score -= 5;
                            }
                            if (!(roll > 0.05) || !isOPFrozen && !isOPSleeping) break;
                            score += 2;
                            break;
                        }
                        case "quiverdance": 
                        case "geomancy": {
                            score += 6;
                            if (moveID.equals("geomancy")) {
                                score = RunBunAI.fasterAndOHKOAfterBoost(battlePokemon, opponent, 2, 2, 2) && "powerherb".equals(currentHeldItem) ? (score += 5) : (score -= 20);
                            } else if (RunBunAI.fasterAndOHKOAfterBoost(battlePokemon, opponent, 1, 1, 1)) {
                                score += 5;
                            }
                            if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                score += 3;
                            }
                            if (!isFaster && npcIs2OHKO) {
                                score -= 5;
                            }
                            if (npcStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0) < 2 && npcStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) < 2 && npcStages.getOrDefault(Stats.SPEED, 0) < 2) break;
                            score -= 3;
                            break;
                        }
                        case "noretreat": {
                            score += 6;
                            if (RunBunAI.fasterAndOHKOAfterBoost(battlePokemon, opponent, 1, 1, 1)) {
                                score += 5;
                            }
                            if (!isFaster && npcIs2OHKO) {
                                score -= 5;
                            }
                            if (npcStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0) < 2 && npcStages.getOrDefault(Stats.DEFENCE, 0) < 2 && npcStages.getOrDefault(Stats.ATTACK, 0) < 2 && npcStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) < 2 && npcStages.getOrDefault(Stats.SPEED, 0) < 2) break;
                            score -= 3;
                            break;
                        }
                        case "agility": 
                        case "rockpolish": 
                        case "autotomize": {
                            if (!isFaster) {
                                score += 7;
                                break;
                            }
                            score -= 20;
                            break;
                        }
                        case "tailglow": 
                        case "nastyplot": 
                        case "workup": {
                            score += 6;
                            if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                score += 3;
                            } else if (!npcIs3OHKO) {
                                ++score;
                                if (isFaster) {
                                    ++score;
                                }
                            }
                            if (!isFaster && npcIs2OHKO) {
                                score -= 5;
                            }
                            if (npcStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) < 2) break;
                            --score;
                            break;
                        }
                        case "shellsmash": {
                            if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                score += 3;
                            }
                            score = !npcIsOHKOWithSS || !npcIsOHKO && "whiteherb".equals(currentHeldItem) ? (score += 2) : (score -= 2);
                            if (npcStages.getOrDefault(Stats.ATTACK, 0) < 1 && npcStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) < 1 && npcStages.getOrDefault(Stats.ATTACK, 0) != 6 && npcStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) != 6) break;
                            score -= 20;
                            break;
                        }
                        case "bellydrum": {
                            if (isOPFrozen && !hasThawingMove || isOPSleeping || isLoafing || isRecharging) {
                                score += 9;
                                break;
                            }
                            if (!npcIsOHKOWithBD) {
                                score += 8;
                                break;
                            }
                            score += 4;
                            break;
                        }
                        case "focusenergy": 
                        case "laserfocus": {
                            if ("scopelens".equals(currentHeldItem) || currentAbility.equals("superluck") || currentAbility.equals("sniper")) {
                                score += 7;
                                break;
                            }
                            score += 6;
                            break;
                        }
                        case "coaching": {
                            roll = RANDOM.nextDouble();
                            score += 6;
                            if (isDoubles && !NPCPartner.getBattlePokemon().getEffectedPokemon().getAbility().getName().equals("contrary")) {
                                if (RunBunAI.getStageMap(NPCPartner.getBattlePokemon()).getOrDefault(Stats.ATTACK, 0) <= 2) {
                                    score += 1 - RunBunAI.getStageMap(NPCPartner.getBattlePokemon()).getOrDefault(Stats.ATTACK, 0);
                                }
                                if (RunBunAI.getStageMap(NPCPartner.getBattlePokemon()).getOrDefault(Stats.DEFENCE, 0) <= 2) {
                                    score += 1 - RunBunAI.getStageMap(NPCPartner.getBattlePokemon()).getOrDefault(Stats.DEFENCE, 0);
                                }
                                score += roll > 0.2 ? 1 : 0;
                                break;
                            }
                            score -= 20;
                            break;
                        }
                        case "meteorbeam": {
                            if ("powerherb".equals(currentHeldItem)) {
                                score += 9;
                                break;
                            }
                            score -= 20;
                            break;
                        }
                        case "destinybond": {
                            roll = RANDOM.nextDouble();
                            if (isFaster && npcIsOHKO) {
                                score += roll > 0.19 ? 7 : 6;
                            }
                            if (isFaster) break;
                            score += roll > 0.5 ? 5 : 6;
                        }
                    }
                }
                if (recoveryMoves.contains(((InBattleMove)entry6.getKey()).getId())) {
                    switch (((InBattleMove)entry6.getKey()).getId()) {
                        case "junglehealing": 
                        case "lifedew": {
                            score = RunBunAI.shouldRecover(oppMaxDamage, ((InBattleMove)entry6.getKey()).getId(), 25, isFaster, battlePokemon, opponent) ? (score += 7) : (score += 5);
                            if (RunBunAI.getCurrentPercentHP(battlePokemon) == 100.0) {
                                score -= 20;
                                break;
                            }
                            if (!(RunBunAI.getCurrentPercentHP(battlePokemon) >= 85.0)) break;
                            score -= 6;
                            break;
                        }
                        case "recover": 
                        case "slackoff": 
                        case "healorder": 
                        case "softboiled": 
                        case "roost": 
                        case "strengthsap": {
                            score = RunBunAI.shouldRecover(oppMaxDamage, ((InBattleMove)entry6.getKey()).getId(), 50, isFaster, battlePokemon, opponent) ? (score += 7) : (score += 5);
                            if (RunBunAI.getCurrentPercentHP(battlePokemon) == 100.0) {
                                score -= 20;
                                break;
                            }
                            if (!(RunBunAI.getCurrentPercentHP(battlePokemon) >= 85.0)) break;
                            score -= 6;
                            break;
                        }
                        case "morningsun": 
                        case "synthesis": 
                        case "moonlight": {
                            boolean isSunActive;
                            boolean bl = isSunActive = BattleEffects.Field.Weather.harshsunlight(opponent) || BattleEffects.Field.Weather.extremelyharshsunlight(opponent);
                            if (RunBunAI.shouldRecover(oppMaxDamage, ((InBattleMove)entry6.getKey()).getId(), 67, isFaster, battlePokemon, opponent) && isSunActive) {
                                score += 7;
                            } else if (!RunBunAI.shouldRecover(oppMaxDamage, ((InBattleMove)entry6.getKey()).getId(), 67, isFaster, battlePokemon, opponent) || !isSunActive) {
                                score = RunBunAI.shouldRecover(oppMaxDamage, ((InBattleMove)entry6.getKey()).getId(), 50, isFaster, battlePokemon, opponent) ? (score += 7) : (score += 5);
                            }
                            if (RunBunAI.getCurrentPercentHP(battlePokemon) == 100.0) {
                                score -= 20;
                                break;
                            }
                            if (!(RunBunAI.getCurrentPercentHP(battlePokemon) >= 85.0)) break;
                            score -= 6;
                            break;
                        }
                        case "rest": {
                            if (RunBunAI.shouldRecover(oppMaxDamage, ((InBattleMove)entry6.getKey()).getId(), 100, isFaster, battlePokemon, opponent)) {
                                boolean hydrationRaining;
                                List NPCmoveSet = battlePokemon.getMoveSet().getMoves();
                                boolean sleepTalkSnore = false;
                                boolean holdingCureSleep = "chestoberry".equals(currentHeldItem) || "lumberry".equals(currentHeldItem);
                                boolean shedSkinEarlyBird = currentAbility.equals("earlybird") || currentAbility.equals("shedskin");
                                boolean bl = hydrationRaining = currentAbility.equals("hydration") && (BattleEffects.Field.Weather.rain(opponent) || BattleEffects.Field.Weather.heavyrain(opponent));
                                if (RunBunAI.hasMoveName(battlePokemon, "sleeptalk") || RunBunAI.hasMoveName(battlePokemon, "snore")) {
                                    sleepTalkSnore = true;
                                }
                                if (holdingCureSleep || sleepTalkSnore || shedSkinEarlyBird || hydrationRaining) {
                                    score += 8;
                                    break;
                                }
                                score += 7;
                                break;
                            }
                            score += 5;
                        }
                    }
                }
                if (priorityDamageMoves.contains(((InBattleMove)entry6.getKey()).getId()) && !isFaster && npcIsOHKO) {
                    score += 11;
                }
                if (abilityStatBooster.contains(battlePokemon.getOriginalPokemon().getAbility().getName())) {
                    ++score;
                }
                if (highCriticalMoves.contains(currentMove.getId()) && TypeChart.getEffectiveness(TypeChart.getMove(currentMove).getType(), opponent) >= 2.0) {
                    roll = RANDOM.nextDouble();
                    int n = score = roll < 0.5 ? score + 1 : score;
                }
                if (currentMove.getId().equals("acidspray")) {
                    score += 6;
                }
                if (currentMove.getId().equals("taunt")) {
                    boolean hasDefog = RunBunAI.hasMoveName(opponent, "defog");
                    boolean hasTrickRoom = RunBunAI.hasMoveName(opponent, "trickroom");
                    score = hasTrickRoom && !BattleEffects.Field.Room.trickroom(opponent) ? (score += 9) : (hasDefog && isFaster ? (score += 9) : (score += 5));
                }
                if (currentMove.getId().equals("encore")) {
                    score = isFaster ? (score += 7) : (score += (roll = RANDOM.nextDouble()) > 0.5 ? 6 : 5);
                }
            }
            if (currentMove.getId().equals("futuresight")) {
                score += isFaster && npcIsOHKO ? 8 : 6;
            }
            if (currentMove.getId().equals("pursuit") && isFaster) {
                score += 3;
            }
            moveScores.put(currentMove, score);
            ModCommon.LOG.info(currentMove.getId() + "  " + Integer.toString(score));
        }
        if (RunBunAI.isSwitching(moveScores, aliveParty, battlePokemon, opponent)) {
            double flip = RANDOM.nextDouble();
            boolean result = flip > 0.5;
            ModCommon.LOG.info(Boolean.toString(result) + "    coin toss result");
            if (result) {
                nextPokemon.setWillBeSwitchedIn(true);
                moveHistory = new HashMap<Integer, String>();
                ModCommon.LOG.info("SWITCHING INTO NEXT MON");
                switchedLastTurn = true;
                return new SwitchActionResponse(nextPokemon.getUuid());
            }
        }
        int maxScore = moveScores.values().stream().max(Integer::compareTo).orElse(Integer.MIN_VALUE);
        List<InBattleMove> list = moveScores.entrySet().stream().filter(entry -> (Integer)entry.getValue() == maxScore).map(Map.Entry::getKey).toList();
        if (list.size() > 1) {
            int randomInt = RANDOM.nextInt(list.size());
            InBattleMove bestMove = list.get(randomInt);
            ModCommon.LOG.info("CHOOSEN BEST MOVE  " + bestMove.getId());
            List targets = bestMove.mustBeUsed() ? null : (List)bestMove.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
            RunBunAI.changeTurn(battlePokemon);
            return new MoveActionResponse(bestMove.getId(), targets == null ? null : opponentActiveBattlePokemon.get().getPNX(), gimmick);
        }
        List targets = list.get(0).mustBeUsed() ? null : (List)list.get(0).getTarget().getTargetList().invoke((Object)activeBattlePokemon);
        ModCommon.LOG.info("CHOOSEN BEST MOVE  " + list.get(0).getId());
        RunBunAI.changeTurn(battlePokemon);
        return new MoveActionResponse(list.get(0).getId(), targets == null ? null : opponentActiveBattlePokemon.get().getPNX(), gimmick);
    }

    public static int getSpeedStat(ActiveBattlePokemon pkmn) {
        return (int)PokeMathMax.calcSpeedWithStatChange(pkmn.getBattlePokemon(), RunBunAI.getStageMap(pkmn.getBattlePokemon()));
    }

    public static boolean hasMoveName(BattlePokemon pokemon, String moveName) {
        for (Move move : pokemon.getMoveSet().getMoves()) {
            if (!move.getName().equals(moveName)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldRecover(double oppMaxDamage, String recoverMove, int recoverAmount, boolean isAIFaster, BattlePokemon AIpokemon, BattlePokemon oppPokemon) {
        double maxPercentHPDamage = oppMaxDamage / (double)AIpokemon.getMaxHealth() * 100.0;
        double roll = RANDOM.nextDouble();
        double currentAIPercentHP = RunBunAI.getCurrentPercentHP(AIpokemon);
        if (BattleEffects.Pokemon.Status.tox(AIpokemon)) {
            return false;
        }
        if (oppMaxDamage >= (double)recoverAmount) {
            return false;
        }
        if (isAIFaster) {
            if (maxPercentHPDamage >= currentAIPercentHP && maxPercentHPDamage < currentAIPercentHP + (double)recoverAmount) {
                return true;
            }
            if (maxPercentHPDamage < currentAIPercentHP) {
                if (currentAIPercentHP < 66.0 && currentAIPercentHP > 40.0) {
                    return roll > 0.5;
                }
                if (currentAIPercentHP < 40.0) {
                    return true;
                }
            }
        } else {
            if (currentAIPercentHP < 70.0) {
                return roll > 0.25;
            }
            if (currentAIPercentHP < 50.0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isOHKO(List<Move> moves, BattlePokemon attacker, BattlePokemon defender, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        int enemyDamage = 0;
        int currentHP = defender.getHealth();
        boolean result = false;
        for (Move currentMove : moves) {
            enemyDamage = PokeMathMax.damage(attacker, defender, currentMove, attackerStages, defenderStages);
            if (enemyDamage < currentHP) continue;
            result = true;
            if (currentHP == defender.getMaxHealth() && defender.getEffectedPokemon().getAbility().getDisplayName().equals("sturdy")) {
                result = false;
            }
            if (defender.getHeldItemManager().showdownId(defender) != null && currentHP == defender.getMaxHealth() && defender.getHeldItemManager().showdownId(defender).equals("focussash")) {
                result = false;
            }
            if (!result) continue;
            return true;
        }
        return result;
    }

    public static boolean is2HKO(List<Move> moves, BattlePokemon attacker, BattlePokemon defender, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        int enemyDamage = 0;
        int currentHP = defender.getHealth();
        for (Move currentMove : moves) {
            enemyDamage = PokeMathMax.damage(attacker, defender, currentMove, attackerStages, defenderStages);
            if (enemyDamage * 2 < currentHP) continue;
            return true;
        }
        return false;
    }

    public static boolean is3HKO(List<Move> moves, BattlePokemon attacker, BattlePokemon defender, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        int enemyDamage = 0;
        int currentHP = defender.getHealth();
        for (Move currentMove : moves) {
            enemyDamage = PokeMathMax.damage(attacker, defender, currentMove, attackerStages, defenderStages);
            if (enemyDamage * 3 < currentHP) continue;
            return true;
        }
        return false;
    }

    public static boolean wouldBeOHKOAfterShellSmash(List<Move> moves, BattlePokemon attacker, BattlePokemon defender, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        HashMap<Stat, Integer> simulatedDefenderStages = new HashMap<Stat, Integer>(defenderStages);
        simulatedDefenderStages.put((Stat)Stats.DEFENCE, Math.max(-6, Math.min(6, simulatedDefenderStages.getOrDefault(Stats.DEFENCE, 0) - 2)));
        simulatedDefenderStages.put((Stat)Stats.SPECIAL_DEFENCE, Math.max(-6, Math.min(6, simulatedDefenderStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0) - 2)));
        boolean result = false;
        int currentHP = defender.getHealth();
        for (Move move : moves) {
            int enemyDamage = PokeMathMax.damage(attacker, defender, move, attackerStages, simulatedDefenderStages);
            if (enemyDamage < currentHP) continue;
            result = true;
            if (currentHP == defender.getMaxHealth() && defender.getEffectedPokemon().getAbility().getDisplayName().equals("sturdy")) {
                result = false;
            }
            if (defender.getHeldItemManager().showdownId(defender) == null || currentHP != defender.getMaxHealth() || !defender.getHeldItemManager().showdownId(defender).equals("focussash")) continue;
            result = false;
        }
        return result;
    }

    public static boolean isOHKOAfterBellyDrum(List<Move> moves, BattlePokemon attacker, BattlePokemon defender, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        int enemyDamage = 0;
        int currentHP = defender.getHealth();
        boolean result = false;
        boolean hasSitrus = defender.getHeldItemManager().showdownId(defender).equals("sitrusberry");
        boolean hasPinchBerry = defender.getHeldItemManager().showdownId(defender).equals("figyberry") || defender.getHeldItemManager().showdownId(defender).equals("wikiberry") || defender.getHeldItemManager().showdownId(defender).equals("magoberry") || defender.getHeldItemManager().showdownId(defender).equals("aguavberry") || defender.getHeldItemManager().showdownId(defender).equals("iapapaberry");
        int currentHPAfterBellyDrum = defender.getHealth() / 2;
        if (hasSitrus) {
            currentHPAfterBellyDrum += defender.getMaxHealth() / 4;
        }
        if (hasPinchBerry) {
            currentHPAfterBellyDrum = (int)((double)currentHPAfterBellyDrum + (double)defender.getMaxHealth() * 0.33);
        }
        for (Move currentMove : moves) {
            enemyDamage = PokeMathMax.damage(attacker, defender, currentMove, attackerStages, defenderStages);
            if (enemyDamage < currentHP && enemyDamage < currentHPAfterBellyDrum) continue;
            return true;
        }
        return result;
    }

    public static boolean isPartySlowerThanOpponent(List<ActiveBattlePokemon> NPC, List<ActiveBattlePokemon> OPP) {
        int slowestNPC = Math.min(RunBunAI.getSpeedStat(NPC.getFirst()), RunBunAI.getSpeedStat(NPC.getLast()));
        int slowestOPP = Math.min(RunBunAI.getSpeedStat(OPP.getFirst()), RunBunAI.getSpeedStat(OPP.getLast()));
        return slowestOPP > slowestNPC;
    }

    public static boolean isPartyFasterThanOpponent(List<ActiveBattlePokemon> NPC, List<ActiveBattlePokemon> OPP) {
        int fastestNPC = Math.max(RunBunAI.getSpeedStat(NPC.getFirst()), RunBunAI.getSpeedStat(NPC.getLast()));
        int fastestOPP = Math.max(RunBunAI.getSpeedStat(OPP.getFirst()), RunBunAI.getSpeedStat(OPP.getLast()));
        return fastestOPP < fastestNPC;
    }

    public static boolean isSwitching(Map<InBattleMove, Integer> moveScore, List<BattlePokemon> party, BattlePokemon self, BattlePokemon opponent) {
        ArrayList<Integer> scores = new ArrayList<Integer>();
        boolean isSecondCondition = false;
        boolean isThirdCondition = false;
        for (int val : moveScore.values()) {
            scores.add(val);
        }
        boolean hasLowScore = scores.stream().allMatch(s -> s <= -5);
        if (Math.ceil(RunBunAI.getCurrentPercentHP(self)) <= 50.0) {
            return false;
        }
        for (BattlePokemon pokemon : party) {
            if (pokemon.getEffectedPokemon().getStat((Stat)Stats.SPEED) >= opponent.getEffectedPokemon().getStat((Stat)Stats.SPEED) && !RunBunAI.isOHKO(opponent.getMoveSet().getMoves(), opponent, pokemon, opponentStages, npcStages)) {
                isSecondCondition = true;
            }
            if (pokemon.getEffectedPokemon().getStat((Stat)Stats.SPEED) >= opponent.getEffectedPokemon().getStat((Stat)Stats.SPEED) || RunBunAI.is2HKO(opponent.getMoveSet().getMoves(), opponent, pokemon, opponentStages, npcStages)) continue;
            isThirdCondition = true;
        }
        return isSecondCondition && isThirdCondition && hasLowScore;
    }

    public static double highestPercentDamageMove(BattlePokemon attacker, BattlePokemon defender) {
        List attackerMoves = attacker.getMoveSet().getMoves();
        double highestPercent = 0.0;
        double currentCalc = 0.0;
        for (Move move : attackerMoves) {
            currentCalc = Math.ceil((double)PokeMathMax.damage(attacker, defender, move, npcStages, opponentStages) / (double)defender.getMaxHealth());
            highestPercent = currentCalc > highestPercent ? currentCalc : highestPercent;
        }
        return highestPercent;
    }

    public static Map<Stat, Integer> getStageMap(BattlePokemon bp) {
        Collection unboosts;
        HashMap<Stat, Integer> stageMap = new HashMap<Stat, Integer>();
        ContextManager ctx = bp.getContextManager();
        StatProvider statProvider = Cobblemon.INSTANCE.getStatProvider();
        Collection boosts = ctx.get(BattleContext.Type.BOOST);
        if (boosts != null) {
            for (BattleContext c : boosts) {
                String statId = statIdMap.getOrDefault(c.getId(), c.getId());
                class_2960 rl = class_2960.method_60655((String)"cobblemon", (String)statId);
                try {
                    Stat stat = statProvider.fromIdentifierOrThrow(rl);
                    stageMap.put(stat, stageMap.getOrDefault(stat, 0) + 1);
                }
                catch (IllegalArgumentException e) {
                    ModCommon.LOG.warn("Unknown stat for id: " + c.getId());
                }
            }
        }
        if ((unboosts = ctx.get(BattleContext.Type.UNBOOST)) != null) {
            for (BattleContext c : unboosts) {
                String statId = statIdMap.getOrDefault(c.getId(), c.getId());
                class_2960 rl = class_2960.method_60655((String)"cobblemon", (String)statId);
                try {
                    Stat stat = statProvider.fromIdentifierOrThrow(rl);
                    stageMap.put(stat, stageMap.getOrDefault(stat, 0) - 1);
                }
                catch (IllegalArgumentException e) {
                    ModCommon.LOG.warn("Unknown stat for id: " + c.getId());
                }
            }
        }
        return stageMap;
    }

    private static double getInBattleSpeed(BattlePokemon pokemon) {
        Map<Stat, Integer> statMap = RunBunAI.getStageMap(pokemon);
        double multiplier = 1.0;
        if (statMap.getOrDefault(Stats.SPEED, 0) < 0) {
            double statChange = statMap.getOrDefault(Stats.SPEED, 0).intValue();
            multiplier = 2.0 / (2.0 - statChange);
        } else if (statMap.getOrDefault(Stats.SPEED, 0) > 0) {
            double statChange = statMap.getOrDefault(Stats.SPEED, 0).intValue();
            multiplier = (2.0 + statChange) / 2.0;
        } else {
            return BattleStates.getTransformationOrEffected(pokemon).getSpeed();
        }
        return (double)BattleStates.getTransformationOrEffected(pokemon).getSpeed() * multiplier;
    }

    private static double getCurrentPercentHP(BattlePokemon pokemon) {
        return (double)pokemon.getHealth() / (double)pokemon.getMaxHealth() * 100.0;
    }

    private static boolean hasMove(BattlePokemon pokemon, String moveID) {
        boolean hasMove = false;
        List pokemonMoveSet = pokemon.getMoveSet().getMoves();
        for (Move pkmMove : pokemonMoveSet) {
            if (!pkmMove.getName().equals(moveID)) continue;
            hasMove = true;
        }
        return hasMove;
    }

    private static boolean hasAnyMoveType(BattlePokemon pokemon, List<String> list) {
        boolean hasMove = false;
        List pokemonMoveSet = pokemon.getMoveSet().getMoves();
        for (Move pkmMove : pokemonMoveSet) {
            if (!pokemonMoveSet.contains(pkmMove.getName())) continue;
            hasMove = true;
        }
        return hasMove;
    }

    private static double getEffectiveSpeed(BattlePokemon pokemon, Map<Stat, Integer> stages) {
        double multiplier = 1.0;
        int stage = stages.getOrDefault(Stats.SPEED, 0);
        if (stage < 0) {
            multiplier = 2.0 / (double)(2 - stage);
        } else if (stage > 0) {
            multiplier = (2.0 + (double)stage) / 2.0;
        }
        return (double)BattleStates.getTransformationOrEffected(pokemon).getSpeed() * multiplier;
    }

    private static boolean fasterAndOHKOAfterBoost(BattlePokemon attacker, BattlePokemon defender, int boostedSpeed, int boostedAtk, int boostedSpAtk) {
        HashMap<Stat, Integer> attackerStages = new HashMap<Stat, Integer>(RunBunAI.getStageMap(attacker));
        Map<Stat, Integer> defenderStages = RunBunAI.getStageMap(defender);
        attackerStages.put((Stat)Stats.SPEED, Math.max(-6, Math.min(6, attackerStages.getOrDefault(Stats.SPEED, 0) + boostedSpeed)));
        attackerStages.put((Stat)Stats.ATTACK, Math.max(-6, Math.min(6, attackerStages.getOrDefault(Stats.ATTACK, 0) + boostedAtk)));
        attackerStages.put((Stat)Stats.SPECIAL_ATTACK, Math.max(-6, Math.min(6, attackerStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) + boostedSpAtk)));
        return RunBunAI.getEffectiveSpeed(attacker, attackerStages) >= RunBunAI.getEffectiveSpeed(defender, defenderStages) && RunBunAI.isOHKO(attacker.getMoveSet().getMoves(), attacker, defender, attackerStages, defenderStages);
    }

    private static void changeTurn(BattlePokemon pokemon) {
        if (!switchedLastTurn) {
            if (currentPokemonUUID == pokemon.getUuid()) {
                ++turnsForActivePokemon;
            }
            ++battleTurn;
            if (!moveHistory.isEmpty()) {
                for (Map.Entry<Integer, String> moves : moveHistory.entrySet()) {
                    ModCommon.LOG.info("TURN " + String.valueOf(moves.getKey()) + "  NPC USED " + moves.getValue());
                }
            }
        } else {
            switchedLastTurn = false;
        }
    }

    public static boolean isSandstormFatal(BattlePokemon battlePokemon, ElementalType primaryType, ElementalType secondaryType, double percentHP) {
        boolean isImmune;
        if (!BattleEffects.Field.Weather.sandstorm(battlePokemon)) {
            return false;
        }
        Set<String> immuneTypes = Set.of("ROCK", "GROUND", "STEEL");
        boolean bl = isImmune = immuneTypes.contains(primaryType.getDisplayName()) || immuneTypes.contains(secondaryType.getDisplayName());
        if (isImmune) {
            return false;
        }
        return percentHP <= 8.0;
    }

    public static int getHazardCount(Map<Integer, String> moveHistory, String move) {
        int count = 0;
        for (Map.Entry<Integer, String> entry : moveHistory.entrySet()) {
            if (!entry.getValue().equals(move)) continue;
            ++count;
        }
        return count;
    }

    public static boolean getIsMoveUp(String moveID, Map<Integer, String> moveHistory, int turnDuration, int currentTurn) {
        int lastTurnUsed = -1;
        for (Map.Entry<Integer, String> history : moveHistory.entrySet()) {
            if (!history.getValue().equals(moveID)) continue;
            lastTurnUsed = history.getKey();
        }
        if (lastTurnUsed == -1) {
            return false;
        }
        return currentTurn - lastTurnUsed < turnDuration;
    }
}

