/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class HeldItemsModel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String[] itemIds;

    public HeldItemsModel() {
        this.itemIds = new String[0];
    }

    public HeldItemsModel(String itemId) {
        this.itemIds = itemId.isBlank() ? new String[0] : new String[]{itemId};
    }

    public HeldItemsModel(Collection<String> itemIds) {
        this.itemIds = (String[])itemIds.stream().filter(id -> !id.isBlank()).toArray(String[]::new);
    }

    public String[] getItemIds() {
        return this.itemIds;
    }

    public int hashCode() {
        return Arrays.hashCode(this.itemIds);
    }

    public boolean equals(Object obj) {
        HeldItemsModel other;
        return obj instanceof HeldItemsModel && (this == (other = (HeldItemsModel)obj) || Arrays.equals(this.itemIds, other.itemIds));
    }

    public static class Deserializer
    implements JsonDeserializer<HeldItemsModel> {
        public HeldItemsModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String id = json.getAsString();
                return new HeldItemsModel(id);
            }
            catch (IllegalStateException | UnsupportedOperationException e) {
                ArrayList<String> list = new ArrayList<String>();
                json.getAsJsonArray().forEach(je -> list.add(je.getAsString()));
                return new HeldItemsModel(list);
            }
        }
    }
}

