/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.trainer;

import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.battle.BagItemLike;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class TrainerBag {
    private Map<BagItem, Integer> items = new HashMap<BagItem, Integer>();

    public void add(String itemId, int quantity) {
        if (quantity > 0) {
            class_2960 itemLocation = class_2960.method_60654((String)itemId);
            if (!class_7923.field_41178.method_10250(itemLocation)) {
                throw new IllegalArgumentException("invalid item '" + itemId + "'");
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemLocation);
            if (item instanceof BagItemLike) {
                BagItemLike bagItemLike = (BagItemLike)item;
                this.items.put(bagItemLike.getBagItem(item.method_7854()), quantity);
            } else if (item instanceof PokemonSelectingItem) {
                PokemonSelectingItem selectingItem = (PokemonSelectingItem)item;
                this.items.put(selectingItem.getBagItem(), quantity);
            } else {
                throw new IllegalArgumentException("'" + itemId + "' is neither a BagItemLike or PokemonSelectingItem");
            }
        }
    }

    public BagItem use(BagItem item) {
        this.items.computeIfPresent(item, (k, v) -> v > 1 ? Integer.valueOf(v - 1) : null);
        return item;
    }

    public Set<BagItem> getItems() {
        return this.items.keySet();
    }

    public int getQuanity(BagItem item) {
        return this.items.getOrDefault(item, 0);
    }

    public TrainerBag clone() {
        TrainerBag bag = new TrainerBag();
        bag.items.putAll(this.items);
        return bag;
    }
}

