/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleCaptureAction;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.net.messages.client.battle.BattleSwapPokemonPacket;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonBattle.class})
public abstract class PokemonBattleMixin {
    @Shadow(remap=false)
    abstract BattleFormat getFormat();

    @Shadow(remap=false)
    abstract Iterable<BattleActor> getActors();

    @Shadow(remap=false)
    abstract List<BattleCaptureAction> getCaptureActions();

    @Shadow(remap=false)
    abstract Pair<BattleActor, ActiveBattlePokemon> getActorAndActiveSlotFromPNX(String var1);

    @Shadow(remap=false)
    abstract boolean checkForfeit();

    @Inject(method={"checkForInputDispatch"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectCheckForInputDispatch(CallbackInfo ci) {
        if (BattleState.findFirst((PokemonBattle)this) != null) {
            boolean readyToInput;
            if (this.checkForfeit()) {
                ci.cancel();
                return;
            }
            List<BattleActor> actors = Streams.stream(this.getActors()).filter(a -> a.getPokemonList().stream().anyMatch(p -> p.getHealth() > 0)).toList();
            boolean bl = readyToInput = actors.stream().anyMatch(a -> !a.getMustChoose() && !a.getResponses().isEmpty()) && actors.stream().noneMatch(a -> a.getMustChoose());
            if (readyToInput && this.getCaptureActions().isEmpty()) {
                actors.stream().filter(a -> !a.getResponses().isEmpty()).forEach(a -> {
                    a.writeShowdownResponse();
                    a.getResponses().clear();
                    a.setRequest(null);
                });
            }
            ci.cancel();
        }
    }

    @Inject(method={"sendUpdate"}, at={@At(value="HEAD")}, remap=false)
    private void injectSendUpdate(NetworkPacket<?> packet, CallbackInfo ci) {
        if (BattleState.findFirst((PokemonBattle)this) != null && packet instanceof BattleSwapPokemonPacket) {
            BattleSwapPokemonPacket swPacket = (BattleSwapPokemonPacket)packet;
            if (this.getFormat().component2().getPokemonPerSide() < 3) {
                String pnxB = swPacket.getPnx();
                Pair<BattleActor, ActiveBattlePokemon> actorAndSlotB = this.getActorAndActiveSlotFromPNX(pnxB);
                BattleActor actor = (BattleActor)actorAndSlotB.component1();
                ActiveBattlePokemon pkmnB = (ActiveBattlePokemon)actorAndSlotB.component2();
                ActiveBattlePokemon pkmnA = (ActiveBattlePokemon)pkmnB.getAdjacentAllies().stream().findFirst().get();
                List actorPkmn = actor.getPokemonList();
                Collections.swap(actorPkmn, actorPkmn.indexOf(pkmnA.getBattlePokemon()), actorPkmn.indexOf(pkmnB.getBattlePokemon()));
            }
        }
    }
}

