/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental.lai;

import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.ActionKeys;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.BattleEvaluator;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.BattleState;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.RatedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class BattleMemory<T>
extends SavedData {
    private static final Random RNG = new Random();
    private static final double RATING_MARGIN = 0.075;
    private static final String FILE = "rctapi.lai.knowledge";
    private BattleEvaluator evaluator = new BattleEvaluator();
    private Map<String, RatedAction<T>> exactActions = new HashMap<String, RatedAction<T>>();
    private Map<String, RatedAction<T>> fuzzyActions = new HashMap<String, RatedAction<T>>();
    private BattleState previousState;
    private BattleState currentState;
    private RatedAction<T> previousAction;

    public static <T> BattleMemory<T> load(MinecraftServer server) {
        return BattleMemory.load(server, FILE);
    }

    public static <T> BattleMemory<T> load(MinecraftServer server, String path) {
        return (BattleMemory)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(BattleMemory::new, BattleMemory::of, DataFixTypes.LEVEL), path);
    }

    public static <T> BattleMemory<T> of(CompoundTag tag, HolderLookup.Provider provider) {
        BattleMemory<T> bm = new BattleMemory<T>();
        CompoundTag exacts = tag.getCompound("exacts");
        CompoundTag fuzzies = tag.getCompound("fuzzies");
        exacts.getAllKeys().forEach(key -> bm.exactActions.put((String)key, new RatedAction(exacts.getDouble(key))));
        fuzzies.getAllKeys().forEach(key -> bm.fuzzyActions.put((String)key, new RatedAction(fuzzies.getDouble(key))));
        return bm;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag exacts = new CompoundTag();
        CompoundTag fuzzies = new CompoundTag();
        this.exactActions.entrySet().forEach(kv -> exacts.putDouble((String)kv.getKey(), ((RatedAction)kv.getValue()).getRating()));
        this.fuzzyActions.entrySet().forEach(kv -> fuzzies.putDouble((String)kv.getKey(), ((RatedAction)kv.getValue()).getRating()));
        tag.put("exacts", (Tag)exacts);
        tag.put("fuzzies", (Tag)fuzzies);
        return tag;
    }

    public void next(ActiveBattlePokemon pkmn) {
        this.currentState = BattleState.of(pkmn);
        if (this.previousAction != null) {
            this.evaluator.update(this.previousAction, this.previousState, this.currentState);
            this.setDirty();
        }
        this.previousState = this.currentState;
        this.previousAction = null;
    }

    public Optional<T> getChoice() {
        return this.previousAction != null ? Optional.of(this.previousAction.get()) : Optional.empty();
    }

    public RatedAction<T> getOrAdd(ActiveBattlePokemon from, BattlePokemon to, Supplier<T> supplier) {
        return this.storeIfBest(this.exactActions.compute(ActionKeys.switchKey(from, to), (k, v) -> {
            if (v == null) {
                return this.getOrAddFuzzy(ActionKeys.switchFuzzyKey(from, to), supplier);
            }
            return v.withSupplier(supplier);
        }));
    }

    public RatedAction<T> getOrAdd(BagItem item, BattlePokemon target, Supplier<T> supplier) {
        return this.storeIfBest(this.exactActions.compute(ActionKeys.itemKey(item, target), (k, v) -> {
            if (v == null) {
                return this.getOrAddFuzzy(ActionKeys.itemFuzzyKey(item, target), supplier);
            }
            return v.withSupplier(supplier);
        }));
    }

    public RatedAction<T> getOrAdd(ActiveBattlePokemon pkmn, InBattleMove move, Targetable target, Supplier<T> supplier) {
        return this.storeIfBest(this.exactActions.compute(ActionKeys.moveKey(pkmn, move, target), (k, v) -> {
            if (v == null) {
                return this.getOrAddFuzzy(ActionKeys.moveFuzzyKey(pkmn, move, target), supplier);
            }
            return v.withSupplier(supplier);
        }));
    }

    protected RatedAction<T> getOrAddFuzzy(String key, Supplier<T> supplier) {
        return this.fuzzyActions.compute(key, (k, v) -> {
            if (v == null) {
                return new RatedAction(supplier);
            }
            return v.withSupplier(supplier);
        });
    }

    protected RatedAction<T> storeIfBest(RatedAction<T> nextAction) {
        double r = nextAction.getRating();
        double m = 0.075 * RNG.nextDouble();
        if (this.previousAction == null || r + m > this.previousAction.getRating()) {
            this.previousAction = nextAction;
        }
        return nextAction;
    }
}

