/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import java.util.Collection;
import java.util.Map;
import java.util.Random;

public class PokeMathMax {
    private static final Random RANDOM = new Random();
    private static final String WEATHER_SUN = "sunny";
    private static final String WEATHER_RAIN = "raining";

    private static double damage(int attackerLevel, double attackerEffectiveAttack, double defenderEffectiveDefence, double movePower, boolean physical, boolean multiTarget, boolean rain, boolean sun, boolean parentalBond, boolean glaiveRush, boolean burn, boolean zmove, boolean reflect, boolean lightscreen, boolean attackerHasStatus, ElementalType moveType, BattlePokemon attacker, BattlePokemon defender, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        Pokemon attackerEp = BattleStates.getTransformationOrEffected(attacker);
        ElementalType attackerPrimaryType = attackerEp.getPrimaryType();
        ElementalType attackerSecondaryType = attackerEp.getSecondaryType();
        TeraType attackerTeraType = attacker.getEffectedPokemon().getTeraType();
        Ability attackerAbility = attackerEp.getAbility();
        String attackerHeldItem = attacker.getHeldItemManager().showdownId(attacker) != null ? attacker.getHeldItemManager().showdownId(attacker) : "";
        String defenderHeldItem = defender.getHeldItemManager().showdownId(defender) != null ? defender.getHeldItemManager().showdownId(defender) : "";
        double baseDamage = ((double)(2 * attackerLevel) / 5.0 + 2.0) * movePower * attackerEffectiveAttack / defenderEffectiveDefence / 50.0 + 2.0;
        if (multiTarget) {
            baseDamage *= 0.75;
        }
        if (parentalBond) {
            baseDamage *= 0.25;
        }
        if (glaiveRush) {
            baseDamage *= 2.0;
        }
        if (burn && physical && !attackerAbility.getName().equals("guts")) {
            baseDamage *= 0.5;
        }
        if (attackerHasStatus && attackerAbility.getName().equals("guts")) {
            baseDamage *= 1.5;
        }
        if (sun && moveType.equals(ElementalTypes.INSTANCE.getFIRE()) || rain && moveType.equals(ElementalTypes.INSTANCE.getWATER())) {
            baseDamage *= 1.5;
        }
        if (sun && moveType.equals(ElementalTypes.INSTANCE.getWATER()) || rain && moveType.equals(ElementalTypes.INSTANCE.getFIRE())) {
            baseDamage *= 0.5;
        }
        double stab = 1.0;
        boolean terastal = BattleStates.get(attacker.actor.battle).getPokemonState(attacker).has(BattleEffects.Custom.TERA);
        boolean adapt = attackerAbility.getName().equals("adaptability");
        if (terastal && attackerTeraType != null) {
            if (moveType.equals(attackerPrimaryType) || moveType.equals(attackerSecondaryType) || moveType.getName().equals(attackerTeraType.showdownId())) {
                boolean teraSame;
                boolean bl = teraSame = attackerTeraType.showdownId().equals(attackerPrimaryType.getName()) || attackerSecondaryType != null && attackerTeraType.showdownId().equals(attackerSecondaryType.getName());
                stab = teraSame && !adapt ? 2.0 : (teraSame && adapt ? 2.25 : 1.5);
            }
        } else if (moveType.equals(attackerPrimaryType) || moveType.equals(attackerSecondaryType)) {
            stab = adapt ? 2.0 : 1.5;
        }
        baseDamage *= stab;
        switch (attackerHeldItem) {
            case "expertbelt": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0)) break;
                baseDamage *= 1.2;
                break;
            }
            case "choiceband": {
                if (!physical) break;
                baseDamage *= 1.5;
                break;
            }
            case "choicespecs": {
                if (physical) break;
                baseDamage *= 1.5;
                break;
            }
            case "muscleband": {
                if (!physical) break;
                baseDamage *= 1.1;
                break;
            }
            case "wiseglasses": {
                if (physical) break;
                baseDamage *= 1.1;
                break;
            }
            case "blackbelt": 
            case "fistplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFIGHTING())) break;
                baseDamage *= 1.2;
                break;
            }
            case "blackglasses": 
            case "dreadplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getDARK())) break;
                baseDamage *= 1.2;
                break;
            }
            case "charcoalstick": 
            case "flameplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFIRE())) break;
                baseDamage *= 1.2;
                break;
            }
            case "dragonfang": 
            case "dracoplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage *= 1.2;
                break;
            }
            case "hardstone": 
            case "rockincense": 
            case "stoneplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getROCK())) break;
                baseDamage *= 1.2;
                break;
            }
            case "magnet": 
            case "zapplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getELECTRIC())) break;
                baseDamage *= 1.2;
                break;
            }
            case "metalcoat": 
            case "ironplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getSTEEL())) break;
                baseDamage *= 1.2;
                break;
            }
            case "miracleseed": 
            case "roseincense": 
            case "meadowplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getGRASS())) break;
                baseDamage *= 1.2;
                break;
            }
            case "mysticwater": 
            case "seaincense": 
            case "waveincense": 
            case "splashplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getWATER())) break;
                baseDamage *= 1.2;
                break;
            }
            case "nevermeltice": 
            case "icicleplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getICE())) break;
                baseDamage *= 1.2;
                break;
            }
            case "poisonbarb": 
            case "toxicplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getPOISON())) break;
                baseDamage *= 1.2;
                break;
            }
            case "sharpbeak": 
            case "skyplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFLYING())) break;
                baseDamage *= 1.2;
                break;
            }
            case "silkscarf": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getNORMAL())) break;
                baseDamage *= 1.2;
                break;
            }
            case "silverpowder": 
            case "insectplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getBUG())) break;
                baseDamage *= 1.2;
                break;
            }
            case "softsand": 
            case "earthplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getGROUND())) break;
                baseDamage *= 1.2;
                break;
            }
            case "spelltag": 
            case "spookyplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getGHOST())) break;
                baseDamage *= 1.2;
                break;
            }
            case "twistedspoon": 
            case "oddincense": 
            case "mindplate": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getPSYCHIC())) break;
                baseDamage *= 1.2;
                break;
            }
            case "lifeorb": {
                baseDamage *= 1.3;
                break;
            }
            case "souldew": {
                if (attacker.getOriginalPokemon().getDisplayName().getString() != "latias" && attacker.getOriginalPokemon().getDisplayName().getString() != "latios" || !moveType.equals(ElementalTypes.INSTANCE.getPSYCHIC()) && !moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage *= 1.2;
                break;
            }
            case "adamantorb": {
                if (attacker.getOriginalPokemon().getDisplayName().getString() != "dialga" || !moveType.equals(ElementalTypes.INSTANCE.getSTEEL()) && !moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage *= 1.2;
                break;
            }
            case "lustrousorb": {
                if (attacker.getOriginalPokemon().getDisplayName().getString() != "palkia" || !moveType.equals(ElementalTypes.INSTANCE.getWATER()) && !moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage *= 1.2;
                break;
            }
            case "griseousorb": {
                if (attacker.getOriginalPokemon().getDisplayName().getString() != "giratina" || !moveType.equals(ElementalTypes.INSTANCE.getGHOST()) && !moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage *= 1.2;
                break;
            }
            case "fightinggem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFIGHTING())) break;
                baseDamage *= 1.3;
                break;
            }
            case "normalgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getNORMAL())) break;
                baseDamage *= 1.3;
                break;
            }
            case "firegem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFIRE())) break;
                baseDamage *= 1.3;
                break;
            }
            case "watergem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getWATER())) break;
                baseDamage *= 1.3;
                break;
            }
            case "grassgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getGRASS())) break;
                baseDamage *= 1.3;
                break;
            }
            case "icegem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getICE())) break;
                baseDamage *= 1.3;
                break;
            }
            case "poisongem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getPOISON())) break;
                baseDamage *= 1.3;
                break;
            }
            case "groundgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getGROUND())) break;
                baseDamage *= 1.3;
                break;
            }
            case "flyinggem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFLYING())) break;
                baseDamage *= 1.3;
                break;
            }
            case "psychicgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getPSYCHIC())) break;
                baseDamage *= 1.3;
                break;
            }
            case "buggem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getBUG())) break;
                baseDamage *= 1.3;
                break;
            }
            case "rockgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getROCK())) break;
                baseDamage *= 1.3;
                break;
            }
            case "ghostgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getGHOST())) break;
                baseDamage *= 1.3;
                break;
            }
            case "dragongem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage *= 1.3;
                break;
            }
            case "darkgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getDARK())) break;
                baseDamage *= 1.3;
                break;
            }
            case "steelgem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getSTEEL())) break;
                baseDamage *= 1.3;
                break;
            }
            case "fairygem": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getFAIRY())) break;
                baseDamage *= 1.3;
            }
        }
        baseDamage *= TypeChart.getEffectiveness(moveType, defender);
        switch (defenderHeldItem) {
            case "chilanberry": {
                if (!moveType.equals(ElementalTypes.INSTANCE.getNORMAL())) break;
                baseDamage /= 2.0;
                break;
            }
            case "occaberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getFIRE())) break;
                baseDamage /= 2.0;
                break;
            }
            case "passhoberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getWATER())) break;
                baseDamage /= 2.0;
                break;
            }
            case "wacanberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getELECTRIC())) break;
                baseDamage /= 2.0;
                break;
            }
            case "rindoberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getGRASS())) break;
                baseDamage /= 2.0;
                break;
            }
            case "yacheberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getICE())) break;
                baseDamage /= 2.0;
                break;
            }
            case "chopleberry": {
                if (!(TypeChart.getEffectiveness(attacker, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getFIGHTING())) break;
                baseDamage /= 2.0;
                break;
            }
            case "kebiaberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getPOISON())) break;
                baseDamage /= 2.0;
                break;
            }
            case "shucaberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getGROUND())) break;
                baseDamage /= 2.0;
                break;
            }
            case "cobaberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getFLYING())) break;
                baseDamage /= 2.0;
                break;
            }
            case "payapaberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getPSYCHIC())) break;
                baseDamage /= 2.0;
                break;
            }
            case "tangaberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getBUG())) break;
                baseDamage /= 2.0;
                break;
            }
            case "chartiberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getROCK())) break;
                baseDamage /= 2.0;
                break;
            }
            case "kasibberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getGHOST())) break;
                baseDamage /= 2.0;
                break;
            }
            case "habanberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getDRAGON())) break;
                baseDamage /= 2.0;
                break;
            }
            case "colburberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getDARK())) break;
                baseDamage /= 2.0;
                break;
            }
            case "babiriberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getSTEEL())) break;
                baseDamage /= 2.0;
                break;
            }
            case "roseliberry": {
                if (!(TypeChart.getEffectiveness(moveType, defender) >= 2.0) || !moveType.equals(ElementalTypes.INSTANCE.getFAIRY())) break;
                baseDamage /= 2.0;
            }
        }
        return baseDamage;
    }

    public static int damage(BattlePokemon attacker, BattlePokemon defender, InBattleMove inBattleMove, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        return PokeMathMax.damage(attacker, defender, TypeChart.getMove(inBattleMove), attackerStages, defenderStages);
    }

    public static int damage(BattlePokemon attacker, BattlePokemon defender, Move move, Map<Stat, Integer> attackerStages, Map<Stat, Integer> defenderStages) {
        String damageCategory = move.getDamageCategory().getName();
        if (damageCategory.equals(DamageCategories.INSTANCE.getSTATUS().getName())) {
            return 0;
        }
        boolean isPhysicalMove = damageCategory.equals(DamageCategories.INSTANCE.getPHYSICAL().getName());
        boolean isAttackerBurned = false;
        PersistentStatusContainer statusContainer = attacker.getEffectedPokemon().getStatus();
        Collection weather = attacker.getContextManager().get(BattleContext.Type.WEATHER);
        Collection status = attacker.getContextManager().get(BattleContext.Type.STATUS);
        double acc = move.getAccuracy() / 100.0;
        if (statusContainer != null && !statusContainer.isExpired()) {
            isAttackerBurned = statusContainer.getStatus().equals(Statuses.INSTANCE.getBURN());
        }
        return (int)Math.ceil(PokeMathMax.damage(attacker.getEffectedPokemon().getLevel(), PokeMathMax.calcAttackWithStatChanges(isPhysicalMove, attacker, attackerStages), PokeMathMax.calcDefenseWithStatChanges(isPhysicalMove, defender, defenderStages), move.getPower(), isPhysicalMove, false, weather != null && weather.stream().anyMatch(c -> c.getId().equals(WEATHER_RAIN)), weather != null && weather.stream().anyMatch(c -> c.getId().equals(WEATHER_SUN)), false, false, isAttackerBurned, false, false, false, status != null && !status.isEmpty(), move.getName().equals("hiddenpower") ? TypeChart.getHiddenPowerType(attacker) : move.getType(), attacker, defender, attackerStages, defenderStages));
    }

    public static double calcAttackWithStatChanges(boolean isPhysical, BattlePokemon attacker, Map<Stat, Integer> statStages) {
        double multiplier = 1.0;
        if (isPhysical) {
            if (statStages.getOrDefault(Stats.ATTACK, 0) < 0) {
                double statChange = statStages.getOrDefault(Stats.ATTACK, 0).intValue();
                multiplier = 2.0 / (2.0 - statChange);
                return (double)BattleStates.getTransformationOrEffected(attacker).getAttack() * multiplier;
            }
            if (statStages.getOrDefault(Stats.ATTACK, 0) > 0) {
                double statChange = statStages.getOrDefault(Stats.ATTACK, 0).intValue();
                multiplier = (2.0 + statChange) / 2.0;
                return (double)BattleStates.getTransformationOrEffected(attacker).getAttack() * multiplier;
            }
            return BattleStates.getTransformationOrEffected(attacker).getAttack();
        }
        if (!isPhysical) {
            if (statStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) < 0) {
                double statChange = statStages.getOrDefault(Stats.SPECIAL_ATTACK, 0).intValue();
                multiplier = 2.0 / (2.0 - statChange);
                return (double)BattleStates.getTransformationOrEffected(attacker).getSpecialAttack() * multiplier;
            }
            if (statStages.getOrDefault(Stats.SPECIAL_ATTACK, 0) > 0) {
                double statChange = statStages.getOrDefault(Stats.SPECIAL_ATTACK, 0).intValue();
                multiplier = (2.0 + statChange) / 2.0;
                return (double)BattleStates.getTransformationOrEffected(attacker).getSpecialAttack() * multiplier;
            }
            return BattleStates.getTransformationOrEffected(attacker).getSpecialAttack();
        }
        return -1.0;
    }

    public static double calcDefenseWithStatChanges(boolean isPhysical, BattlePokemon defender, Map<Stat, Integer> statStages) {
        FormData data = defender.getEffectedPokemon().getForm();
        boolean hasEvolution = !data.getEvolutions().isEmpty();
        double multiplier = 1.0;
        double itemMultiplier = 1.5;
        boolean hasItem = false;
        double specialDefenseStat = BattleStates.getTransformationOrEffected(defender).getSpecialDefence();
        if (isPhysical) {
            if (defender.getHeldItemManager().showdownId(defender) != null && defender.getHeldItemManager().showdownId(defender).equals("eviolite") && hasEvolution) {
                hasItem = true;
            }
            if (statStages.getOrDefault(Stats.DEFENCE, 0) < 0) {
                double statChange = statStages.getOrDefault(Stats.DEFENCE, 0).intValue();
                multiplier = 2.0 / (2.0 - statChange);
            } else if (statStages.getOrDefault(Stats.DEFENCE, 0) > 0) {
                double statChange = statStages.getOrDefault(Stats.DEFENCE, 0).intValue();
                multiplier = (2.0 + statChange) / 2.0;
            }
            return hasItem ? specialDefenseStat * multiplier * itemMultiplier : specialDefenseStat * multiplier;
        }
        if (!isPhysical) {
            if (defender.getHeldItemManager().showdownId(defender) != null && (defender.getHeldItemManager().showdownId(defender).equals("assaultvest") || defender.getHeldItemManager().showdownId(defender).equals("eviolite") && hasEvolution)) {
                hasItem = true;
            }
            if (statStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0) < 0) {
                double statChange = statStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0).intValue();
                multiplier = 2.0 / (2.0 - statChange);
            } else if (statStages.getOrDefault(Stats.ATTACK, 0) > 0) {
                double statChange = statStages.getOrDefault(Stats.SPECIAL_DEFENCE, 0).intValue();
                multiplier = (2.0 + statChange) / 2.0;
            }
            return hasItem ? specialDefenseStat * multiplier * itemMultiplier : specialDefenseStat * multiplier;
        }
        return -1.0;
    }

    public static double calcSpeedWithStatChange(BattlePokemon pokemon, Map<Stat, Integer> statStages) {
        double multiplier = 1.0;
        if (statStages.getOrDefault(Stats.SPEED, 0) < 0) {
            double statChange = statStages.getOrDefault(Stats.SPEED, 0).intValue();
            multiplier = 2.0 / (2.0 - statChange);
            return (double)BattleStates.getTransformationOrEffected(pokemon).getSpeed() * multiplier;
        }
        if (statStages.getOrDefault(Stats.SPEED, 0) > 0) {
            double statChange = statStages.getOrDefault(Stats.SPEED, 0).intValue();
            multiplier = (2.0 + statChange) / 2.0;
            return (double)BattleStates.getTransformationOrEffected(pokemon).getSpeed() * multiplier;
        }
        return BattleStates.getTransformationOrEffected(pokemon).getSpeed();
    }
}

