/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.models.converter;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.errors.RCTError;
import com.gitlab.srcmc.rctapi.api.errors.RCTErrors;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.models.PokemonModel;
import com.gitlab.srcmc.rctapi.api.models.converter.Converter;
import com.gitlab.srcmc.rctapi.api.util.Locations;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class PokemonModelConverter
implements Converter<PokemonModel, Pokemon> {
    @Override
    public Pokemon toTarget(PokemonModel model, RCTErrors<RCTException> errors) {
        Pokemon pokemon = new Pokemon();
        if (!model.getSpecies().isBlank()) {
            String species = Locations.withNamespace("cobblemon", model.getSpecies());
            errors.doif(PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocation.parse((String)species)), v -> v != null, v -> pokemon.setSpecies(v), "invalid species '" + species + "'");
        }
        if (model.getNickname().getLiteral() != null) {
            pokemon.setNickname(model.getNickname().getComponent(new Object[0]));
        }
        Gender g = Gender.FEMALE.name().equals(model.getGender()) ? Gender.FEMALE : (Gender.MALE.name().equals(model.getGender()) ? Gender.MALE : Gender.GENDERLESS);
        pokemon.setGender(errors.expect(g, v -> {
            try {
                Gender.valueOf((String)model.getGender());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }, "invalid gender '" + model.getGender() + "'"));
        pokemon.setLevel(errors.expect(Integer.valueOf(model.getLevel()), v -> v > 0, "invalid level '%s'").intValue());
        if (!model.getNature().isBlank()) {
            String nature = Locations.withoutNamespace(model.getNature());
            errors.doif(Natures.INSTANCE.getNature(nature), v -> v != null, v -> pokemon.setNature(v), "invalid nature '" + nature + "'");
        }
        if (!model.getAbility().isBlank()) {
            String ability = Locations.withoutNamespace(model.getAbility());
            errors.doif(Abilities.INSTANCE.get(ability), v -> v != null, v -> pokemon.updateAbility(v.create(true, Priority.NORMAL)), "invalid ability '" + ability + "'");
        }
        if (model.getMoveset().size() > 4) {
            errors.add(RCTError.of("too many moves " + model.getMoveset().size() + "/4"));
        }
        model.getMoveset().stream().limit(4L).forEach(m -> {
            String move = Locations.withoutNamespace(m);
            errors.doif(Moves.INSTANCE.getByName(move), v -> v != null, v -> pokemon.getMoveSet().add(v.create()), "invalid move '" + move + "'");
        });
        pokemon.setIV((Stat)Stats.HP, errors.expect(Integer.valueOf(model.getIVs().getHP()), v -> v >= 0 && v <= 31, "invalid hp iv '%s'").intValue());
        pokemon.setIV((Stat)Stats.ATTACK, errors.expect(Integer.valueOf(model.getIVs().getAtk()), v -> v >= 0 && v <= 31, "invalid atk iv '%s'").intValue());
        pokemon.setIV((Stat)Stats.DEFENCE, errors.expect(Integer.valueOf(model.getIVs().getDef()), v -> v >= 0 && v <= 31, "invalid def iv '%s'").intValue());
        pokemon.setIV((Stat)Stats.SPECIAL_ATTACK, errors.expect(Integer.valueOf(model.getIVs().getSpA()), v -> v >= 0 && v <= 31, "invalid spa iv '%s'").intValue());
        pokemon.setIV((Stat)Stats.SPECIAL_DEFENCE, errors.expect(Integer.valueOf(model.getIVs().getSpD()), v -> v >= 0 && v <= 31, "invalid spd iv '%s'").intValue());
        pokemon.setIV((Stat)Stats.SPEED, errors.expect(Integer.valueOf(model.getIVs().getSpe()), v -> v >= 0 && v <= 31, "invalid spe iv '%s'").intValue());
        pokemon.setEV((Stat)Stats.HP, errors.expect(Integer.valueOf(model.getEVs().getHP()), v -> v >= 0 && v <= 255, "invalid hp ev '%s'").intValue());
        pokemon.setEV((Stat)Stats.ATTACK, errors.expect(Integer.valueOf(model.getEVs().getAtk()), v -> v >= 0 && v <= 255, "invalid atk ev '%s'").intValue());
        pokemon.setEV((Stat)Stats.DEFENCE, errors.expect(Integer.valueOf(model.getEVs().getDef()), v -> v >= 0 && v <= 255, "invalid def ev '%s'").intValue());
        pokemon.setEV((Stat)Stats.SPECIAL_ATTACK, errors.expect(Integer.valueOf(model.getEVs().getSpA()), v -> v >= 0 && v <= 255, "invalid spa ev '%s'").intValue());
        pokemon.setEV((Stat)Stats.SPECIAL_DEFENCE, errors.expect(Integer.valueOf(model.getEVs().getSpD()), v -> v >= 0 && v <= 255, "invalid spd ev '%s'").intValue());
        pokemon.setEV((Stat)Stats.SPEED, errors.expect(Integer.valueOf(model.getEVs().getSpe()), v -> v >= 0 && v <= 255, "invalid spe ev '%s'").intValue());
        pokemon.setShiny(model.isShiny());
        pokemon.setForcedAspects(model.getAspects());
        pokemon.setGmaxFactor(model.getGimmicks().gmax());
        if (model.getGimmicks().tera() != null) {
            TeraType tt = TeraTypes.get((String)model.getGimmicks().tera());
            if (tt != null) {
                pokemon.setTeraType(tt);
            } else {
                errors.add(RCTError.of(String.format("invalid tera type '%s'", model.getGimmicks().tera())));
            }
        }
        String item = null;
        boolean itemValid = false;
        for (String itemId : model.getHeldItems()) {
            item = Locations.withNamespace("cobblemon", itemId);
            ResourceLocation rl = ResourceLocation.parse((String)item);
            if (!BuiltInRegistries.ITEM.containsKey(rl)) continue;
            pokemon.swapHeldItem(((Item)BuiltInRegistries.ITEM.get(rl)).getDefaultInstance(), true);
            itemValid = true;
            break;
        }
        if (item != null && !itemValid) {
            errors.add(RCTError.of("invalid held item '" + item + "'"));
        }
        return pokemon;
    }
}

