/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.trainer;

import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.battle.BagItemLike;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class TrainerBag {
    private Map<BagItem, Integer> items = new HashMap<BagItem, Integer>();

    public void add(String itemId, int quantity) {
        if (quantity > 0) {
            ResourceLocation itemLocation = ResourceLocation.parse((String)itemId);
            if (!BuiltInRegistries.ITEM.containsKey(itemLocation)) {
                throw new IllegalArgumentException("invalid item '" + itemId + "'");
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(itemLocation);
            if (item instanceof BagItemLike) {
                BagItemLike bagItemLike = (BagItemLike)item;
                this.items.put(bagItemLike.getBagItem(item.getDefaultInstance()), quantity);
            } else if (item instanceof PokemonSelectingItem) {
                PokemonSelectingItem selectingItem = (PokemonSelectingItem)item;
                this.items.put(selectingItem.getBagItem(), quantity);
            } else {
                throw new IllegalArgumentException("'" + itemId + "' is neither a BagItemLike or PokemonSelectingItem");
            }
        }
    }

    public BagItem use(BagItem item) {
        this.items.computeIfPresent(item, (k, v) -> v > 1 ? Integer.valueOf(v - 1) : null);
        return item;
    }

    public Set<BagItem> getItems() {
        return this.items.keySet();
    }

    public int getQuanity(BagItem item) {
        return this.items.getOrDefault(item, 0);
    }

    public TrainerBag clone() {
        TrainerBag bag = new TrainerBag();
        bag.items.putAll(this.items);
        return bag;
    }
}

