/*
 * Decompiled with CFR 0.152.
 */
package com.mazeymoos.cpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mazeymoos.cpc.commands.ChatProxyListener;
import com.mazeymoos.cpc.commands.FrontCommand;
import com.mazeymoos.cpc.commands.SystemCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5251;

public class ClovesPluralCraft
implements ModInitializer {
    public static final String MOD_ID = "cloves-pluralcraft";
    public static final String MOD_NAME = "Clove's PluralCraft";
    private static final Path CONFIG_DIR = Paths.get("config/cpc", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<UUID, SystemData> systemDataMap = new HashMap<UUID, SystemData>();

    public void onInitialize() {
        System.out.println("[CPC] Clove's PluralCraft Loaded!");
        ClovesPluralCraft.loadAllSystems();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            SystemCommand.register((CommandDispatcher<class_2168>)dispatcher);
            FrontCommand.register((CommandDispatcher<class_2168>)dispatcher);
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sys").redirect(dispatcher.getRoot().getChild("system")));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"f").redirect(dispatcher.getRoot().getChild("front")));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"member").redirect(dispatcher.getRoot().getChild("front")));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"proxy").redirect(dispatcher.getRoot().getChild("front")));
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ClovesPluralCraft.saveAllSystems());
        ChatProxyListener.register();
    }

    public static void loadAllSystems() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            Files.list(CONFIG_DIR).forEach(path -> {
                try {
                    UUID uuid = UUID.fromString(path.getFileName().toString().replace(".json", ""));
                    SystemData data = (SystemData)GSON.fromJson(Files.readString(path), SystemData.class);
                    systemDataMap.put(uuid, data);
                }
                catch (Exception e) {
                    System.err.println("[CPC] Failed to load system file: " + String.valueOf(path));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAllSystems() {
        systemDataMap.forEach((uuid, system) -> ClovesPluralCraft.saveSystem(uuid));
    }

    public static void saveSystem(UUID uuid) {
        try {
            Path filePath = CONFIG_DIR.resolve(uuid.toString() + ".json");
            Files.writeString(filePath, (CharSequence)GSON.toJson((Object)systemDataMap.get(uuid)), new OpenOption[0]);
        }
        catch (Exception e) {
            System.err.println("[CPC] Failed to save system file: " + String.valueOf(uuid));
        }
    }

    public static class_2561 formatMessage(String message, int color) {
        return class_2561.method_43470((String)"[CPC] ").method_27694(style -> style.method_27703(class_5251.method_27717((int)0xFF55FF))).method_10852((class_2561)class_2561.method_43470((String)message).method_27694(style -> style.method_27703(class_5251.method_27717((int)color))));
    }

    public static class SystemData {
        public String systemName;
        public Map<String, Boolean> fronts = new HashMap<String, Boolean>();
        public String activeFront = "";

        public SystemData(String systemName) {
            this.systemName = systemName;
        }
    }
}

