/*
 * Decompiled with CFR 0.152.
 */
package com.mazeymoos.cpc.commands;

import com.mazeymoos.cpc.ClovesPluralCraft;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class FrontCommand {
    private static final SuggestionProvider<class_2168> FRONT_SUGGESTIONS = (context, builder) -> {
        UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
        if (ClovesPluralCraft.systemDataMap.containsKey(playerUUID)) {
            return class_2172.method_9265(ClovesPluralCraft.systemDataMap.get((Object)playerUUID).fronts.keySet(), (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"front").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            String frontName = StringArgumentType.getString((CommandContext)context, (String)"name");
            FrontCommand.addFront(playerUUID, frontName, (class_2168)context.getSource());
            return 1;
        })))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(FRONT_SUGGESTIONS).executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            String frontName = StringArgumentType.getString((CommandContext)context, (String)"name");
            FrontCommand.deleteFront(playerUUID, frontName, (class_2168)context.getSource());
            return 1;
        })))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(FRONT_SUGGESTIONS).executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            String frontName = StringArgumentType.getString((CommandContext)context, (String)"name");
            FrontCommand.setFront(playerUUID, frontName, (class_2168)context.getSource());
            return 1;
        })))).then(class_2170.method_9247((String)"clear").executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            FrontCommand.clearFront(playerUUID, (class_2168)context.getSource());
            return 1;
        })));
    }

    private static void addFront(UUID uuid, String frontName, class_2168 source) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7d[CPC] \u00a7cYou do not have a system!"), false);
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.put(frontName, true);
        ClovesPluralCraft.saveSystem(uuid);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7d[CPC] \u00a7aFront '" + frontName + "' added!")), false);
    }

    private static void deleteFront(UUID uuid, String frontName, class_2168 source) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7d[CPC] \u00a7cYou do not have a system!"), false);
            return;
        }
        if (!ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.containsKey(frontName)) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7d[CPC] \u00a7cFront '" + frontName + "' does not exist!")), false);
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.remove(frontName);
        ClovesPluralCraft.saveSystem(uuid);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7d[CPC] \u00a7aFront '" + frontName + "' deleted!")), false);
    }

    private static void setFront(UUID uuid, String frontName, class_2168 source) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7d[CPC] \u00a7cYou do not have a system!"), false);
            return;
        }
        if (!ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.containsKey(frontName)) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7d[CPC] \u00a7cFront '" + frontName + "' does not exist!")), false);
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).activeFront = frontName;
        ClovesPluralCraft.saveSystem(uuid);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7d[CPC] \u00a7aNow fronting as '" + frontName + "'!")), false);
    }

    private static void clearFront(UUID uuid, class_2168 source) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7d[CPC] \u00a7cYou do not have a system!"), false);
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).activeFront = "";
        ClovesPluralCraft.saveSystem(uuid);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7d[CPC] \u00a7aFront cleared!"), false);
    }
}

