/*
 * Decompiled with CFR 0.152.
 */
package com.mazeymoos.cpc.commands;

import com.mazeymoos.cpc.ClovesPluralCraft;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class SystemCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"system").then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            String systemName = StringArgumentType.getString((CommandContext)context, (String)"name");
            SystemCommand.createSystem(playerUUID, systemName, (class_2168)context.getSource());
            return 1;
        })))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            SystemCommand.renameSystem(playerUUID, newName, (class_2168)context.getSource());
            return 1;
        })))).then(class_2170.method_9247((String)"remove").executes(context -> {
            UUID playerUUID = ((class_2168)context.getSource()).method_44023().method_5667();
            SystemCommand.removeSystem(playerUUID, (class_2168)context.getSource());
            return 1;
        })));
    }

    private static void createSystem(UUID uuid, String name, class_2168 source) {
        if (ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            SystemCommand.sendMessage(source, "You already have a system!", class_124.field_1061);
            return;
        }
        ClovesPluralCraft.SystemData newSystem = new ClovesPluralCraft.SystemData(name);
        ClovesPluralCraft.systemDataMap.put(uuid, newSystem);
        ClovesPluralCraft.saveSystem(uuid);
        SystemCommand.sendMessage(source, "System '" + name + "' created!", class_124.field_1060);
    }

    private static void renameSystem(UUID uuid, String newName, class_2168 source) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            SystemCommand.sendMessage(source, "You do not have a system!", class_124.field_1061);
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).systemName = newName;
        ClovesPluralCraft.saveSystem(uuid);
        SystemCommand.sendMessage(source, "System renamed to '" + newName + "'!", class_124.field_1060);
    }

    private static void removeSystem(UUID uuid, class_2168 source) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            SystemCommand.sendMessage(source, "You do not have a system to remove!", class_124.field_1061);
            return;
        }
        ClovesPluralCraft.systemDataMap.remove(uuid);
        ClovesPluralCraft.saveSystem(uuid);
        SystemCommand.sendMessage(source, "Your system has been removed!", class_124.field_1060);
    }

    private static void sendMessage(class_2168 source, String message, class_124 color) {
        class_5250 prefix = class_2561.method_43470((String)"[CPC] ").method_10862(class_2583.field_24360.method_10977(class_124.field_1076));
        class_5250 textMessage = class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_10977(color));
        source.method_9226(() -> SystemCommand.lambda$sendMessage$3((class_2561)prefix, (class_2561)textMessage), false);
    }

    private static /* synthetic */ class_2561 lambda$sendMessage$3(class_2561 prefix, class_2561 textMessage) {
        return class_2561.method_43473().method_10852(prefix).method_10852(textMessage);
    }
}

