/*
 * Decompiled with CFR 0.152.
 */
package com.mazeymoos.cpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mazeymoos.cpc.commands.FrontCommand;
import com.mazeymoos.cpc.commands.FrontCommandTabCompleter;
import com.mazeymoos.cpc.commands.SystemCommand;
import com.mazeymoos.cpc.commands.SystemCommandTabCompleter;
import com.mazeymoos.cpc.listeners.ChatProxyListener;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClovesPluralCraft
extends JavaPlugin {
    public static final String MOD_NAME = "Clove's PluralCraft";
    private static final Path CONFIG_DIR = Path.of("plugins/CPC", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<UUID, SystemData> systemDataMap = new HashMap<UUID, SystemData>();
    private static ClovesPluralCraft instance;

    public void onEnable() {
        this.getLogger().info("[CPC] Clove's PluralCraft Loaded!");
        ClovesPluralCraft.loadAllSystems();
        instance = this;
        this.getCommand("system").setExecutor((CommandExecutor)new SystemCommand());
        this.getCommand("system").setTabCompleter((TabCompleter)new SystemCommandTabCompleter());
        this.getCommand("front").setExecutor((CommandExecutor)new FrontCommand());
        this.getCommand("front").setTabCompleter((TabCompleter)new FrontCommandTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new ChatProxyListener(), (Plugin)this);
    }

    public static ClovesPluralCraft getInstance() {
        return instance;
    }

    public void onDisable() {
        ClovesPluralCraft.saveAllSystems();
    }

    public static void loadAllSystems() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            Files.list(CONFIG_DIR).forEach(path -> {
                try {
                    UUID uuid = UUID.fromString(path.getFileName().toString().replace(".json", ""));
                    SystemData data = (SystemData)GSON.fromJson(Files.readString(path), SystemData.class);
                    systemDataMap.put(uuid, data);
                }
                catch (Exception e) {
                    System.err.println("Failed to load system file: " + String.valueOf(path));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAllSystems() {
        systemDataMap.forEach((uuid, system) -> ClovesPluralCraft.saveSystem(uuid));
    }

    public static void saveSystem(UUID uuid) {
        try {
            Path filePath = CONFIG_DIR.resolve(uuid.toString() + ".json");
            Files.writeString(filePath, (CharSequence)GSON.toJson((Object)systemDataMap.get(uuid)), new OpenOption[0]);
        }
        catch (Exception e) {
            System.err.println("Failed to save system file: " + String.valueOf(uuid));
        }
    }

    public static class SystemData {
        public String systemName;
        public Map<String, Boolean> fronts = new HashMap<String, Boolean>();
        public String activeFront = "";
        public Map<String, String> frontSkins = new HashMap<String, String>();

        public SystemData(String systemName) {
            this.systemName = systemName;
        }
    }
}

