/*
 * Decompiled with CFR 0.152.
 */
package com.mazeymoos.cpc.commands;

import com.mazeymoos.cpc.ClovesPluralCraft;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FrontCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String action;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (args.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /front <add|delete|set|clear|skin> [name] [skin]");
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /front add <name>");
                    return true;
                }
                this.addFront(playerUUID, args[1], sender);
                break;
            }
            case "delete": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /front delete <name>");
                    return true;
                }
                this.deleteFront(playerUUID, args[1], sender);
                break;
            }
            case "set": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /front set <name>");
                    return true;
                }
                this.setFront(player, args[1], sender);
                break;
            }
            case "clear": {
                this.clearFront(playerUUID, sender);
                break;
            }
            case "skin": {
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /front skin <front> <skin (URL or Username)>");
                    return true;
                }
                this.setFrontSkin(playerUUID, args[1], args[2], sender);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand! Use /front <add|delete|set|clear|skin>");
            }
        }
        return true;
    }

    private void addFront(UUID uuid, String frontName, CommandSender sender) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have a system!");
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.put(frontName, true);
        ClovesPluralCraft.saveSystem(uuid);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Front '" + frontName + "' added!");
    }

    private void deleteFront(UUID uuid, String frontName, CommandSender sender) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have a system!");
            return;
        }
        if (!ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.containsKey(frontName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Front '" + frontName + "' does not exist!");
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.remove(frontName);
        ClovesPluralCraft.systemDataMap.get((Object)uuid).frontSkins.remove(frontName);
        ClovesPluralCraft.saveSystem(uuid);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Front '" + frontName + "' deleted!");
    }

    private void setFront(Player player, String frontName, CommandSender sender) {
        UUID uuid = player.getUniqueId();
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have a system!");
            return;
        }
        if (!ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.containsKey(frontName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Front '" + frontName + "' does not exist!");
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).activeFront = frontName;
        ClovesPluralCraft.saveSystem(uuid);
        String skin = ClovesPluralCraft.systemDataMap.get((Object)uuid).frontSkins.get(frontName);
        if (skin != null && !skin.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "This has not been implemented yet!");
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Now fronting as '" + frontName + "'!");
    }

    private void clearFront(UUID uuid, CommandSender sender) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have a system!");
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).activeFront = "";
        ClovesPluralCraft.saveSystem(uuid);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Front cleared!");
    }

    private void setFrontSkin(UUID uuid, String frontName, String skinInput, CommandSender sender) {
        if (!ClovesPluralCraft.systemDataMap.containsKey(uuid)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have a system!");
            return;
        }
        if (!ClovesPluralCraft.systemDataMap.get((Object)uuid).fronts.containsKey(frontName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Front '" + frontName + "' does not exist!");
            return;
        }
        ClovesPluralCraft.systemDataMap.get((Object)uuid).frontSkins.put(frontName, skinInput);
        ClovesPluralCraft.saveSystem(uuid);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Skin set for front '" + frontName + "'!");
        if (frontName.equals(ClovesPluralCraft.systemDataMap.get((Object)uuid).activeFront)) {
            Player player = (Player)sender;
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Applying skin...");
        }
    }
}

