/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod;

import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.ColorUtils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="skirk")
public class SkirkConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> ENABLE_DIRECTIONAL_INDICATOR;
    public static final ModConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_TEXTURE;
    public static final ModConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_DISTANCE;
    public static final ModConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_R;
    public static final ModConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_G;
    public static final ModConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_B;
    public static final ModConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_A;
    public static final ModConfigSpec.ConfigValue<Boolean> ENABLE_FADE_OUT;
    public static final ModConfigSpec.ConfigValue<Integer> INDICATE_TIME;
    public static final ModConfigSpec.ConfigValue<Boolean> ENABLE_DAMAGE_TEXT;
    public static final ModConfigSpec.ConfigValue<Boolean> ENABLE_HEALTH_BARS;
    public static final ModConfigSpec.ConfigValue<Boolean> ONLY_SHOW_TARGET_HEALTH_BAR;
    public static final ModConfigSpec.ConfigValue<Boolean> ENABLE_BLOOD_OVERLAY;
    private static final ModConfigSpec.IntValue TEXT_COLOR;
    private static final ModConfigSpec.IntValue HURT_COLOR;
    public static final ModConfigSpec.IntValue ALPHA;
    public static final ModConfigSpec.BooleanValue SHOW_EXCLAMATION_POINT;
    public static final ModConfigSpec.BooleanValue DO_SIZE_EFFECTS;
    public static final ModConfigSpec.BooleanValue DO_COLOR_EFFECTS;
    public static final ModConfigSpec.BooleanValue DO_SHAKE_EFFECTS;
    public static int textColor;
    public static int hurtColor;
    public static int alpha;
    public static boolean showExclamationPoint;
    public static boolean doSizeEffects;
    public static boolean doColorEffects;
    public static boolean doShakeEffects;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        textColor = (Integer)TEXT_COLOR.get();
        hurtColor = (Integer)HURT_COLOR.get();
        alpha = (Integer)ALPHA.get();
        showExclamationPoint = (Boolean)SHOW_EXCLAMATION_POINT.get();
        doSizeEffects = (Boolean)DO_SIZE_EFFECTS.get();
        doColorEffects = (Boolean)DO_COLOR_EFFECTS.get();
        doShakeEffects = (Boolean)DO_SHAKE_EFFECTS.get();
    }

    static {
        TEXT_COLOR = BUILDER.comment("ARGB, Default color for indicators - https://argb-int-calculator.netlify.app/").defineInRange("textColor", ColorUtils.color(255, 255, 255, 255), Integer.MIN_VALUE, Integer.MAX_VALUE);
        HURT_COLOR = BUILDER.comment("RGB, Default color for hurt effects - https://argb-int-calculator.netlify.app/").defineInRange("hurtColor", ColorUtils.color(255, 255, 10, 10), Integer.MIN_VALUE, Integer.MAX_VALUE);
        ALPHA = BUILDER.comment("0-255 Alpha value").defineInRange("alpha", 255, Integer.MIN_VALUE, Integer.MAX_VALUE);
        SHOW_EXCLAMATION_POINT = BUILDER.comment("If true, critical hits will add exclamation points").define("showExclamationPoint", true);
        DO_SIZE_EFFECTS = BUILDER.comment("If true, hits will change size based on how strong they are.").define("doSizeEffects", true);
        DO_COLOR_EFFECTS = BUILDER.comment("If true, hits will turn red based on how strong they are.").define("doColorEffects", true);
        DO_SHAKE_EFFECTS = BUILDER.comment("If true, hits will shake based on how strong they are.").define("doShakeEffects", true);
        BUILDER.push("Directional Indicator").comment(" arrow that shows where incoming damage came from");
        ENABLE_DIRECTIONAL_INDICATOR = BUILDER.comment(" Enables the directional damage indicator").define("EnableDirectionalIndicator", true);
        DIRECTIONAL_INDICATOR_TEXTURE = BUILDER.comment(String.format(" %d-%d (inclusive)", 0, 1)).define("DirectionalIndicatorTexture", (Object)0);
        DIRECTIONAL_INDICATOR_R = BUILDER.comment(" Red (0-255)").define("DirectionalIndicatorRed", (Object)206);
        DIRECTIONAL_INDICATOR_G = BUILDER.comment(" Green (0-255)").define("DirectionalIndicatorGreen", (Object)0);
        DIRECTIONAL_INDICATOR_B = BUILDER.comment(" Blue (0-255)").define("DirectionalIndicatorBlue", (Object)37);
        DIRECTIONAL_INDICATOR_A = BUILDER.comment(" Alpha (0-255)").define("DirectionalIndicatorAlpha", (Object)255);
        DIRECTIONAL_INDICATOR_DISTANCE = BUILDER.comment(" Distance from the center of the screen that the directional damage indicator appears.").define("DirectionalIndicatorDistance", (Object)0);
        ENABLE_FADE_OUT = BUILDER.comment(" Fade out the damage indicator over time").define("EnableFadeOut", true);
        INDICATE_TIME = BUILDER.comment(" Time for damage indicator to show (in ticks)").define("IndicateTime", (Object)25);
        ENABLE_DAMAGE_TEXT = BUILDER.comment(" floating text that shows the amount of damage done to an entity").define("EnableDamageText", true);
        BUILDER.pop();
        BUILDER.push("Health Bar").comment(" a text health bar for entities");
        ENABLE_HEALTH_BARS = BUILDER.comment(" Enables health bar").define("EnableHealthBar", false);
        ONLY_SHOW_TARGET_HEALTH_BAR = BUILDER.comment(" Only show health bar for entities the player is directly looking at. If false, shows health bar for all nearby entities").define("OnlyShowTargetHealthBar", true);
        BUILDER.pop();
        BUILDER.push("Blood Overlay").comment(" an overlay of red outlining your screen when you take damage");
        ENABLE_BLOOD_OVERLAY = BUILDER.comment(" Enables blood overlay").define("EnableBloodOverlay", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

