/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.github.yzqdev.skirkmod.damageindicator.DamageTextHandler;
import com.github.yzqdev.skirkmod.damageindicator.IndicatorOverlay;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="skirk", value={Dist.CLIENT})
public class DamageHandler {
    private static float lastHealth = -1.0f;
    public static final HashMap<Integer, Float> lastHealthForOtherEntities = new HashMap();

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            LocalPlayer localPlayer = mc.player;
            if (((Boolean)SkirkConfig.ENABLE_DIRECTIONAL_INDICATOR.get()).booleanValue()) {
                float currentHealth = localPlayer.getHealth();
                boolean tookDamage = lastHealth != -1.0f && currentHealth < lastHealth;
                lastHealth = currentHealth;
                if (localPlayer.getLastDamageSource() != null && localPlayer.getLastDamageSource().getSourcePosition() != null) {
                    Vec3 damageSource = localPlayer.getLastDamageSource().getSourcePosition();
                    if (tookDamage) {
                        IndicatorOverlay.triggerOverlay(damageSource);
                    }
                }
            }
            if (((Boolean)SkirkConfig.ENABLE_DAMAGE_TEXT.get()).booleanValue()) {
                AABB aabb = new AABB(localPlayer.getX() - 50.0, localPlayer.getY() - 50.0, localPlayer.getZ() - 50.0, localPlayer.getX() + 50.0, localPlayer.getY() + 50.0, localPlayer.getZ() + 50.0);
                List nearbyEntities = localPlayer.level().getEntities((Entity)localPlayer, aabb);
                HashSet<Integer> inRangeEntityIds = new HashSet<Integer>();
                for (Entity entity : nearbyEntities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    inRangeEntityIds.add(livingEntity.getId());
                    if (lastHealthForOtherEntities.containsKey(livingEntity.getId()) && livingEntity.getHealth() < lastHealthForOtherEntities.get(livingEntity.getId()).floatValue() && entity.getId() != Minecraft.getInstance().player.getId() && livingEntity.getLastDamageSource() != null && !(livingEntity.getLastDamageSource().getEntity() instanceof LocalPlayer)) {
                        double x = entity.getX();
                        double y = entity.getY() + (double)entity.getEyeHeight();
                        double z = entity.getZ();
                        float damage = lastHealthForOtherEntities.get(livingEntity.getId()).floatValue() - livingEntity.getHealth();
                        DamageSource source = livingEntity.getLastDamageSource();
                        DamageTextHandler.damageTexts.add(new DamageTextHandler.DamageText(x, y, z, damage, source));
                    }
                    lastHealthForOtherEntities.put(livingEntity.getId(), Float.valueOf(livingEntity.getHealth()));
                }
                lastHealthForOtherEntities.keySet().removeIf(id -> !inRangeEntityIds.contains(id));
            }
        }
    }
}

