/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.damageindicator.DamageTextHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@EventBusSubscriber(modid="skirk", value={Dist.CLIENT})
public class DamageTextRenderer {
    @SubscribeEvent
    public static void onRenderWorldStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
            Font fontRenderer = mc.font;
            long currentTime = System.currentTimeMillis();
            ArrayList<DamageTextHandler.DamageText> damageTexts = new ArrayList<DamageTextHandler.DamageText>(DamageTextHandler.getDamageTexts());
            damageTexts.removeIf(text -> currentTime - text.getTimestamp() > 1000L);
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            for (DamageTextHandler.DamageText text2 : damageTexts) {
                Matrix4f matrix = new Matrix4f();
                if (text2 == null || !DamageTextRenderer.hasLineOfSight((LivingEntity)mc.player, mc.player.level(), (float)text2.getX(), (float)text2.getY(), (float)text2.getZ())) continue;
                long age = currentTime - text2.getTimestamp();
                float progress = age / text2.getDuration();
                float alpha = 1.0f - progress;
                float scale = 1.0f + 0.5f * (1.0f - progress);
                matrix.translate((float)(text2.getX() - renderManager.camera.getPosition().x), (float)(text2.getY() - renderManager.camera.getPosition().y), (float)(text2.getZ() - renderManager.camera.getPosition().z));
                matrix.rotate((Quaternionfc)event.getCamera().rotation());
                matrix.rotateY((float)Math.PI);
                matrix.scale(-0.025f * scale, -0.025f * scale, 0.025f * scale);
                matrix.translate(0.0f, -progress * 25.0f, 0.0f);
                Font.DisplayMode displayMode = Font.DisplayMode.SEE_THROUGH;
                String damage = String.format("%.0f", Float.valueOf(text2.getDamage()));
                int color = DamageTextRenderer.getDamageColor(text2.getDamage(), alpha).getRGB();
                int textWidth = fontRenderer.width(damage);
                Objects.requireNonNull(fontRenderer);
                if (DamageTextRenderer.getDamageColor(text2.getDamage(), alpha).getAlpha() <= 25) continue;
                fontRenderer.drawInBatch(damage, (float)(-textWidth) / 2.0f, -4.5f, color, false, matrix, (MultiBufferSource)bufferSource, displayMode, 0, 0xF000F0);
            }
        }
    }

    private static boolean hasLineOfSight(LivingEntity player, Level level, float x, float y, float z) {
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
        Vec3 vec31 = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        return vec31.distanceTo(vec3) <= 128.0 && level.clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getType() == HitResult.Type.MISS;
    }

    private static Color getDamageColor(float damage, float alpha) {
        if (damage > 15.0f) {
            return new Color(1.0f, 0.0f, 0.0f, alpha);
        }
        if (damage > 10.0f) {
            return new Color(1.0f, 0.13333334f, 0.13333334f, alpha);
        }
        if (damage > 7.0f) {
            return new Color(1.0f, 0.50980395f, 0.0f, alpha);
        }
        return new Color(1.0f, 0.9411765f, 0.0f, alpha);
    }

    private static Color getDamageColor(DamageSource source, float alpha) {
        if (source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.EXPLOSION)) {
            return new Color(1.0f, 0.27058825f, 0.0f, alpha);
        }
        if (source.is(DamageTypes.MAGIC) || source.is(DamageTypes.INDIRECT_MAGIC)) {
            return new Color(0.5019608f, 0.0f, 0.5019608f, alpha);
        }
        if (source.is(DamageTypes.DROWN)) {
            return new Color(0.0f, 1.0f, 1.0f, alpha);
        }
        if (source.is(DamageTypes.WITHER)) {
            return new Color(0.29411766f, 0.0f, 0.50980395f, alpha);
        }
        if (source.is(DamageTypes.PLAYER_ATTACK) || source.is(DamageTypes.MOB_ATTACK)) {
            return new Color(0.69803923f, 0.13333334f, 0.13333334f, alpha);
        }
        return new Color(1.0f, 1.0f, 1.0f, alpha);
    }
}

