/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.github.yzqdev.skirkmod.damageindicator.DamageHandler;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@EventBusSubscriber(modid="skirk", value={Dist.CLIENT})
public class HealthBarRenderer {
    static final boolean $assertionsDisabled = !HealthBarRenderer.class.desiredAssertionStatus();

    @SubscribeEvent
    public static void onRenderWorldStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || !((Boolean)SkirkConfig.ENABLE_HEALTH_BARS.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        if (((Boolean)SkirkConfig.ONLY_SHOW_TARGET_HEALTH_BAR.get()).booleanValue()) {
            HitResult HitResult2 = mc.hitResult;
            if (HitResult2 instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)HitResult2;
                int id = entityHitResult.getEntity().getId();
                HealthBarRenderer.renderHealthBar(id, (MultiBufferSource)bufferSource, event.getCamera());
                return;
            }
            return;
        }
        for (int entityId : DamageHandler.lastHealthForOtherEntities.keySet()) {
            HealthBarRenderer.renderHealthBar(entityId, (MultiBufferSource)bufferSource, event.getCamera());
        }
    }

    private static void renderHealthBar(int entityId, MultiBufferSource bufferSource, Camera camera) {
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
        Font fontRenderer = mc.font;
        Matrix4f poseStack = new Matrix4f();
        ClientLevel level = Minecraft.getInstance().level;
        if (!$assertionsDisabled && level == null) {
            throw new AssertionError();
        }
        Entity entity = level.getEntity(entityId);
        if (!DamageHandler.lastHealthForOtherEntities.containsKey(entityId)) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            float y = (float)(entity2.getY() + (double)entity2.getBbHeight() + (double)0.4f);
            if (!$assertionsDisabled && mc.player == null) {
                throw new AssertionError();
            }
            if (!HealthBarRenderer.hasLineOfSight((LivingEntity)mc.player, mc.player.level(), (float)entity2.getX(), y, (float)entity2.getZ(), 20.0)) {
                return;
            }
            poseStack.translate((float)(entity2.getX() - renderManager.camera.getPosition().x), (float)((double)y - renderManager.camera.getPosition().y), (float)(entity2.getZ() - renderManager.camera.getPosition().z));
            poseStack.rotate((Quaternionfc)camera.rotation());
            poseStack.rotateY((float)Math.PI);
            poseStack.scale(-0.025f, -0.025f, 0.025f);
            Font.DisplayMode displayMode = Font.DisplayMode.SEE_THROUGH;
            String damage = String.valueOf(Math.round(DamageHandler.lastHealthForOtherEntities.get(entityId).floatValue()));
            String maxHealth = String.valueOf((int)Math.ceil(entity2.getMaxHealth()));
            String text = damage + " / " + maxHealth;
            int color = new Color(255, 255, 255).getRGB();
            int textWidth = fontRenderer.width(text);
            Objects.requireNonNull(fontRenderer);
            fontRenderer.drawInBatch(text, (float)(-textWidth) / 2.0f, -4.5f, color, false, poseStack, bufferSource, displayMode, 0, 0xF000F0);
        }
    }

    private static boolean hasLineOfSight(LivingEntity player, Level level, float x, float y, float z, double distance) {
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
        Vec3 vec31 = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        return vec31.distanceTo(vec3) <= distance && level.clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, CollisionContext.empty())).getType() == HitResult.Type.MISS;
    }
}

