/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class IndicatorOverlay {
    public static final int INDICATOR_TEXTURES_COUNT = 2;
    private static ResourceLocation INDICATOR_TEXTURE;
    private static final ResourceLocation BLOOD_OVERLAY;
    public static Vec3 damageSource;
    public static boolean showDirectional;
    public static float counter;
    private static boolean showBlood;
    private static float bloodAlpha;
    private static final float BLOOD_FADE_SPEED = 0.02f;
    static final boolean $assertionsDisabled;

    public static void setup() {
        INDICATOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"skirk", (String)("textures/overlays/directional_indicator_" + String.valueOf(SkirkConfig.DIRECTIONAL_INDICATOR_TEXTURE.get()) + ".png"));
    }

    public static void triggerOverlay(Vec3 sourcePosition) {
        damageSource = sourcePosition;
        showDirectional = true;
        counter = 0.0f;
        showBlood = true;
        bloodAlpha = 1.0f;
    }

    public static void drawIndicatorOverlay(GuiGraphics poseStack, Window window) {
        int width = window.getGuiScaledWidth();
        int height = window.getGuiScaledHeight();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (!Minecraft.getInstance().options.hideGui && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            int x = width / 2;
            int y = height / 2;
            float deltaFrameTime = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            if (showBlood && ((Boolean)SkirkConfig.ENABLE_BLOOD_OVERLAY.get()).booleanValue()) {
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLOOD_OVERLAY);
                poseStack.setColor(1.0f, 1.0f, 1.0f, bloodAlpha);
                bloodAlpha -= 0.02f * deltaFrameTime;
                if (bloodAlpha <= 0.0f) {
                    showBlood = false;
                    bloodAlpha = 0.0f;
                }
                poseStack.blit(BLOOD_OVERLAY, 0, 0, width, height, 0.0f, 0.0f, width, height, width, height);
            }
            if (showDirectional && ((Boolean)SkirkConfig.ENABLE_DIRECTIONAL_INDICATOR.get()).booleanValue()) {
                if ((counter += deltaFrameTime) >= (float)((Integer)SkirkConfig.INDICATE_TIME.get()).intValue()) {
                    showDirectional = false;
                }
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                float r = (float)((Integer)SkirkConfig.DIRECTIONAL_INDICATOR_R.get()).intValue() / 255.0f;
                float g = (float)((Integer)SkirkConfig.DIRECTIONAL_INDICATOR_G.get()).intValue() / 255.0f;
                float b = (float)((Integer)SkirkConfig.DIRECTIONAL_INDICATOR_B.get()).intValue() / 255.0f;
                float a = (float)((Integer)SkirkConfig.DIRECTIONAL_INDICATOR_A.get()).intValue() / 255.0f;
                if (((Boolean)SkirkConfig.ENABLE_FADE_OUT.get()).booleanValue()) {
                    a = a * ((float)((Integer)SkirkConfig.INDICATE_TIME.get()).intValue() - counter) / (float)((Integer)SkirkConfig.INDICATE_TIME.get()).intValue();
                }
                poseStack.setColor(r, g, b, a);
                if (!$assertionsDisabled && Minecraft.getInstance().player == null) {
                    throw new AssertionError();
                }
                double finalAngle = IndicatorOverlay.calculateFinalAngle(Minecraft.getInstance().player.getForward(), Minecraft.getInstance().player.position(), Minecraft.getInstance().player.position().add(damageSource.subtract(Minecraft.getInstance().player.position())));
                float radians = (float)Math.toRadians(finalAngle);
                float radians2 = (float)Math.toRadians(finalAngle - 90.0);
                int distanceFromCenter = (Integer)SkirkConfig.DIRECTIONAL_INDICATOR_DISTANCE.get();
                float indicatorX = (float)x + (float)((double)distanceFromCenter * Math.cos(radians2));
                float indicatorY = (float)y + (float)((double)distanceFromCenter * Math.sin(radians2));
                poseStack.pose().translate(indicatorX, indicatorY, 0.0f);
                Quaternionf quaternion = new Quaternionf(0.0, 0.0, Math.sin(radians / 2.0f), Math.cos(radians / 2.0f));
                poseStack.pose().mulPose(quaternion);
                poseStack.pose().translate(-indicatorX, -indicatorY, 0.0f);
                poseStack.blit(INDICATOR_TEXTURE, (int)(indicatorX - 50.0f), (int)(indicatorY - 50.0f), 0.0f, 0.0f, 100, 100, 100, 100);
                poseStack.pose().translate(indicatorX, indicatorY, 0.0f);
                poseStack.pose().mulPose(quaternion.invert());
                poseStack.pose().translate(-indicatorX, -indicatorY, 0.0f);
                poseStack.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                counter = 0.0f;
            }
        }
        poseStack.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static double calculateFinalAngle(Vec3 playerForward, Vec3 playerPosition, Vec3 damagePosition) {
        double playerAngle = Math.atan2(playerForward.x, playerForward.z) * 180.0 / Math.PI;
        Vec2 enemyVec = new Vec2((float)damagePosition.x, (float)damagePosition.z).add(new Vec2((float)playerPosition.x, (float)playerPosition.z).negated());
        double enemyAngle = Math.atan2(enemyVec.x, enemyVec.y) * 180.0 / Math.PI;
        double finalAngle = enemyAngle - playerAngle;
        return -finalAngle;
    }

    static {
        $assertionsDisabled = !IndicatorOverlay.class.desiredAssertionStatus();
        INDICATOR_TEXTURE = null;
        BLOOD_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"skirk", (String)"textures/overlays/blood_overlay.png");
        damageSource = null;
        showDirectional = false;
        counter = 0.0f;
        showBlood = false;
        bloodAlpha = 0.0f;
    }
}

