/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.event;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.gui.ConfigGui;
import com.github.yzqdev.skirkmod.gui.modify.ClickableToast;
import com.github.yzqdev.skirkmod.sound.SoundConf;
import com.github.yzqdev.skirkmod.sound.SoundConfUtil;
import com.github.yzqdev.skirkmod.sound.SoundItem;
import com.github.yzqdev.skirkmod.sound.SoundUtils;
import com.github.yzqdev.skirkmod.util.GlobalHelper;
import de.keksuccino.melody.resources.audio.MelodyAudioException;
import de.keksuccino.melody.resources.audio.SimpleAudioFactory;
import de.keksuccino.melody.resources.audio.openal.ALException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;

@EventBusSubscriber(modid="skirk", value={Dist.CLIENT})
public class ClientEvent {
    private static final Set<SoundEvent> playerHurtSounds = Set.of(SoundEvents.PLAYER_HURT, SoundEvents.PLAYER_HURT_DROWN, SoundEvents.PLAYER_HURT_FREEZE, SoundEvents.PLAYER_HURT_ON_FIRE, SoundEvents.PLAYER_HURT_SWEET_BERRY_BUSH);

    @SubscribeEvent
    public static void onScreenClosed(ScreenEvent.MouseButtonPressed.Post event) {
        Screen currentScreen = event.getScreen();
        if (currentScreen instanceof TitleScreen) {
            Minecraft client = Minecraft.getInstance();
            double mouseX = event.getMouseX();
            double mouseY = event.getMouseY();
            ClickableToast.getInstance().hide();
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CraftingScreen) {
            Button button = ImageButton.builder((Component)Component.literal((String)"s"), btn -> {
                SoundUtils.getAllSounds();
                Minecraft.getInstance().setScreen((Screen)new ConfigGui((Component)Component.translatable((String)"test")));
            }).size(20, 20).pos(250, 60).build();
            screen.renderables.add(button);
            event.addListener((GuiEventListener)button);
        }
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientEvent.checkVersion();
            SoundUtils.getAllSounds();
        });
    }

    private static void checkVersion() {
        Path versionTxt = SoundConfUtil.CONFIG_FOLDER.resolve("version.txt");
        try {
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById("skirk").orElseThrow();
            String newVersion = modContainer.getModInfo().getVersion().toString();
            if (!Files.exists(SoundConfUtil.CONFIG_FOLDER, new LinkOption[0])) {
                Files.createDirectory(SoundConfUtil.CONFIG_FOLDER, new FileAttribute[0]);
            }
            if (Files.exists(versionTxt, new LinkOption[0])) {
                String oldVersion = Files.readString(versionTxt);
                int result = GlobalHelper.compareVersions(oldVersion, newVersion);
                if (result < 0) {
                    SkirkModClient.LOGGER.info("old version smaller than new version, mod updated, copying sounds");
                    GlobalHelper.copySounds();
                } else if (result > 0) {
                    SkirkModClient.LOGGER.info("old version bigger than new version !");
                } else {
                    SkirkModClient.LOGGER.info("version not change");
                }
            } else {
                SkirkModClient.LOGGER.info("version file not exist, writting file");
                Files.writeString(versionTxt, (CharSequence)newVersion, new OpenOption[0]);
                GlobalHelper.copySounds();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlaySound(PlayLevelSoundEvent.AtEntity event) {
        Entity entity;
        SoundEvent soundEvent;
        Holder soundHolder = event.getSound();
        if (soundHolder != null && playerHurtSounds.contains(soundEvent = (SoundEvent)soundHolder.value()) && (entity = event.getEntity()) instanceof Player) {
            Player p = (Player)entity;
            if (p.level().isClientSide) {
                LocalPlayer player;
                if ((p.hurtTime != p.hurtDuration || p.hurtTime <= 0) && (player = Minecraft.getInstance().player) != null && p.getUUID().equals(player.getUUID())) {
                    return;
                }
                try {
                    SoundConf conf = SoundConfUtil.readSoundConf();
                    SoundItem lst = SoundUtils.CACHE.get(conf.getSelectSound());
                    Random random = new Random();
                    int randomIndex = random.nextInt(lst.getSoundPath().size());
                    String randomItem = lst.getSoundPath().get(randomIndex);
                    Minecraft.getInstance().execute(() -> {
                        try {
                            CompletableFuture clip = SimpleAudioFactory.ogg((String)randomItem, (SimpleAudioFactory.SourceType)SimpleAudioFactory.SourceType.LOCAL_FILE);
                            clip.thenAccept(v -> {
                                try {
                                    v.play();
                                }
                                catch (ALException e) {
                                    SkirkModClient.LOGGER.error(e.getMessage());
                                }
                            });
                        }
                        catch (MelodyAudioException e) {
                            SkirkModClient.LOGGER.error(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    SkirkModClient.LOGGER.error(e.getMessage());
                }
            }
        }
    }
}

