/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.gui;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.datagen.LangDefinition;
import com.github.yzqdev.skirkmod.gui.FlatColorButton;
import com.github.yzqdev.skirkmod.sound.SoundConf;
import com.github.yzqdev.skirkmod.sound.SoundConfUtil;
import com.github.yzqdev.skirkmod.sound.SoundItem;
import com.github.yzqdev.skirkmod.sound.SoundUtils;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigGui
extends Screen {
    Component content = Component.translatable((String)LangDefinition.change_sound_title);
    private final int packPerSize = 4;
    private final int soundPerSize = 13;
    private String selectSoundId = null;
    private int startX;
    private int startY;
    private int packPage = 0;
    private int soundPage = 0;
    private int packMaxPage = 0;
    private int soundMaxPage = 0;

    public ConfigGui(Component pTitle) {
        super(pTitle);
    }

    protected void init() {
        this.clearWidgets();
        try {
            Map<String, SoundItem> sounds = SoundUtils.CACHE;
            SoundConf conf = SoundConfUtil.readSoundConf();
            int offset = 1;
            for (Map.Entry<String, SoundItem> entry : sounds.entrySet()) {
                String soundId = entry.getKey();
                SoundItem soundItem = entry.getValue();
                System.out.println("Key = " + entry.getKey() + ", Value = " + String.valueOf(entry.getValue()));
                FlatColorButton colorButton = this.getFlatColorButton(offset, soundId, conf);
                this.addRenderableWidget((GuiEventListener)colorButton);
                ++offset;
            }
        }
        catch (Exception e) {
            SkirkModClient.LOGGER.error(e.getMessage());
            this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)"\u83b7\u53d6\u914d\u7f6e\u5931\u8d25"));
        }
        this.startX = (this.width - 400) / 2;
        this.startY = (this.height - 220) / 2;
        this.soundMaxPage = 0;
        super.init();
    }

    @NotNull
    private FlatColorButton getFlatColorButton(int offset, String soundId, SoundConf conf) {
        FlatColorButton colorButton = new FlatColorButton(10, 10 + 20 * offset, 40, 20, (Component)Component.translatable((String)soundId), b -> {
            FlatColorButton thisBtn = (FlatColorButton)b;
            this.selectSoundId = soundId;
            conf.setSelectSound(soundId);
            try {
                SoundConfUtil.saveSoundConf(conf);
            }
            catch (IOException e) {
                this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)"\u4fdd\u5b58\u5931\u8d25"));
            }
            thisBtn.setSelect(true);
            this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)("\u5207\u6362\u4e3a" + soundId + "\u58f0\u97f3")));
        });
        if (soundId.equals(conf.getSelectSound())) {
            colorButton.setSelect(true);
        }
        return colorButton;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int textureWidth = 208;
        int textureHeight = 156;
        pGuiGraphics.drawCenteredString(this.font, this.content, this.width / 2 - 10, 30, 15402245);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
    }
}

