/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.gui.modify;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClickableToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/tutorial");
    public static final int PROGRESS_BAR_WIDTH = 154;
    public static final int PROGRESS_BAR_HEIGHT = 1;
    public static final int PROGRESS_BAR_X = 3;
    public static final int PROGRESS_BAR_Y = 28;
    private Component title;
    @Nullable
    private Component message;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private long lastProgressTime;
    private float lastProgress;
    private float progress;
    private final boolean progressable;
    private static ClickableToast instance = new ClickableToast();
    private final int x = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 90;
    private final int y;
    private final int width = 180;
    private final int height = 40;

    private ClickableToast() {
        this((Component)Component.literal((String)"title"), (Component)Component.literal((String)"desc"), false);
    }

    public ClickableToast(Component pTitle, @Nullable Component pMessage, boolean pProgressable) {
        this.y = 100;
        this.title = pTitle;
        this.message = pMessage;
        this.progressable = pProgressable;
    }

    public ClickableToast setMessage(@Nullable Component title, Component desc) {
        this.title = title;
        this.message = desc;
        return this;
    }

    public static ClickableToast getInstance() {
        return instance;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + 180) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 40);
    }

    public int width() {
        return 140;
    }

    public void onClick() {
        System.out.println("Toast clicked! Perform an action here.");
    }

    public Toast.Visibility render(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        pGuiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        if (this.message == null) {
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.title, 30, 12, -11534256, false);
        } else {
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.title, 30, 7, -11534256, false);
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.message, 30, 18, -16777216, false);
        }
        if (this.progressable) {
            pGuiGraphics.fill(3, 28, 157, 29, -1);
            float f = Mth.clampedLerp((float)this.lastProgress, (float)this.progress, (float)((float)(pTimeSinceLastVisible - this.lastProgressTime) / 100.0f));
            int i = this.progress >= this.lastProgress ? -16755456 : -11206656;
            pGuiGraphics.fill(3, 28, (int)(3.0f + 154.0f * f), 29, i);
            this.lastProgress = f;
            this.lastProgressTime = pTimeSinceLastVisible;
        }
        return this.visibility;
    }

    public void hide() {
        this.visibility = Toast.Visibility.HIDE;
    }

    public void updateProgress(float pProgress) {
        this.progress = pProgress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Icons {
        MOVEMENT_KEYS(0, 0),
        MOUSE(1, 0),
        TREE(2, 0),
        RECIPE_BOOK(0, 1),
        WOODEN_PLANKS(1, 1),
        SOCIAL_INTERACTIONS(2, 1),
        RIGHT_CLICK(3, 1);

        private final int x;
        private final int y;

        private Icons(int pX, int pY) {
            this.x = pX;
            this.y = pY;
        }

        public void render(GuiGraphics pGuiGraphics, int pX, int pY) {
            RenderSystem.enableBlend();
            pGuiGraphics.blit(ResourceLocation.withDefaultNamespace((String)"toast/mouse"), pX, pY, 176 + this.x * 20, this.y * 20, 20, 20);
        }
    }
}

