/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.gui.modify;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LongSystemToast
implements Toast {
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private final SystemToastIds id;
    private Component title;
    private List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/system");

    public LongSystemToast(SystemToastIds pId, Component pTitle, Component pMessage) {
        this(pId, pTitle, (List<FormattedCharSequence>)LongSystemToast.nullToEmpty(pMessage), Math.max(160, 30 + Math.max(Minecraft.getInstance().font.width((FormattedText)pTitle), pMessage == null ? 0 : Minecraft.getInstance().font.width((FormattedText)pMessage))));
    }

    public static LongSystemToast multiline(Minecraft pMinecraft, SystemToastIds pId, Component pTitle, Component pMessage) {
        Font font = pMinecraft.font;
        List list = font.split((FormattedText)pMessage, 200);
        int i = Math.max(200, list.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(200));
        return new LongSystemToast(pId, pTitle, list, i + 30);
    }

    private LongSystemToast(SystemToastIds pId, Component pTitle, List<FormattedCharSequence> pMessageLines, int pWidth) {
        this.id = pId;
        this.title = pTitle;
        this.messageLines = pMessageLines;
        this.width = pWidth;
    }

    private static ImmutableList<FormattedCharSequence> nullToEmpty(@Nullable Component pMessage) {
        return pMessage == null ? ImmutableList.of() : ImmutableList.of((Object)pMessage.getVisualOrderText());
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public Toast.Visibility render(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        int i;
        if (this.changed) {
            this.lastChanged = pTimeSinceLastVisible;
            this.changed = false;
        }
        if ((i = this.width()) == 160 && this.messageLines.size() <= 1) {
            pGuiGraphics.blit(BACKGROUND_SPRITE, 0, 0, 0, 64, i, this.height());
        } else {
            int j = this.height();
            int k = 28;
            int l = Math.min(4, j - 28);
            this.renderBackgroundRow(pGuiGraphics, pToastComponent, i, 0, 0, 28);
            for (int i1 = 28; i1 < j - l; i1 += 10) {
                this.renderBackgroundRow(pGuiGraphics, pToastComponent, i, 16, i1, Math.min(16, j - i1 - l));
            }
            this.renderBackgroundRow(pGuiGraphics, pToastComponent, i, 32 - l, j - l, l);
        }
        if (this.messageLines == null) {
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.title, 18, 12, -256, false);
        } else {
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.title, 18, 7, -256, false);
            for (int j1 = 0; j1 < this.messageLines.size(); ++j1) {
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.messageLines.get(j1), 18, 18 + j1 * 12, -1, false);
            }
        }
        return (double)(pTimeSinceLastVisible - this.lastChanged) < (double)this.id.displayTime * pToastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private void renderBackgroundRow(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, int pWidth, int p_282371_, int p_283613_, int p_282880_) {
        int i = p_282371_ == 0 ? 20 : 5;
        int j = Math.min(60, pWidth - i);
        pGuiGraphics.blit(BACKGROUND_SPRITE, 0, p_283613_, 0, 64 + p_282371_, i, p_282880_);
        for (int k = i; k < pWidth - j; k += 64) {
            pGuiGraphics.blit(BACKGROUND_SPRITE, k, p_283613_, 32, 64 + p_282371_, Math.min(64, pWidth - k - j), p_282880_);
        }
        pGuiGraphics.blit(BACKGROUND_SPRITE, pWidth - j, p_283613_, 160 - j, 64 + p_282371_, j, p_282880_);
    }

    public void reset(Component pTitle, @Nullable Component pMessage) {
        this.title = pTitle;
        this.messageLines = LongSystemToast.nullToEmpty(pMessage);
        this.changed = true;
    }

    public SystemToastIds getToken() {
        return this.id;
    }

    public static void add(ToastComponent pToastComponent, SystemToastIds pId, Component pTitle, @Nullable Component pMessage) {
        pToastComponent.addToast((Toast)new LongSystemToast(pId, pTitle, pMessage));
    }

    public static void addOrUpdate(ToastComponent pToastComponent, SystemToastIds pId, Component pTitle, @Nullable Component pMessage) {
        LongSystemToast systemtoast = (LongSystemToast)pToastComponent.getToast(LongSystemToast.class, (Object)pId);
        if (systemtoast == null) {
            LongSystemToast.add(pToastComponent, pId, pTitle, pMessage);
        } else {
            systemtoast.reset(pTitle, pMessage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum SystemToastIds {
        TUTORIAL_HINT,
        NARRATOR_TOGGLE,
        WORLD_BACKUP,
        PACK_LOAD_FAILURE,
        WORLD_ACCESS_FAILURE,
        PACK_COPY_FAILURE,
        PERIODIC_NOTIFICATION,
        UNSECURE_SERVER_WARNING(10000L);

        final long displayTime;

        private SystemToastIds(long pDisplayTime) {
            this.displayTime = pDisplayTime;
        }

        private SystemToastIds() {
            this(3600000L);
        }
    }
}

