/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.animation;

import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.IAnimationFunction;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.effects.IAnimationEffect;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class AnimationEffect
implements IAnimationEffect {
    public float in;
    public float out;
    public float intensity;
    public float speed;
    public Type type;

    public AnimationEffect(float in, float out, float intensity, float speed, Type type) {
        this.in = in;
        this.out = out;
        this.type = type;
        this.intensity = intensity;
        this.speed = speed;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.in);
        buf.writeFloat(this.out);
        buf.writeFloat(this.intensity);
        buf.writeFloat(this.speed);
        buf.writeEnum((Enum)this.type);
    }

    public static AnimationEffect decode(FriendlyByteBuf buf) {
        float in = buf.readFloat();
        float out = buf.readFloat();
        float intensity = buf.readFloat();
        float speed = buf.readFloat();
        Type type = (Type)buf.readEnum(Type.class);
        return new AnimationEffect(in, out, intensity, speed, type);
    }

    @Override
    @Generated
    public float getIn() {
        return this.in;
    }

    @Generated
    public void setIn(float in) {
        this.in = in;
    }

    @Override
    @Generated
    public float getOut() {
        return this.out;
    }

    public static abstract sealed class Type
    extends Enum<Type>
    implements IAnimationFunction {
        public static final /* enum */ Type WAVE = new Type(){

            @Override
            public float calculate(AnimationEffect effect, float time) {
                return effect.intensity * Mth.cos((float)(effect.speed * time));
            }
        };
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private static Type[] $values() {
            return new Type[]{WAVE};
        }

        private static /* synthetic */ Type[] $values$() {
            return new Type[]{WAVE};
        }

        static {
            $VALUES = Type.$values$();
        }
    }
}

