/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.animation;

import net.minecraft.client.gui.GuiGraphics;
import org.joml.Quaternionf;

public class PoseUtils {
    public static void applyScale(GuiGraphics context, float scale) {
        context.pose().translate((float)context.guiWidth() / scale, (float)context.guiHeight() / scale, 0.0f);
        context.pose().scale(scale, scale, scale);
        context.pose().translate((float)context.guiWidth() / (-scale * scale), (float)context.guiHeight() / (-scale * scale), 0.0f);
    }

    public static void applyYRotation(GuiGraphics context, float scale, float objectWidth, float objectHeight, float rotY) {
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationXYZ(0.0f * d2r, rotY * d2r, 0.0f * d2r);
        float width = objectWidth / 2.0f;
        float height = objectHeight / 2.0f;
        context.pose().translate(width, height, 0.0f);
        context.pose().mulPose(quat);
        context.pose().translate(-width, -height, 0.0f);
    }

    public static void applyXRotation(GuiGraphics context, float scale, float objectWidth, float objectHeight, float rotX) {
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationXYZ(rotX * d2r, d2r, 0.0f * d2r);
        float width = objectWidth / 2.0f;
        float height = objectHeight / 2.0f;
        context.pose().translate(width, height, 0.0f);
        context.pose().mulPose(quat);
        context.pose().translate(-width, -height, 0.0f);
    }

    public static void applyZRotation(GuiGraphics context, float scale, float objectWidth, float objectHeight, float rotX) {
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationXYZ(0.0f * d2r, d2r, rotX * d2r);
        float width = objectWidth / 2.0f;
        float height = objectHeight / 2.0f;
        context.pose().translate(width, height, 0.0f);
        context.pose().mulPose(quat);
        context.pose().translate(-width, -height, 0.0f);
    }
}

