/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.animation;

import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.Binding;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.ColorUtils;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingFunctionArgs;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingManager;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingType;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.effects.IAnimationEffect;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class Transition
implements IAnimationEffect {
    private float in;
    private float out;
    private float startValue;
    private float endValue;
    private EasingType easingFunctionTypeCache;
    private Double easingFunctionArgCache;
    private Double2DoubleFunction easingFunction;

    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.in);
        buf.writeFloat(this.out);
        buf.writeFloat(this.startValue);
        buf.writeFloat(this.endValue);
        buf.writeEnum((Enum)this.easingFunctionTypeCache);
        buf.writeDouble(this.easingFunctionArgCache.doubleValue());
    }

    public static Transition decode(FriendlyByteBuf buf) {
        float in = buf.readFloat();
        float out = buf.readFloat();
        float startValue = buf.readFloat();
        float endValue = buf.readFloat();
        EasingType easingFunctionTypeCache = (EasingType)buf.readEnum(EasingType.class);
        double easingFunctionArgCache = buf.readDouble();
        return new Transition(in, out, easingFunctionTypeCache, startValue, endValue, easingFunctionArgCache);
    }

    public Transition(float in, float out, EasingType easing, float start, float end) {
        this.in = in;
        this.out = out;
        this.startValue = start;
        this.endValue = end;
        this.easingFunctionTypeCache = easing;
        this.easingFunctionArgCache = 1.0;
        this.easingFunction = EasingManager.getEasingFunction.apply(new EasingFunctionArgs(easing, null));
    }

    public Transition(float in, float out, EasingType easing, float start, float end, double elasticity) {
        this.in = in;
        this.out = out;
        this.startValue = start;
        this.endValue = end;
        this.easingFunctionTypeCache = easing;
        this.easingFunctionArgCache = elasticity;
        this.easingFunction = EasingManager.getEasingFunction.apply(new EasingFunctionArgs(easing, elasticity));
    }

    public float eval(Binding binding, float current) {
        double lerp = Mth.clamp((double)((double)(current - this.in) / (double)(this.out - this.in)), (double)0.0, (double)1.0);
        lerp = (Double)this.easingFunction.apply((Object)lerp);
        lerp = Mth.clamp((double)lerp, (double)0.0, (double)1.0);
        return binding == Binding.Color ? (float)ColorUtils.lerp((float)lerp, (int)this.startValue, (int)this.endValue) : (float)Mth.lerp((double)lerp, (double)this.startValue, (double)this.endValue);
    }

    @Override
    @Generated
    public float getIn() {
        return this.in;
    }

    @Override
    @Generated
    public float getOut() {
        return this.out;
    }

    @Generated
    public float getStartValue() {
        return this.startValue;
    }

    @Generated
    public float getEndValue() {
        return this.endValue;
    }
}

