/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.api;

import com.github.yzqdev.skirkmod.immersivedamageindicators.ImmersiveMessagesManager;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationTimeline;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.Binding;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingType;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.ObfuscateMode;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.OnPoseMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.OnRenderMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.TextAnchor;
import com.github.yzqdev.skirkmod.immersivedamageindicators.util.ImmersiveColor;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;

public class ImmersiveMessage {
    public Style style = Style.EMPTY;
    private MutableComponent text;
    public AnimationTimeline animation;
    public ImmersiveMessage subtext;
    public ImmersiveMessage parent;
    public boolean shadow = true;
    public boolean border;
    public float yLevel = 55.0f;
    public float xLevel = 0.0f;
    public float delay = 0.0f;
    private ObfuscateMode obfuscateMode = ObfuscateMode.NONE;
    private float obfuscateSpeed = 1.0f;
    public boolean typewriter = false;
    public boolean typewriterCenterAligned = false;
    public float typewriterSpeed = 1.0f;
    public MutableComponent typewriterCurrent = Component.literal((String)"");
    private float typewriterTicks;
    private int typewriterTimes = 1;
    private float obfuscateTicks;
    private int obfuscateTimes = 1;
    public TextAnchor anchor = TextAnchor.CENTER_CENTER;
    public TextAnchor align = TextAnchor.CENTER_CENTER;
    public int wrapMaxWidth = -1;
    public boolean background = false;
    public ImmersiveColor colorBackground = ImmersiveColor.BLACK.copy();
    public ImmersiveColor colorBorderTop = new ImmersiveColor(36, 1, 89, 255).mixWith(ImmersiveColor.WHITE, 0.1f);
    public ImmersiveColor colorBorderBot = new ImmersiveColor(25, 1, 53, 255);
    public float rainbow = -1.0f;
    public OnPoseMessage onPoseMessage;
    public OnRenderMessage onRenderMessage;
    public static final StreamCodec<ByteBuf, ImmersiveMessage> CODEC = new StreamCodec<ByteBuf, ImmersiveMessage>(){

        public ImmersiveMessage decode(ByteBuf byteBuf) {
            return ImmersiveMessage.decode(byteBuf);
        }

        public void encode(ByteBuf byteBuf, ImmersiveMessage tooltip) {
            tooltip.encode(byteBuf);
        }
    };

    private ImmersiveMessage() {
    }

    private void encode(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        buf.writeJsonWithCodec(Style.Serializer.CODEC, (Object)this.style);
        String str = Component.Serializer.toJson((Component)this.text, (HolderLookup.Provider)RegistryAccess.EMPTY);
        buf.writeUtf(str);
        this.animation.encode(buf);
        buf.writeBoolean(this.subtext != null);
        if (this.subtext != null) {
            this.subtext.encode((ByteBuf)buf);
        }
        buf.writeBoolean(this.shadow);
        buf.writeBoolean(this.border);
        buf.writeFloat(this.yLevel);
        buf.writeFloat(this.xLevel);
        buf.writeFloat(this.delay);
        buf.writeEnum((Enum)this.obfuscateMode);
        buf.writeFloat(this.obfuscateSpeed);
        buf.writeBoolean(this.typewriter);
        buf.writeBoolean(this.typewriterCenterAligned);
        buf.writeFloat(this.typewriterSpeed);
        buf.writeEnum((Enum)this.anchor);
        buf.writeEnum((Enum)this.align);
        buf.writeInt(this.wrapMaxWidth);
        buf.writeBoolean(this.background);
        buf.writeInt(this.colorBackground.getRGB());
        buf.writeInt(this.colorBorderTop.getRGB());
        buf.writeInt(this.colorBorderBot.getRGB());
        buf.writeFloat(this.rainbow);
    }

    private static ImmersiveMessage decode(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        ImmersiveMessage ths = new ImmersiveMessage();
        ths.style = (Style)buf.readJsonWithCodec(Style.Serializer.CODEC);
        String str = buf.readUtf();
        ths.text = Component.Serializer.fromJson((String)str, (HolderLookup.Provider)RegistryAccess.EMPTY);
        ths.animation = AnimationTimeline.decode(buf);
        boolean hasSubtext = buf.readBoolean();
        if (hasSubtext) {
            ths.subtext = ImmersiveMessage.decode((ByteBuf)buf);
            ths.subtext.parent = ths;
        }
        ths.shadow = buf.readBoolean();
        ths.border = buf.readBoolean();
        ths.yLevel = buf.readFloat();
        ths.xLevel = buf.readFloat();
        ths.delay = buf.readFloat();
        ths.obfuscateMode = (ObfuscateMode)buf.readEnum(ObfuscateMode.class);
        ths.obfuscateSpeed = buf.readFloat();
        ths.typewriter = buf.readBoolean();
        ths.typewriterCenterAligned = buf.readBoolean();
        ths.typewriterSpeed = buf.readFloat();
        ths.anchor = (TextAnchor)buf.readEnum(TextAnchor.class);
        ths.align = (TextAnchor)buf.readEnum(TextAnchor.class);
        ths.wrapMaxWidth = buf.readInt();
        ths.background = buf.readBoolean();
        ths.colorBackground = new ImmersiveColor(buf.readInt());
        ths.colorBorderTop = new ImmersiveColor(buf.readInt());
        ths.colorBorderBot = new ImmersiveColor(buf.readInt());
        ths.rainbow = buf.readFloat();
        return ths;
    }

    public static ImmersiveMessage builder(float duration, String text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = Component.literal((String)text);
        tooltip.style = Style.EMPTY;
        tooltip.animation = AnimationTimeline.builder(duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public static ImmersiveMessage builder(float duration, MutableComponent text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = text;
        tooltip.style = Style.EMPTY;
        tooltip.animation = AnimationTimeline.builder(duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public void render(GuiGraphics graphics, float deltaTicks) {
        this.render(graphics, deltaTicks, 0);
    }

    private void render(GuiGraphics graphics, float deltaTicks, int depth) {
        this.tick(deltaTicks);
        this.animation.advancePlayhead(deltaTicks / 20.0f);
        if (depth != 0 || !(this.animation.getCurrent() >= this.animation.duration)) {
            ImmersiveMessagesManager.getRenderer().render(this, graphics, deltaTicks);
            if (this.subtext != null) {
                this.subtext.render(graphics, deltaTicks, depth + 1);
            }
        }
    }

    public MutableComponent getText() {
        return this.typewriter ? this.typewriterCurrent.withStyle(this.style) : this.text.withStyle(this.style);
    }

    public MutableComponent getRawText() {
        return this.text.withStyle(this.style);
    }

    public ImmersiveMessage anchor(TextAnchor anchor) {
        this.anchor = anchor;
        return this;
    }

    public ImmersiveMessage y(float ylevel) {
        this.yLevel = ylevel;
        this.animation.withYPosition(ylevel);
        return this;
    }

    public ImmersiveMessage x(float xlevel) {
        this.xLevel = xlevel;
        this.animation.withXPosition(xlevel);
        return this;
    }

    public ImmersiveMessage size(float size) {
        this.animation.withSize(size);
        return this;
    }

    public ImmersiveMessage fadeIn() {
        return this.fadeIn(1.0f);
    }

    public ImmersiveMessage fadeIn(float duration) {
        this.animation.transition(Binding.Alpha, this.delay, this.delay + duration, 0.0f, 1.0f, EasingType.EaseOutSine);
        return this;
    }

    public ImmersiveMessage fadeOut() {
        return this.fadeOut(1.0f);
    }

    public ImmersiveMessage fadeOut(float duration) {
        this.animation.fadeout(duration);
        return this;
    }

    public ImmersiveMessage slideUp() {
        return this.slideUp(1.0f);
    }

    public ImmersiveMessage slideUp(float duration) {
        this.animation.transition(Binding.yPos, this.delay, this.delay + duration, this.yLevel + 50.0f, this.yLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage animation(Consumer<AnimationTimeline> animationBuilder) {
        animationBuilder.accept(this.animation);
        return this;
    }

    public void tick(float delta) {
        this.tickObfuscation(delta);
        this.tickTypewriter(delta);
    }

    private void tickTypewriter(float delta) {
        String str = this.text.getString();
        if (this.typewriterTimes <= str.length()) {
            this.typewriterTicks += delta;
            if (this.typewriterTicks > (float)this.typewriterTimes * (1.0f / this.typewriterSpeed)) {
                ++this.typewriterTimes;
                String current = str.substring(0, Math.min(str.length(), this.typewriterTimes));
                this.typewriterCurrent = Component.literal((String)current);
                char lastChar = current.charAt(current.length() - 1);
                if (lastChar == ',') {
                    this.typewriterTicks -= 3.0f / this.typewriterSpeed;
                } else if (lastChar == '.') {
                    this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
                } else if (lastChar == '\u00a7') {
                    this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
                } else if (lastChar == ' ') {
                    this.typewriterTicks += 1.0f / this.typewriterSpeed;
                    ++this.typewriterTimes;
                    this.typewriterCurrent = Component.literal((String)str.substring(0, Math.min(str.length(), this.typewriterTimes)));
                }
            }
        }
    }

    private void tickObfuscation(float delta) {
        this.obfuscateTicks += delta;
        if (this.obfuscateTicks > (float)this.obfuscateTimes * (1.0f / this.obfuscateSpeed)) {
            String str = this.text.getString();
            ++this.obfuscateTimes;
            switch (this.obfuscateMode) {
                case LEFT: {
                    this.text = Component.literal((String)str.replaceFirst("\u00a7k", ""));
                    break;
                }
                case RIGHT: {
                    int index = str.lastIndexOf("\u00a7k");
                    if (index == -1) break;
                    String var10 = str.substring(0, index);
                    this.text = Component.literal((String)(var10 + str.substring(index + 2)));
                    break;
                }
                case CENTER: {
                    int index = this.getClosestIndexToCenter(str, "\u00a7k");
                    if (index == -1) break;
                    String var9 = str.substring(0, index);
                    this.text = Component.literal((String)(var9 + str.substring(index + 2)));
                    break;
                }
                case RANDOM: {
                    ArrayList<Integer> occurrences = new ArrayList<Integer>();
                    for (int i = 0; i <= str.length() - 2; ++i) {
                        if (!str.startsWith("\u00a7k", i)) continue;
                        occurrences.add(i);
                    }
                    if (occurrences.isEmpty()) break;
                    Random rand = new Random();
                    int index = (Integer)occurrences.get(rand.nextInt(occurrences.size()));
                    String var10001 = str.substring(0, index);
                    this.text = Component.literal((String)(var10001 + str.substring(index + 2)));
                }
            }
        }
    }

    private int getClosestIndexToCenter(String str, String target) {
        int centerIndex = str.length() / 2;
        int closestIndex = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i <= str.length() - target.length(); ++i) {
            int distanceFromCenter;
            if (!str.substring(i, i + target.length()).equals(target) || (distanceFromCenter = Math.abs(i - centerIndex)) >= minDistance) continue;
            closestIndex = i;
            minDistance = distanceFromCenter;
        }
        return closestIndex;
    }
}

