/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.particle;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationKeyframe;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationTimeline;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.Binding;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.ColorUtils;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.PoseUtils;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingType;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.ImmersiveMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.TextAnchor;
import com.github.yzqdev.skirkmod.immersivedamageindicators.foundation.ParticleRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2i;

public class DamageParticle
extends Particle {
    private static final List<Float> POSITIONS = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-0.25f), Float.valueOf(0.12f), Float.valueOf(-0.12f), Float.valueOf(0.25f)));
    private static final DecimalFormat DF2 = new DecimalFormat("#.##");
    private static final DecimalFormat DF1 = new DecimalFormat("#.#");
    private final Font fontRenderer;
    public final ImmersiveMessage message;
    public float fadeout;
    public float prevFadeout;
    public float visualDY;
    public float prevVisualDY;
    public float visualDX;
    public float prevVisualDX;
    public int opacity;

    public DamageParticle(ClientLevel clientLevel, double x, double y, double z, double amount, double dColor, double dz) {
        super(clientLevel, x, y, z);
        this.fontRenderer = Minecraft.getInstance().font;
        this.fadeout = -1.0f;
        this.prevFadeout = -1.0f;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        this.lifetime = 35;
        boolean isCrit = dz > 1.0;
        MutableComponent text = Component.literal((String)((amount < 0.0 ? "+" : "") + DF1.format(amount) + (isCrit && SkirkConfig.showExclamationPoint ? "!" : "")));
        this.xd = 0.0;
        this.yd = 1.0;
        double sqDz = Math.sqrt(dz);
        int defaultColor = SkirkConfig.textColor;
        int hurtColor = SkirkConfig.hurtColor;
        this.opacity = SkirkConfig.alpha;
        int startColor = ColorUtils.lerp(Mth.clamp((float)((float)dz / 1.25f), (float)0.0f, (float)1.0f), defaultColor, hurtColor);
        int endColor = ColorUtils.lerp(Mth.clamp((float)((float)dz / 4.0f), (float)(isCrit ? 0.75f : 0.0f), (float)1.0f), defaultColor, hurtColor);
        float endTime = (float)Math.max(1.0, dz * 4.5);
        this.message = ImmersiveMessage.builder(5.0f, text).anchor(TextAnchor.CENTER_CENTER).slideUp().fadeIn().size(1.0f).animation(anim -> {
            if (SkirkConfig.doSizeEffects) {
                anim.transition(Binding.Size, 0.0f, 1.0f, 0.0f, isCrit ? 3.0f : 2.0f, EasingType.EaseOutExpo);
                anim.transition(Binding.Size, 1.0f, 2.5f, isCrit ? 3.0f : 2.0f, isCrit ? 1.5f : 1.0f, EasingType.EaseInOutSine);
            }
            if (SkirkConfig.doColorEffects) {
                anim.transition(Binding.Color, 0.0f, endTime, startColor, endColor, EasingType.EaseOutSine);
            }
            if (SkirkConfig.doShakeEffects) {
                anim.waveEffect(Binding.zRot, (float)(isCrit ? 5.0 : 3.0 * sqDz), (float)(isCrit ? 20.0 : 5.0 * sqDz), 0.0f, 5.0f);
            }
        }).fadeOut();
        this.message.onPoseMessage = this::applyPose;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.getPosition();
        float particleX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float particleY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float particleZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        GuiGraphics graphics = new GuiGraphics(Minecraft.getInstance(), buffer);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).length();
        double inc = Mth.clamp((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        poseStack.translate(0.0, (1.0 + inc / 4.0) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationYXZ(camera.getYRot() * -d2r, camera.getXRot() * d2r, 0.0f);
        poseStack.mulPose(quat);
        float fadeout = Mth.lerp((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.translate((1.0 + inc) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.scale(-scale, -scale, scale);
        poseStack.translate(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.translate(0.0, -distanceFromCam / 10.0, 0.0);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        this.message.onRenderMessage = this::renderMessage;
        this.message.render(graphics, partialTicks);
        poseStack.popPose();
    }

    public void renderMessage(ImmersiveMessage tooltip, GuiGraphics graphics, FormattedText line, int yOffset) {
        Matrix4f mat = graphics.pose().last().pose();
        MultiBufferSource.BufferSource renderType = graphics.bufferSource();
        Font font = Minecraft.getInstance().font;
        float fade = (float)FastColor.ARGB32.alpha((int)tooltip.animation.getColor()) / 255.0f;
        int alpha = (int)Math.max(0.0f, Math.min((float)this.opacity, fade * (float)this.opacity));
        int color = tooltip.animation.getColor();
        font.drawInBatch(Language.getInstance().getVisualOrder(line), 0.0f, (float)yOffset, ColorUtils.color(alpha, ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color)), false, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.pose().translate(0.5, 0.5, 0.03);
        font.drawInBatch((Component)Component.literal((String)line.getString()), 0.0f, (float)yOffset, FastColor.ARGB32.color((int)alpha, (int)40, (int)40, (int)40), false, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public AnimationKeyframe applyPose(ImmersiveMessage message, AnimationTimeline animation, GuiGraphics context, Vector2i bgOffset, TextAnchor anchor, TextAnchor align, float objectWidth, float objectHeight) {
        AnimationKeyframe key = animation.getKeyframe();
        if (key.size != 1.0f) {
            context.pose().translate(objectWidth / 2.0f, objectHeight / 2.0f, 0.0f);
            context.pose().scale(key.size, key.size, key.size);
            context.pose().translate(objectWidth / -2.0f, objectHeight / -2.0f, 0.0f);
        }
        if (key.rotY != 0.0f) {
            PoseUtils.applyYRotation(context, key.size, objectWidth, objectHeight, key.rotY);
        }
        if (key.rotX != 0.0f) {
            PoseUtils.applyXRotation(context, key.size, objectWidth, objectHeight, key.rotX);
        }
        if (key.rotZ != 0.0f) {
            PoseUtils.applyZRotation(context, key.size, objectWidth, objectHeight, key.rotZ);
        }
        return key;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.age > (float)this.lifetime - length ? ((float)this.lifetime - (float)this.age) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY = (float)((double)this.visualDY + this.yd);
            this.prevVisualDX = this.visualDX;
            this.visualDX = (float)((double)this.visualDX + this.xd);
            if (Math.sqrt(Mth.square((double)((double)this.visualDX * 1.5)) + (double)Mth.square((float)(this.visualDY - 1.0f))) < 0.8999999999999999) {
                this.yd /= 2.0;
            } else {
                this.yd = 0.0;
                this.xd = 0.0;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        @SubscribeEvent
        public static void register(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleRegistry.DAMAGE_PARTICLE, Factory::new);
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DamageParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

