/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.util;

import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationKeyframe;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationTimeline;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.PoseUtils;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.TextAnchor;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;

public class AnimationUtil {
    public static AnimationKeyframe applyPose(AnimationTimeline animation, GuiGraphics context, Vector2i bgOffset, TextAnchor anchor, TextAnchor align, float objectWidth, float objectHeight) {
        AnimationKeyframe key = animation.getKeyframe();
        if (key.size != 1.0f) {
            PoseUtils.applyScale(context, key.size);
        }
        AnimationUtil.applyPosition(context, anchor, align, key.size, objectWidth, objectHeight, key.posX + (float)bgOffset.x, key.posY + (float)bgOffset.y, key.posZ);
        if (key.rotY != 0.0f) {
            PoseUtils.applyYRotation(context, key.size, objectWidth, objectHeight, key.rotY);
        }
        if (key.rotX != 0.0f) {
            PoseUtils.applyXRotation(context, key.size, objectWidth, objectHeight, key.rotX);
        }
        if (key.rotZ != 0.0f) {
            PoseUtils.applyZRotation(context, key.size, objectWidth, objectHeight, key.rotZ);
        }
        return key;
    }

    public static void applyPosition(GuiGraphics context, TextAnchor anchor, TextAnchor align, float scale, float objectWidth, float objectHeight, float posX, float posY, float posZ) {
        Vector2f offset = anchor.getOffset(context.guiWidth(), context.guiHeight(), objectWidth * scale, objectHeight * scale);
        Vector2f alignOffset = align.getAlign(objectWidth * scale, objectHeight * scale);
        offset = offset.add((Vector2fc)alignOffset);
        float centerX = posX / scale + offset.x / (2.0f * scale);
        float centerY = posY / scale + offset.y / (2.0f * scale);
        context.pose().translate(centerX, centerY, posZ);
    }
}

