/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.mixin;

import com.github.yzqdev.skirkmod.util.GlobalHelper;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public class CustomSkinMixin {
    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void getSkinTextureLocation(CallbackInfoReturnable<PlayerSkin> cir) {
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        List<String> usernames = List.of("dev", "steve", "alex", "yzqdev");
        String username = player.getName().getString().toLowerCase();
        if (GlobalHelper.isDevelopmentEnvironment() && usernames.contains(username)) {
            ResourceLocation customSkin = ResourceLocation.fromNamespaceAndPath((String)"skirk", (String)"textures/entity/ganyu.png");
            cir.setReturnValue((Object)new PlayerSkin(customSkin, null, null, null, PlayerSkin.Model.SLIM, true));
        }
    }
}

