/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.mixin;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.immersivedamageindicators.foundation.ParticleRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    private float lastHealth = 0.0f;
    private float damageTaken = 0.0f;
    private boolean particleDisplayedThisTick = false;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity.level().isClientSide()) {
            LivingEntity entity;
            float currentHealth;
            if (this.particleDisplayedThisTick) {
                this.particleDisplayedThisTick = false;
            }
            if (this.lastHealth > (currentHealth = (entity = (LivingEntity)this).getHealth()) && !this.particleDisplayedThisTick) {
                this.damageTaken = this.lastHealth - currentHealth;
            }
            this.lastHealth = currentHealth;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void afterTick(CallbackInfo ci) {
        LivingEntity inst = (LivingEntity)this;
        if (inst.level().isClientSide() && inst.getLastDamageSource() != null && inst.getLastDamageSource().getEntity() instanceof LocalPlayer) {
            double x = inst.getX();
            double y = inst.getY();
            double z = inst.getZ();
            if (!this.particleDisplayedThisTick && this.damageTaken > 0.0f) {
                Minecraft client = Minecraft.getInstance();
                LocalPlayer player = (LocalPlayer)inst.getLastDamageSource().getEntity();
                client.level.addParticle((ParticleOptions)ParticleRegistry.DAMAGE_PARTICLE, x, y, z, (double)this.damageTaken, 1.6777215E7, (double)SkirkModClient.LAST_ATTACK_SWING.getOrDefault(player.getUUID(), Float.valueOf(0.0f)).floatValue());
                this.damageTaken = 0.0f;
                this.particleDisplayedThisTick = true;
            }
        }
    }
}

