/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.mixin;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CherryParticle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={CherryParticle.class})
public abstract class MixinCherryLeavesParticle
extends TextureSheetParticle {
    @Shadow
    private float rotSpeed;
    @Shadow
    @Final
    private float particleRandom;
    @Shadow
    @Final
    private float spinAcceleration;

    @Overwrite
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        float g = Math.min((float)this.age / 300.0f, 1.0f);
        double d = Math.cos(Math.toRadians(this.spinAcceleration * 60.0f)) * 2.0 * Math.pow(g, 1.25);
        double e = Math.sin(Math.toRadians(this.spinAcceleration * 60.0f)) * 2.0 * Math.pow(g, 1.25);
        this.xd += d * (double)0.0025f;
        this.zd += e * (double)0.0025f;
        this.yd -= (double)this.gravity;
        this.rotSpeed += this.particleRandom / 20.0f;
        this.oRoll = this.roll;
        if (!this.onGround) {
            this.roll += this.rotSpeed / 20.0f;
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.removed) {
            return;
        }
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
        float a = Math.max(0.0f, (float)(this.lifetime - this.age - 1));
        this.alpha = Math.min(1.0f, a / 10.0f);
    }

    @Inject(method={"getRenderType"}, at={@At(value="RETURN")}, cancellable=true)
    private void returnTranslucentType(CallbackInfoReturnable<ParticleRenderType> callback) {
        callback.setReturnValue((Object)ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT);
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.rotation());
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        if (this.roll == 0.0f) {
            quaternionf = camera.rotation();
        } else {
            quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        Quaternionf quaternionf1 = new Quaternionf();
        if (!this.onGround) {
            quaternionf1.rotateY((float)Math.toRadians(this.age * 10 % 180 - 90));
            quaternionf1.rotateZ((float)Math.toRadians(55.0));
        }
        int i = this.getLightColor(partialTicks);
        float f = this.getQuadSize(partialTicks);
        float f1 = this.getU0();
        float f2 = this.getU1();
        float f3 = this.getV0();
        float f4 = this.getV1();
        this.renderVertexNew(buffer, quaternionf1, x, y, z, 1.0f, -1.0f, f, f2, f4, i);
        this.renderVertexNew(buffer, quaternionf1, x, y, z, 1.0f, 1.0f, f, f2, f3, i);
        this.renderVertexNew(buffer, quaternionf1, x, y, z, -1.0f, 1.0f, f, f1, f3, i);
        this.renderVertexNew(buffer, quaternionf1, x, y, z, -1.0f, -1.0f, f, f1, f4, i);
    }

    private void renderVertexNew(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
    }

    protected MixinCherryLeavesParticle(ClientLevel clientWorld, double x, double y, double z) {
        super(clientWorld, x, y, z);
    }
}

