/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.sound;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.sound.SoundConfUtil;
import com.github.yzqdev.skirkmod.sound.SoundItem;
import com.google.common.collect.Maps;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;

public class SoundUtils {
    public static final Map<String, SoundItem> CACHE = Maps.newLinkedHashMap();

    public static void getAllSounds() {
        CACHE.clear();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(SoundConfUtil.SOUND_FOLDER);){
            for (Path path : stream) {
                SoundItem item = new SoundItem();
                ArrayList<String> lst = new ArrayList<String>();
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                item.setSoundId(path.getFileName().toString());
                Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> lst.add(i.toString()));
                item.setSoundPath(lst);
                CACHE.put(item.getSoundId(), item);
            }
        }
        catch (Exception e) {
            SkirkModClient.LOGGER.error(e.getMessage());
        }
    }
}

