/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.util;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.sound.SoundConfUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.commons.io.FileUtils;

public class GlobalHelper {
    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean isVillagerInventoryEmpty(Villager villager) {
        for (int i = 0; i < villager.getInventory().getContainerSize(); ++i) {
            if (villager.getInventory().getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"skirk", (String)path);
    }

    public static void copyTexturesToConfig() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Predicate<ResourceLocation> filter = name -> name.getPath().endsWith(".ogg");
        try {
            Map resources = resourceManager.listResources("sounds/nilu", filter);
            Path configFolder = Path.of(Minecraft.getInstance().gameDirectory.getAbsolutePath(), "config", "skirk");
            if (!configFolder.toFile().exists()) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
                resources.forEach((resourceLocation, resourceSet) -> {
                    try {
                        InputStream inputStream = resourceSet.open();
                        Path destination = configFolder.resolve(resourceLocation.getPath());
                        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                        Files.copy(inputStream, destination, StandardCopyOption.REPLACE_EXISTING);
                        System.out.println("Copied sounds: " + String.valueOf(resourceLocation));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFolder(Path source, Path target) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            SkirkModClient.LOGGER.error("Source must be a directory");
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Files.walk(source, new FileVisitOption[0]).forEach(srcPath -> {
            try {
                String relativePath = source.relativize((Path)srcPath).toString();
                Path destPath = target.resolve(relativePath);
                System.out.println("Copying: " + String.valueOf(srcPath) + " -> " + String.valueOf(destPath));
                if (Files.isDirectory(srcPath, new LinkOption[0])) {
                    Files.createDirectories(destPath, new FileAttribute[0]);
                } else {
                    Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (IOException e) {
                SkirkModClient.LOGGER.error("Failed to copy: " + String.valueOf(srcPath), (Throwable)e);
            }
        });
    }

    public static void copyFolderUseCommons(Path source, Path target) throws IOException {
        System.out.println("Copying: " + String.valueOf(source.toAbsolutePath()) + " -> " + String.valueOf(target.toAbsolutePath()));
        FileUtils.copyDirectory((File)source.toFile(), (File)target.toFile());
    }

    public static void copySounds() {
        try {
            if (!Files.exists(SoundConfUtil.CONFIG_FOLDER, new LinkOption[0])) {
                Files.createDirectory(SoundConfUtil.CONFIG_FOLDER, new FileAttribute[0]);
                SkirkModClient.LOGGER.info("\u521b\u5efaskirk\u914d\u7f6e\u6587\u4ef6\u5939\u6210\u529f:{}", (Object)SoundConfUtil.CONFIG_FOLDER.toString());
                if (!Files.exists(SoundConfUtil.SOUND_FOLDER, new LinkOption[0])) {
                    Files.createDirectory(SoundConfUtil.SOUND_FOLDER, new FileAttribute[0]);
                }
            }
            Path from = Path.of(GlobalHelper.class.getClassLoader().getResource("sounds").toURI());
            Path to = SoundConfUtil.SOUND_FOLDER;
            GlobalHelper.copyFolder(from, to);
        }
        catch (Exception e) {
            SkirkModClient.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static BlockPos vec3ToBlockPos(Vec3 vec) {
        int x = (int)Math.floor(vec.x);
        int y = (int)Math.floor(vec.y);
        int z = (int)Math.floor(vec.z);
        return new BlockPos(x, y, z);
    }

    public static BlockPos vec3ToBlockPos(double x, double y, double z) {
        return new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }
}

