/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.github.yzqdev.skirkmod.damageindicator.DamageHandler;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class HealthBarRenderer {
    static final boolean $assertionsDisabled = !HealthBarRenderer.class.desiredAssertionStatus();

    public static void onRenderWorldStage(class_4184 camera) {
        if (!Boolean.valueOf(SkirkConfig.enableHealthBars).booleanValue()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        if (Boolean.valueOf(SkirkConfig.onlyShowTargetHealthBar).booleanValue()) {
            class_239 HitResult = mc.field_1765;
            if (HitResult instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)HitResult;
                int id = entityHitResult.method_17782().method_5628();
                HealthBarRenderer.renderHealthBar(id, (class_4597)bufferSource, camera);
                return;
            }
            return;
        }
        for (int entityId : DamageHandler.lastHealthForOtherEntities.keySet()) {
            HealthBarRenderer.renderHealthBar(entityId, (class_4597)bufferSource, camera);
        }
    }

    private static void renderHealthBar(int entityId, class_4597 bufferSource, class_4184 camera) {
        class_310 mc = class_310.method_1551();
        class_898 renderManager = mc.method_1561();
        class_327 fontRenderer = mc.field_1772;
        Matrix4f poseStack = new Matrix4f();
        class_638 level = class_310.method_1551().field_1687;
        if (!$assertionsDisabled && level == null) {
            throw new AssertionError();
        }
        class_1297 entity = level.method_8469(entityId);
        if (!DamageHandler.lastHealthForOtherEntities.containsKey(entityId)) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 entity2 = (class_1309)entity;
            float y = (float)(entity2.method_23318() + (double)entity2.method_17682() + (double)0.4f);
            if (!$assertionsDisabled && mc.field_1724 == null) {
                throw new AssertionError();
            }
            if (!HealthBarRenderer.hasLineOfSight((class_1309)mc.field_1724, mc.field_1724.method_37908(), (float)entity2.method_23317(), y, (float)entity2.method_23321(), 20.0)) {
                return;
            }
            poseStack.translate((float)(entity2.method_23317() - renderManager.field_4686.method_19326().field_1352), (float)((double)y - renderManager.field_4686.method_19326().field_1351), (float)(entity2.method_23321() - renderManager.field_4686.method_19326().field_1350));
            poseStack.rotate((Quaternionfc)camera.method_23767());
            poseStack.rotateY((float)Math.PI);
            poseStack.scale(-0.025f, -0.025f, 0.025f);
            class_327.class_6415 displayMode = class_327.class_6415.field_33994;
            String damage = String.valueOf(Math.round(DamageHandler.lastHealthForOtherEntities.get(entityId).floatValue()));
            String maxHealth = String.valueOf((int)Math.ceil(entity2.method_6063()));
            String text = damage + " / " + maxHealth;
            int color = new Color(255, 255, 255).getRGB();
            int textWidth = fontRenderer.method_1727(text);
            Objects.requireNonNull(fontRenderer);
            fontRenderer.method_27521(text, (float)(-textWidth) / 2.0f, -4.5f, color, false, poseStack, bufferSource, displayMode, 0, 0xF000F0);
        }
    }

    private static boolean hasLineOfSight(class_1309 player, class_1937 level, float x, float y, float z, double distance) {
        class_243 vec3 = new class_243((double)x, (double)y, (double)z);
        class_243 vec31 = new class_243(player.method_23317(), player.method_23320(), player.method_23321());
        return vec31.method_1022(vec3) <= distance && level.method_17742(new class_3959(vec3, vec31, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, class_3726.method_16194())).method_17783() == class_239.class_240.field_1333;
    }
}

