/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.damageindicator;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Quaternionf;

public class IndicatorOverlay {
    public static final int INDICATOR_TEXTURES_COUNT = 2;
    private static class_2960 INDICATOR_TEXTURE;
    private static final class_2960 BLOOD_OVERLAY;
    public static class_243 damageSource;
    public static boolean showDirectional;
    public static float counter;
    private static boolean showBlood;
    private static float bloodAlpha;
    private static final float BLOOD_FADE_SPEED = 0.02f;
    static final boolean $assertionsDisabled;

    public static void setup() {
        INDICATOR_TEXTURE = class_2960.method_60655((String)"skirk", (String)("textures/overlays/directional_indicator_" + SkirkConfig.directionalIndicatorTexture + ".png"));
    }

    public static void triggerOverlay(class_243 sourcePosition) {
        damageSource = sourcePosition;
        showDirectional = true;
        counter = 0.0f;
        showBlood = true;
        bloodAlpha = 1.0f;
    }

    public static void drawIndicatorOverlay(class_332 poseStack, class_1041 window) {
        int width = window.method_4486();
        int height = window.method_4502();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (!class_310.method_1551().field_1690.field_1842 && class_310.method_1551().field_1690.method_31044().method_31034()) {
            int x = width / 2;
            int y = height / 2;
            float deltaFrameTime = class_310.method_1551().method_60646().method_60636();
            if (showBlood && Boolean.valueOf(SkirkConfig.enableBloodOverlay).booleanValue()) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)BLOOD_OVERLAY);
                poseStack.method_51422(1.0f, 1.0f, 1.0f, bloodAlpha);
                bloodAlpha -= 0.02f * deltaFrameTime;
                if (bloodAlpha <= 0.0f) {
                    showBlood = false;
                    bloodAlpha = 0.0f;
                }
                poseStack.method_25293(BLOOD_OVERLAY, 0, 0, width, height, 0.0f, 0.0f, width, height, width, height);
            }
            if (showDirectional && Boolean.valueOf(SkirkConfig.enableDirectionalIndicator).booleanValue()) {
                if ((counter += deltaFrameTime) >= (float)Integer.valueOf(SkirkConfig.indicateTime).intValue()) {
                    showDirectional = false;
                }
                RenderSystem.setShader(class_757::method_34542);
                float r = (float)Integer.valueOf(SkirkConfig.directionalIndicatorR).intValue() / 255.0f;
                float g = (float)SkirkConfig.directionalIndicatorG / 255.0f;
                float b = (float)SkirkConfig.directionalIndicatorB / 255.0f;
                float a = (float)SkirkConfig.directionalIndicatorA / 255.0f;
                if (Boolean.valueOf(SkirkConfig.enableFadeOut).booleanValue()) {
                    a = a * ((float)Integer.valueOf(SkirkConfig.indicateTime).intValue() - counter) / (float)Integer.valueOf(SkirkConfig.indicateTime).intValue();
                }
                poseStack.method_51422(r, g, b, a);
                if (!$assertionsDisabled && class_310.method_1551().field_1724 == null) {
                    throw new AssertionError();
                }
                double finalAngle = IndicatorOverlay.calculateFinalAngle(class_310.method_1551().field_1724.method_5663(), class_310.method_1551().field_1724.method_19538(), class_310.method_1551().field_1724.method_19538().method_1019(damageSource.method_1020(class_310.method_1551().field_1724.method_19538())));
                float radians = (float)Math.toRadians(finalAngle);
                float radians2 = (float)Math.toRadians(finalAngle - 90.0);
                int distanceFromCenter = SkirkConfig.directionalIndicatorTexture;
                float indicatorX = (float)x + (float)((double)distanceFromCenter * Math.cos(radians2));
                float indicatorY = (float)y + (float)((double)distanceFromCenter * Math.sin(radians2));
                poseStack.method_51448().method_46416(indicatorX, indicatorY, 0.0f);
                Quaternionf quaternion = new Quaternionf(0.0, 0.0, Math.sin(radians / 2.0f), Math.cos(radians / 2.0f));
                poseStack.method_51448().method_22907(quaternion);
                poseStack.method_51448().method_46416(-indicatorX, -indicatorY, 0.0f);
                poseStack.method_25290(INDICATOR_TEXTURE, (int)(indicatorX - 50.0f), (int)(indicatorY - 50.0f), 0.0f, 0.0f, 100, 100, 100, 100);
                poseStack.method_51448().method_46416(indicatorX, indicatorY, 0.0f);
                poseStack.method_51448().method_22907(quaternion.invert());
                poseStack.method_51448().method_46416(-indicatorX, -indicatorY, 0.0f);
                poseStack.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                counter = 0.0f;
            }
        }
        poseStack.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static double calculateFinalAngle(class_243 playerForward, class_243 playerPosition, class_243 damagePosition) {
        double playerAngle = Math.atan2(playerForward.field_1352, playerForward.field_1350) * 180.0 / Math.PI;
        class_241 enemyVec = new class_241((float)damagePosition.field_1352, (float)damagePosition.field_1350).method_35586(new class_241((float)playerPosition.field_1352, (float)playerPosition.field_1350).method_35588());
        double enemyAngle = Math.atan2(enemyVec.field_1343, enemyVec.field_1342) * 180.0 / Math.PI;
        double finalAngle = enemyAngle - playerAngle;
        return -finalAngle;
    }

    static {
        $assertionsDisabled = !IndicatorOverlay.class.desiredAssertionStatus();
        INDICATOR_TEXTURE = null;
        BLOOD_OVERLAY = class_2960.method_60655((String)"skirk", (String)"textures/overlays/blood_overlay.png");
        damageSource = null;
        showDirectional = false;
        counter = 0.0f;
        showBlood = false;
        bloodAlpha = 0.0f;
    }
}

