/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.event;

import com.github.yzqdev.skirkmod.SkirkModClient;
import com.github.yzqdev.skirkmod.damageindicator.DamageHandler;
import com.github.yzqdev.skirkmod.damageindicator.DamageTextRenderer;
import com.github.yzqdev.skirkmod.damageindicator.HealthBarRenderer;
import com.github.yzqdev.skirkmod.damageindicator.IndicatorOverlay;
import com.github.yzqdev.skirkmod.event.CoolEntityEvents;
import com.github.yzqdev.skirkmod.gui.ConfigGui;
import com.github.yzqdev.skirkmod.gui.modify.ClickableToast;
import com.github.yzqdev.skirkmod.sound.SoundConf;
import com.github.yzqdev.skirkmod.sound.SoundConfUtil;
import com.github.yzqdev.skirkmod.sound.SoundItem;
import com.github.yzqdev.skirkmod.sound.SoundUtils;
import com.github.yzqdev.skirkmod.util.GlobalHelper;
import de.keksuccino.melody.resources.audio.MelodyAudioException;
import de.keksuccino.melody.resources.audio.SimpleAudioFactory;
import de.keksuccino.melody.resources.audio.openal.ALException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_479;
import net.minecraft.class_490;

public class ClientEvent {
    private static final Set<class_3414> playerHurtSounds = Set.of(class_3417.field_15115, class_3417.field_15205, class_3417.field_27853, class_3417.field_14623, class_3417.field_17614);

    public static String getModVersion() {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("skirk").orElseThrow();
        String fullVersion = mod.getMetadata().getVersion().getFriendlyString();
        String realVersion = fullVersion.split("-")[0];
        return realVersion == null ? "1.0.0" : realVersion;
    }

    private static void checkVersion() {
        Path versionTxt = SoundConfUtil.CONFIG_FOLDER.resolve("version.txt");
        try {
            String newVersion = ClientEvent.getModVersion();
            if (!Files.exists(SoundConfUtil.CONFIG_FOLDER, new LinkOption[0])) {
                Files.createDirectory(SoundConfUtil.CONFIG_FOLDER, new FileAttribute[0]);
            }
            if (Files.exists(versionTxt, new LinkOption[0])) {
                String oldVersion = Files.readString(versionTxt);
                int result = GlobalHelper.compareVersions(oldVersion, newVersion);
                if (result < 0) {
                    SkirkModClient.LOGGER.info("old version smaller than new version, mod updated, copying sounds");
                    GlobalHelper.copySounds();
                } else if (result > 0) {
                    SkirkModClient.LOGGER.info("old version bigger than new version !");
                } else {
                    SkirkModClient.LOGGER.info("version not change");
                }
            } else {
                SkirkModClient.LOGGER.info("version file not exist, writting file");
                Files.writeString(versionTxt, (CharSequence)newVersion, new OpenOption[0]);
                GlobalHelper.copySounds();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initSounds() {
        ClientEvent.checkVersion();
        SoundUtils.getAllSounds();
    }

    public static void init() {
        CoolEntityEvents.EntityHurtEvent.EVENT.register((entity, damageSource) -> {
            if (entity instanceof class_1657) {
                ClientEvent.playerHurtSound();
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> DamageHandler.onClientTick());
        WorldRenderEvents.AFTER_TRANSLUCENT.register((Object)new WorldRenderEvents.AfterTranslucent(){

            public void afterTranslucent(WorldRenderContext context) {
                DamageTextRenderer.onRenderWorldStage(context.camera().method_23767());
                HealthBarRenderer.onRenderWorldStage(context.camera());
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_310 client = class_310.method_1551();
            IndicatorOverlay.drawIndicatorOverlay(drawContext, client.method_22683());
        });
        ScreenEvents.AFTER_INIT.register((Object)new ScreenEvents.AfterInit(){

            public void afterInit(class_310 minecraft, class_437 screen, int i, int i1) {
                if (screen instanceof class_442) {
                    ClientEvent.initSounds();
                }
                if (screen instanceof class_490 || screen instanceof class_479) {
                    class_4185 button = class_344.method_46430((class_2561)class_2561.method_43470((String)"s"), btn -> {
                        SoundUtils.getAllSounds();
                        class_310.method_1551().method_1507((class_437)new ConfigGui((class_2561)class_2561.method_43471((String)"test")));
                    }).method_46437(20, 20).method_46433(250, 60).method_46431();
                    Screens.getButtons((class_437)screen).add(button);
                }
                ScreenMouseEvents.afterMouseClick((class_437)screen).register((Object)new ScreenMouseEvents.AfterMouseClick(this){

                    public void afterMouseClick(class_437 screen, double mouseX, double mouseY, int button) {
                        if (screen instanceof class_442) {
                            ClickableToast.getInstance().hide();
                        }
                    }
                });
            }
        });
    }

    static void playerHurtSound() {
        try {
            SoundConf conf = SoundConfUtil.readSoundConf();
            SoundItem lst = SoundUtils.CACHE.get(conf.getSelectSound());
            Random random = new Random();
            int randomIndex = random.nextInt(lst.getSoundPath().size());
            String randomItem = lst.getSoundPath().get(randomIndex);
            class_310.method_1551().execute(() -> {
                try {
                    CompletableFuture clip = SimpleAudioFactory.ogg((String)randomItem, (SimpleAudioFactory.SourceType)SimpleAudioFactory.SourceType.LOCAL_FILE);
                    clip.thenAccept(v -> {
                        try {
                            v.play();
                        }
                        catch (ALException e) {
                            SkirkModClient.LOGGER.error(e.getMessage());
                        }
                    });
                }
                catch (MelodyAudioException e) {
                    SkirkModClient.LOGGER.error(e.getMessage());
                }
            });
        }
        catch (Exception e) {
            SkirkModClient.LOGGER.error(e.getMessage());
        }
    }
}

