/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.particle;

import com.github.yzqdev.skirkmod.SkirkConfig;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationKeyframe;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.AnimationTimeline;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.Binding;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.ColorUtils;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.PoseUtils;
import com.github.yzqdev.skirkmod.immersivedamageindicators.animation.easing.EasingType;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.ImmersiveMessage;
import com.github.yzqdev.skirkmod.immersivedamageindicators.api.TextAnchor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2i;

public class DamageParticle
extends class_703 {
    private static final List<Float> POSITIONS = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-0.25f), Float.valueOf(0.12f), Float.valueOf(-0.12f), Float.valueOf(0.25f)));
    private static final DecimalFormat DF2 = new DecimalFormat("#.##");
    private static final DecimalFormat DF1 = new DecimalFormat("#.#");
    private final class_327 fontRenderer;
    public final ImmersiveMessage message;
    public float fadeout;
    public float prevFadeout;
    public float visualDY;
    public float prevVisualDY;
    public float visualDX;
    public float prevVisualDX;
    public int opacity;

    public DamageParticle(class_638 clientLevel, double x, double y, double z, double amount, double dColor, double dz) {
        super(clientLevel, x, y, z);
        this.fontRenderer = class_310.method_1551().field_1772;
        this.fadeout = -1.0f;
        this.prevFadeout = -1.0f;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        this.field_3847 = 35;
        boolean isCrit = dz > 1.0;
        class_5250 text = class_2561.method_43470((String)((amount < 0.0 ? "+" : "") + DF1.format(amount) + (isCrit && SkirkConfig.showExclamationPoint ? "!" : "")));
        this.field_3852 = 0.0;
        this.field_3869 = 1.0;
        double sqDz = Math.sqrt(dz);
        int defaultColor = SkirkConfig.textColor;
        int hurtColor = SkirkConfig.hurtColor;
        this.opacity = SkirkConfig.alpha;
        int startColor = ColorUtils.lerp(class_3532.method_15363((float)((float)dz / 1.25f), (float)0.0f, (float)1.0f), defaultColor, hurtColor);
        int endColor = ColorUtils.lerp(class_3532.method_15363((float)((float)dz / 4.0f), (float)(isCrit ? 0.75f : 0.0f), (float)1.0f), defaultColor, hurtColor);
        float endTime = (float)Math.max(1.0, dz * 4.5);
        this.message = ImmersiveMessage.builder(5.0f, text).anchor(TextAnchor.CENTER_CENTER).slideUp().fadeIn().size(1.0f).animation(anim -> {
            if (SkirkConfig.doSizeEffects) {
                anim.transition(Binding.Size, 0.0f, 1.0f, 0.0f, isCrit ? 3.0f : 2.0f, EasingType.EaseOutExpo);
                anim.transition(Binding.Size, 1.0f, 2.5f, isCrit ? 3.0f : 2.0f, isCrit ? 1.5f : 1.0f, EasingType.EaseInOutSine);
            }
            if (SkirkConfig.doColorEffects) {
                anim.transition(Binding.Color, 0.0f, endTime, startColor, endColor, EasingType.EaseOutSine);
            }
            if (SkirkConfig.doShakeEffects) {
                anim.waveEffect(Binding.zRot, (float)(isCrit ? 5.0 : 3.0 * sqDz), (float)(isCrit ? 20.0 : 5.0 * sqDz), 0.0f, 5.0f);
            }
        }).fadeOut();
        this.message.onPoseMessage = this::applyPose;
    }

    public void method_3074(class_4588 consumer, class_4184 camera, float partialTicks) {
        class_243 cameraPos = camera.method_19326();
        float particleX = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float particleY = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float particleZ = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        class_332 graphics = new class_332(class_310.method_1551(), buffer);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(particleX, particleY, particleZ);
        double distanceFromCam = new class_243((double)particleX, (double)particleY, (double)particleZ).method_1033();
        double inc = class_3532.method_15350((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        poseStack.method_22904(0.0, (1.0 + inc / 4.0) * (double)class_3532.method_16439((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationYXZ(camera.method_19330() * -d2r, camera.method_19329() * d2r, 0.0f);
        poseStack.method_22907(quat);
        float fadeout = class_3532.method_16439((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.method_22904((1.0 + inc) * (double)class_3532.method_16439((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.method_22905(-scale, -scale, scale);
        poseStack.method_22904(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.method_22904(0.0, -distanceFromCam / 10.0, 0.0);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        this.message.onRenderMessage = this::renderMessage;
        this.message.render(graphics, partialTicks);
        poseStack.method_22909();
    }

    public void renderMessage(ImmersiveMessage tooltip, class_332 graphics, class_5348 line, int yOffset) {
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        class_4597.class_4598 renderType = graphics.method_51450();
        class_327 font = class_310.method_1551().field_1772;
        float fade = (float)class_5253.class_5254.method_27762((int)tooltip.animation.getColor()) / 255.0f;
        int alpha = (int)Math.max(0.0f, Math.min((float)this.opacity, fade * (float)this.opacity));
        int color = tooltip.animation.getColor();
        font.method_22942(class_2477.method_10517().method_30934(line), 0.0f, (float)yOffset, ColorUtils.color(alpha, ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color)), false, mat, (class_4597)renderType, class_327.class_6415.field_33993, 0, 0xF000F0);
        graphics.method_51448().method_22904(0.5, 0.5, 0.03);
        font.method_30882((class_2561)class_2561.method_43470((String)line.getString()), 0.0f, (float)yOffset, class_5253.class_5254.method_27764((int)alpha, (int)40, (int)40, (int)40), false, mat, (class_4597)renderType, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public AnimationKeyframe applyPose(ImmersiveMessage message, AnimationTimeline animation, class_332 context, Vector2i bgOffset, TextAnchor anchor, TextAnchor align, float objectWidth, float objectHeight) {
        AnimationKeyframe key = animation.getKeyframe();
        if (key.size != 1.0f) {
            context.method_51448().method_46416(objectWidth / 2.0f, objectHeight / 2.0f, 0.0f);
            context.method_51448().method_22905(key.size, key.size, key.size);
            context.method_51448().method_46416(objectWidth / -2.0f, objectHeight / -2.0f, 0.0f);
        }
        if (key.rotY != 0.0f) {
            PoseUtils.applyYRotation(context, key.size, objectWidth, objectHeight, key.rotY);
        }
        if (key.rotX != 0.0f) {
            PoseUtils.applyXRotation(context, key.size, objectWidth, objectHeight, key.rotX);
        }
        if (key.rotZ != 0.0f) {
            PoseUtils.applyZRotation(context, key.size, objectWidth, objectHeight, key.rotZ);
        }
        return key;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.field_3866 > (float)this.field_3847 - length ? ((float)this.field_3847 - (float)this.field_3866) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY = (float)((double)this.visualDY + this.field_3869);
            this.prevVisualDX = this.visualDX;
            this.visualDX = (float)((double)this.visualDX + this.field_3852);
            if (Math.sqrt(class_3532.method_33723((double)((double)this.visualDX * 1.5)) + (double)class_3532.method_27285((float)(this.visualDY - 1.0f))) < 0.8999999999999999) {
                this.field_3869 /= 2.0;
            } else {
                this.field_3869 = 0.0;
                this.field_3852 = 0.0;
            }
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    public static class Factory
    implements class_707<class_2400> {
        public Factory(class_4002 spriteSet) {
        }

        public class_703 createParticle(class_2400 typeIn, class_638 worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DamageParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

