/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.skirkmod.immersivedamageindicators.util;

import net.minecraft.class_3532;

public class ImmersiveColor {
    public static final ImmersiveColor TRANSPARENT_BLACK = new ImmersiveColor(0, 0, 0, 0).setImmutable();
    public static final ImmersiveColor BLACK = new ImmersiveColor(0, 0, 0).setImmutable();
    public static final ImmersiveColor WHITE = new ImmersiveColor(255, 255, 255).setImmutable();
    public static final ImmersiveColor RED = new ImmersiveColor(255, 0, 0).setImmutable();
    public static final ImmersiveColor GREEN = new ImmersiveColor(0, 255, 0).setImmutable();
    public static final ImmersiveColor SPRING_GREEN = new ImmersiveColor(0, 255, 187).setImmutable();
    protected boolean mutable = true;
    protected int value;

    public ImmersiveColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ImmersiveColor(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public ImmersiveColor(float r, float g, float b, float a) {
        this((int)(0.5 + (double)(255.0f * class_3532.method_15363((float)r, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * class_3532.method_15363((float)g, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * class_3532.method_15363((float)b, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * class_3532.method_15363((float)a, (float)0.0f, (float)1.0f))));
    }

    public ImmersiveColor(int rgba) {
        this.value = rgba;
    }

    public ImmersiveColor copy() {
        return this.copy(true);
    }

    public ImmersiveColor copy(boolean mutable) {
        return mutable ? new ImmersiveColor(this.value) : new ImmersiveColor(this.value).setImmutable();
    }

    public ImmersiveColor setImmutable() {
        this.mutable = false;
        return this;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public float getRedAsFloat() {
        return (float)this.getRed() / 255.0f;
    }

    public float getGreenAsFloat() {
        return (float)this.getGreen() / 255.0f;
    }

    public float getBlueAsFloat() {
        return (float)this.getBlue() / 255.0f;
    }

    public float getAlphaAsFloat() {
        return (float)this.getAlpha() / 255.0f;
    }

    public int getRGB() {
        return this.value;
    }

    public ImmersiveColor scaleAlpha(float factor) {
        return this.ensureMutable().setAlphaUnchecked((int)((float)this.getAlpha() * class_3532.method_15363((float)factor, (float)0.0f, (float)1.0f)));
    }

    public ImmersiveColor mixWith(ImmersiveColor other, float weight) {
        return this.ensureMutable().setRedUnchecked((int)((float)this.getRed() + (float)(other.getRed() - this.getRed()) * weight)).setGreenUnchecked((int)((float)this.getGreen() + (float)(other.getGreen() - this.getGreen()) * weight)).setBlueUnchecked((int)((float)this.getBlue() + (float)(other.getBlue() - this.getBlue()) * weight)).setAlphaUnchecked((int)((float)this.getAlpha() + (float)(other.getAlpha() - this.getAlpha()) * weight));
    }

    protected ImmersiveColor ensureMutable() {
        return this.mutable ? this : new ImmersiveColor(this.value);
    }

    protected ImmersiveColor setRedUnchecked(int r) {
        this.value = this.value & 0xFF00FFFF | (r & 0xFF) << 16;
        return this;
    }

    protected ImmersiveColor setGreenUnchecked(int g) {
        this.value = this.value & 0xFFFF00FF | (g & 0xFF) << 8;
        return this;
    }

    protected ImmersiveColor setBlueUnchecked(int b) {
        this.value = this.value & 0xFFFFFF00 | (b & 0xFF) << 0;
        return this;
    }

    protected ImmersiveColor setAlphaUnchecked(int a) {
        this.value = this.value & 0xFFFFFF | (a & 0xFF) << 24;
        return this;
    }

    public static ImmersiveColor rainbowColor(int timeStep) {
        int localTimeStep = Math.abs(timeStep) % 1536;
        int timeStepInPhase = localTimeStep % 256;
        int phaseBlue = localTimeStep / 256;
        int red = ImmersiveColor.colorInPhase(phaseBlue + 4, timeStepInPhase);
        int green = ImmersiveColor.colorInPhase(phaseBlue + 2, timeStepInPhase);
        int blue = ImmersiveColor.colorInPhase(phaseBlue, timeStepInPhase);
        return new ImmersiveColor(red, green, blue);
    }

    private static int colorInPhase(int phase, int progress) {
        if ((phase %= 6) <= 1) {
            return 0;
        }
        if (phase == 2) {
            return progress;
        }
        return phase <= 4 ? 255 : 255 - progress;
    }
}

